#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/web')
import re, json, time, email
from subprocess import Popen, PIPE
from shutil import rmtree
from urllib import unquote_plus
from log_utils import writelog
from common import CFG, RE, getUUID
from email_utils import sendEmail
from rules_common import RULES_TYPES, RULES_DIRS, CheckingRepoContext, refreshRepo, createTmpDir

tmpDir = 'WORKING_DIR/temp/'
lockFile = "%semail-hook.lock" % tmpDir
res = payload = ''
PLUS_RE, PLUS3_RE = re.compile(u'^\+[^\n]*?$', re.M), re.compile(u'^\+{3} [^\n]+?$', re.M)
MINUS_RE, MINUS3_RE = re.compile(u'^\-[^\n]*?$', re.M), re.compile(u'^\-{3} [^\n]+?$', re.M)
ATAT_RE = re.compile(u'^(\@\@ .*? \@\@) (.*?)$', re.M)

try:
    content_length = int(os.environ['CONTENT_LENGTH'] if 'CONTENT_LENGTH' in os.environ else (os.environ['HTTP_CONTENT_LENGTH'] if 'HTTP_CONTENT_LENGTH' in os.environ else 0))
    if content_length:
        payload = sys.stdin.read(content_length)
    if not payload or len(payload) < 3:
        writelog("Invalid payload for the event '{0}'. Payload: {1}. Env: {2}.".format(os.environ['HTTP_X_GITHUB_EVENT'] if 'HTTP_X_GITHUB_EVENT' in os.environ else '', payload, str(os.environ)))
        sys.exit(1)
    if 'HTTP_USER_AGENT' not in os.environ or not os.environ['HTTP_USER_AGENT'] or not re.match(r'^GitHub[ -]Hookshot\b', os.environ['HTTP_USER_AGENT']):
        writelog('Repo changes hook: Request not from GitHub has detected. Processing has canceled. Env: %s.' % str(os.environ))
        sys.exit(1)
    try:
        payload = json.loads(payload)
    except Exception, e:
        try:
            s = unquote_plus(payload)
            if s.startswith("payload="):
                s = s[8:]
            payload = json.loads(s)
        except Exception, e:
            writelog("Repo changes hook: Error while parsing JSON: %s. Payload: %s. Env: %s." % (str(e), s, str(os.environ)), True)
            sys.exit(1)
except Exception, e:
    writelog("Repo changes hook's exception: %s" % str(e), True)

if 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'push':
    curDate, url, repoFolder, diff_log, c = time.strftime('%a, %d %b %Y %H:%M:%S %z'), payload['repository']['url'], getUUID(), '', ''
    url = re.sub(r'^https://{0}/'.format(CFG['github_host']), r'', url)
    repoFolder = "%s%s" % (tmpDir, createTmpDir(repoFolder, tmpDir, ''))
    with CheckingRepoContext(lockFile) as RepoLock:
        refreshRepo(repoFolder, True, url)
        for c in payload['commits']:
            d = c['timestamp']
            m = re.match('^(\d{4})-(\d\d)-(\d\d)[T\s](\d\d):(\d\d):(\d\d)\s*([+-]?\d+)\W(\d+).*?$', d)
            if m:
                d = u"{0}-{1}-{2} {3}:{4}:{5} {6}{7}".format(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6), m.group(7), m.group(8))
            output, rows, info = '', '', []
            try:
                (output, rows) = Popen('cd {0} && git diff --name-status {1}^ {1}'.format(repoFolder, c['id']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
            except Exception, e:
                writelog('Repo changes hook: Exception while git diff --name-status: %s' % str(e), True)
            if rows.strip() and re.search(r'error|fatal', rows.strip(), re.I):
                writelog("Repo changes hook: Git diff output: %s. Error: %s" % (output, rows))
                res += rows
            if output.strip():
                for row in output.strip().split('\n'):
                    m = re.match(r'^\s*([A-Z])\s+(.*?)$', row)
                    if m:
                        info.append('  {0}  <a href="{1}/blob/{2}/{3}">{3}</a>'.format(m.group(1), payload['repository']['url'], c['id'], m.group(2)))
                output = ''
            try:
                (output, rows) = Popen('cd {0} && git diff {1}^ {1}'.format(repoFolder, c['id']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
            except Exception, e:
                writelog('Repo changes hook: Exception while git diff: %s' % str(e), True)
            if rows.strip() and re.search(r'error|fatal', rows.strip(), re.I):
                writelog("Repo changes hook: Git diff output: %s. Error: %s" % (output, rows))
                res += rows
            output = MINUS3_RE.sub(u'<span style="color:#9F0000;"><b>\g<0></b></span>', PLUS3_RE.sub(u'<span style="color:#007F00;"><b>\g<0></b></span>', unicode(output, 'utf-8', 'ignore')))
            output = MINUS_RE.sub(u'<span style="color:#9F0000;">\g<0></span>', PLUS_RE.sub(u'<span style="color:#007F00;">\g<0></span>', output))
            output = ATAT_RE.sub(u'<span style="color:#0097C9;"><b>\g<1></b></span> <span style="color:#0097C9;">\g<2></span>', output)
            diff_log += u"""
<b>Commit:</b> <a href="{0}?diff=split">{1}</a>
<b>Author:</b> {2} <{3}>
<b>Date:</b> {4}

<b>Changed paths:</b>
{5}

<b>Log Message:</b>
------------
{6}

<b>Git Diff:</b>
---------
{7}

""".format(c['url'], c['id'], c['author']['name'], c['author']['email'], d, '\n'.join(info), RE['url'].sub(r'<a href="\g<0>">\g<0></a>', c['message']), output)
        try:
            rmtree(repoFolder)
        except Exception, e:
            writelog("Repo changes hook: Exception while removing temporary folder '%s': %s" % (repoFolder, str(e)), True)
        email_text = u"""<html><body><pre>
<b>Branch:</b> {0}
<b>Home:</b> <a href="{1}">{1}</a>
{2}

</pre></body></html>""".format(payload['ref'], payload['repository']['url'], diff_log)
        msg = email.message_from_string(email_text)
        msg['From'] = "{0} <{1}>".format(payload['head_commit']['author']['name'], payload['head_commit']['author']['email']) if payload['head_commit']['author']['email'] else payload['pusher']['email']
        msg['To'] = "spamstop-commits@yandex-team.ru"
        msg["Date"] = curDate
        msg["MIME-Version"] = "1.0"
        msg["Content-Type"] = 'text/html; charset="UTF-8"'
        msg["Subject"] = "[%s] Commits of code to GitHub" % url
        sendEmail(msg.as_string(), msg['From'], msg['To'])   # send pushed commits log to public maillist spamstop-commits\@mail.yandex-team.ru

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'pull_request':
    writelog('Repo changes hook: You have pull request: %s' % json.dumps(payload))

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'ping':
    writelog('Repo changes hook: You have ping request: %s' % json.dumps(payload))

print 'Content-Type: text/html; charset="UTF-8"\r\n\r\n%s' % res
