#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/web')
import re, json, time
from subprocess import check_output, call, Popen, PIPE, STDOUT
from multiprocessing.pool import Pool
from email.mime.text import MIMEText
from shutil import rmtree
from urllib import unquote_plus
from log_utils import writelog
from common import CFG, RE, getUUID
from email_utils import sendEmail
from rules_common import RULES_TYPES, RULES_DIRS, CheckingRepoContext, checkoutBranch, refreshRepo, verifyRules, createTmpDir, pullRepo, pushRepo
from Rules import collectRules

MAX_GIT_DIFF_LENGTH = 65536

repoFolder = RULES_DIRS['In'][0]
res = payload = c = ''
faultRulesTotal = 0
DIFF_RE = re.compile(u'^(diff --git) (a/\S+) (b/\S+)\s*$', re.M)
PLUS_RE, PLUS3_RE = re.compile(u'^\+[^\n]*?$', re.M), re.compile(u'^\+{3} [^\n]+?$', re.M)
MINUS_RE, MINUS3_RE = re.compile(u'^\-[^\n]*?$', re.M), re.compile(u'^\-{3} [^\n]+?$', re.M)
ATAT_RE = re.compile(u'^(\@\@ .*? \@\@)\s+(.*?)$', re.M)
RULES_SUCCESS_RE = re.compile(r'^\*{3} All success rules', re.M)
RULES_RESULTS_RE = re.compile(r'^(.*?(?:All\b|Rules cs:).*?)$', re.M)
RULES_FAULT_RE = re.compile(r'^(.*?\bfault\b.*?\brules: (\d+).*?)$', re.M|re.I)
RULES_SUBRESULTS_RE = re.compile(r'^(\*{3}\s.*?)$', re.M)
RULES_ERRORS_RE = re.compile(r'^(.*?Err.*?)$', re.M)
HEADER = u"""<html>
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <style>
    .rules-types {
      margin-bottom: 12px;
      font-size: .9rem;
    }
    .rules-types li {
      line-height: 1.2;
      padding-bottom: 10px;
    }
    ul, ul.option-list {
      list-style-type: none;
    }
    li {
      display: list-item;
      text-align: -webkit-match-parent;
    }
    a, details, li, ul {
      margin: 0;
      padding: 0;
      border: 0;
    }
    ul {
      display: block;
      list-style-type: none;
      margin-block-start: 1em;
      margin-block-end: 1em;
      margin-inline-start: 0px;
      margin-inline-end: 0px;
      padding-inline-start: 12px;
    }
    .rules-types details {
      margin-bottom: 10px;
      margin-left: 24px;
      padding-left: 10px;
    }
    details {
      margin-bottom: 12px;
      margin-left: 24px;
      display: block;
    }
    details summary {
        margin-left: -24px;
    }
    a i[class^=icon-]:before, label, summary {
      cursor: pointer;
    }
    summary {
      display: block;
    }
    .rules-types details summary:before {
      font-size: .6rem;
    }
    details[open]>summary:before {
      content: '\25BC\FE0E';
    }
    summary:before {
      display: inline-block;
      width: 20px;
      color: #3d7e9a;
      content: "▶︎";
    }
    .rules-types li li:first-child {
      padding-top: 10px;
    }
    .rules-types details li {
      padding-left: 0;
    }
    .rules-types li li {
      padding-bottom: 0;
      padding-left: 12px;
    }
  </style>
</head>
<body><pre>"""

def changeRow(row):
    r = RE["rules_folder"].sub(r' rules/', row)
    r = RE["rules_timestamp"].sub(r'', r)
    if RULES_SUCCESS_RE.match(r):
        r = '</details>\n<span style="color: #0F940F;"><b>{0}</b></span>'.format(r)
    elif RULES_ERRORS_RE.search(r):
        r = '<span style="color: #FF0000;"><b>{0}</b></span>'.format(r)
    else:
        m = RULES_FAULT_RE.search(r)
        if m and m.group(2) and int(m.group(2)) > 0:
            r = '<span style="color: #FF0000;"><b>{0}</b></span>'.format(r)
        elif RULES_RESULTS_RE.search(r):
            r = '<span style="color: #0F940F;"><b>{0}</b></span>'.format(r)
        elif RULES_SUBRESULTS_RE.search(r):
            r = '<span style="color: #9C4040;">{0}</span>'.format(r)
        elif r.startswith('Rules checking regime'):
            r = '</li>'
    return r

def uploadRulesBundleResource(route, routeInfo, tmpFolder, token):
    output, subfolder, addFolders = '', routeInfo['subfolder'], ' '.join(routeInfo['add_folders'])
    commits, info = ', '.join(routeInfo['commits']), '; '.join(routeInfo['info'])
    try:
        r = check_output("cd {0} && rm -f {1}/rules_{2}.tar.gz && find . -maxdepth 1 -type f | xargs tar -czf {1}/rules_{2}.tar.gz -C {0} {3}".format('%s/rules%s' % (tmpFolder, '/{0}'.format(subfolder) if subfolder else ''), tmpFolder, route.lower(), addFolders), stderr=STDOUT, shell=True, universal_newlines=True)
        if re.search(r'error|fatal', r, re.I):
            writelog("Error #%s while tar.gz-archive creation!" % r)
        t = route[2:].upper() if route.upper().startswith('SO') else route.upper()
        output = check_output('WORKING_DIR/sandbox_upload -b "{0}/rules_{1}.tar.gz" -t SO_{2}_RULES_BUNDLE -s {3} -o MAIL_SO -d "SO {2} rules bundle (commits: {4})" -l 14 -n -c "linux" -p stable -q "Autorelease of SO {2} rules bundle (commits: {4}, info: {5})" -m "WORKING_DIR/temp" -g rules -x -i {0}/rules_{1}_task_id -r {0}/rules_{1}_resource_id -u {0}/rules_{1}_resource_url'.format(tmpFolder, route.lower(), t, token, commits, info), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('uploadRulesBundleResource: Exception uploading rules bundle to SandBox (for "%s"): %s' % (route, str(e)), True)
    return output

def uploadRulesDictResource(route, routeInfo, tmpFolder, token):
    output = ''
    commits, info = ', '.join(routeInfo['commits']), '; '.join(routeInfo['info'])
    try:
        f = open("{0}/rules_dict_{1}.txt".format(tmpFolder, route.lower()), "w")
        print(collectRules(route.lower(), False), file=f)
        f.close()
        t = route[2:].upper() if route.upper().startswith('SO') else route.upper()
        output = check_output('WORKING_DIR/sandbox_upload -b "{0}/rules_dict_{1}.txt" -t SO_{2}_RULES_DICT -s {3} -o MAIL_SO -d "SO {2} rules dictionary (commits: {4})" -l 14 -c "linux" -p stable -q "Autorelease of SO {2} rules dictionary (commits: {4}, info: {5})" -m "WORKING_DIR/temp" -g rules -x -i {0}/rules_dict_{1}_task_id -r {0}/rules_dict_{1}_resource_id -u {0}/rules_dict_{1}_resource_url'.format(tmpFolder, route.lower(), t, token, commits, info), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('uploadRulesDictResource: Exception uploading rules dictionary to SandBox (for "%s"): %s' % (route, str(e)), True)
    return output

def uploadRulesResource((route, routeInfo, tmpFolder, token, resourceType)):
    if resourceType == "bundle":
        return uploadRulesBundleResource(route, routeInfo, tmpFolder, token)
    elif resourceType == "dict":
        return uploadRulesDictResource(route, routeInfo, tmpFolder, token)

def isTestRepoUsed(payload):
    for c in payload['commits']:
        for f in c["added"]:
            if f.startswith("test/"):
                return True
        for f in c["modified"]:
            if f.startswith("test/"):
                return True
        for f in c["removed"]:
            if f.startswith("test/"):
                return True
    return False

#######################################################################################################################
try:
    content_length = int(os.environ['CONTENT_LENGTH'] if 'CONTENT_LENGTH' in os.environ else (os.environ['HTTP_CONTENT_LENGTH'] if 'HTTP_CONTENT_LENGTH' in os.environ else 0))
    if content_length:
        payload = sys.stdin.read(content_length)
    if not payload or len(payload) < 3:
        writelog("Invalid payload for the event '{0}'. Payload: {1}. Env: {2}.".format(os.environ['HTTP_X_GITHUB_EVENT'] if 'HTTP_X_GITHUB_EVENT' in os.environ else '', payload, str(os.environ)))
        sys.exit(1)
    if 'HTTP_USER_AGENT' not in os.environ or not os.environ['HTTP_USER_AGENT'] or not re.match(r'^GitHub[ -]Hookshot\b', os.environ['HTTP_USER_AGENT']):
        writelog('Rules hook: Request not from GitHub has detected. Processing has canceled. Env: %s.' % str(os.environ))
        sys.exit(1)
    try:
        payload = json.loads(payload)
    except Exception, e:
        try:
            s = unquote_plus(payload)
            if s.startswith("payload="):
                s = s[8:]
            payload = json.loads(s)
        except Exception, e:
            writelog("Rules hook: Error while parsing JSON: %s. Payload: %s. Env: %s." % (str(e), s, str(os.environ)), True)
            sys.exit(1)
except Exception, e:
    writelog("Rules hook exception: %s" % str(e), True)

if 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'push' and payload['ref'] == 'refs/heads/master':
    curDate, url, diff_log, c = time.strftime('%a, %d %b %Y %H:%M:%S %z'), payload['repository']['url'], '', ''
    url = re.sub(r'^https://{0}/'.format(CFG['github_host']), r'', url)
    rulesDir = os.environ['HTTP_X_GITHUB_DELIVERY'] if 'HTTP_X_GITHUB_DELIVERY' in os.environ and os.environ['HTTP_X_GITHUB_DELIVERY'] else getUUID()
    with CheckingRepoContext(CFG["so_rules"]['check_lock_path']) as RulesLock:
        checkoutBranch(repoFolder)
        refreshRepo(repoFolder)
        # verification of rules in mail/spamstop/data
        isTestRepo = isTestRepoUsed(payload)
        for (route, title) in map(lambda rt: (rt[0], rt[1]), RULES_TYPES):
            if not isTestRepo and route.startswith("Test_"):
                continue
            resText, faultRulesCnt = verifyRules(rulesDir, route)
            res += u"<li class='toggle'><details open><summary><b>Проверка правил %s</b></summary>\n<details><summary>Подробности статистики по файлам правил</summary>%s</details></li>\n" % (title, '\n'.join(map(lambda r: changeRow(r), resText.strip().split('\n'))))
            faultRulesTotal += faultRulesCnt
        # composing and sending email
        if faultRulesTotal:  # send pushed commits log to author in a case of failed rules verification
            #try:
            #    c = check_output('cd %s && git reset --hard HEAD^' % repoFolder, stderr=STDOUT, shell=True, universal_newlines=True)
            #except Exception, e:
            #    writelog('Exception while "git reset --hard HEAD^": %s' % str(e), True)
            email_text = u"""{0}
<div class="rules-types" id="rules-types"><ul>
{1}
</ul></div>
{2}
</pre></body></html>""".format(HEADER, res, c if c else '')
            msg = MIMEText(email_text, _charset='utf8')
            msg["From"] = CFG['robot']['name']
            msg['To'] = payload['head_commit']['author']['email']
            msg["Date"] = curDate
            msg["MIME-Version"] = "1.0"
            msg["Content-Type"] = 'text/html; charset="UTF-8"'
            msg["Subject"] = "[%s] Rules verification report" % url
            s = sendEmail(msg.as_string(), msg['From'], msg['To'])
            writelog("Rules hook: Rules have {} faults, sendEmail answered: {}".format(faultRulesTotal, s))
        else:
            s, diff_log, subfolders, files, commitsMess = '', '', {}, {}, ''
            for c in payload['commits']:
                d = c['timestamp']
                m = re.match('^(\d{4})-(\d\d)-(\d\d)[T\s](\d\d):(\d\d):(\d\d)\s*([+-]?\d+)\W(\d+).*?$', d)
                if m:
                    d = u"{0}-{1}-{2} {3}:{4}:{5} {6}{7}".format(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6), m.group(7), m.group(8))
                output, rows, info = '', '', []
                try:
                    (output, rows) = Popen('cd {0} && git diff --name-status {1}^ {1}'.format(repoFolder, c['id']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
                except Exception, e:
                    writelog('Rules hook: Exception while git diff: %s' % str(e), True)
                if output.strip():
                    for row in output.strip().split('\n'):
                        m = re.match(r'^\s*([A-Z])\s+(.*?)$', row)
                        if m:
                            info.append('  {0}  <a href="{1}/blob/{2}/{3}">{3}</a>'.format(m.group(1), payload['repository']['url'], c['id'], m.group(2)))
                            file_path = m.group(2).rstrip()
                            files[file_path] = m.group(1)
                            n = file_path.rfind('/')
                            subfolder = file_path[:n] if n > -1 else ''
                            if subfolder in subfolders:
                                subfolders[subfolder][c['id']] = "'{}' ({})".format(c["message"], c["author"].get("username", c["author"]["name"]))
                            else:
                                subfolders[subfolder] = {str(c['id']): "'{}' ({})".format(c["message"], c["author"].get("username", c["author"]["name"]))}
                    output = ''
                try:
                    (output, rows) = Popen('cd {0} && git diff {1}^..{1}'.format(repoFolder, c['id']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
                except Exception, e:
                    writelog('Rules hook: Exception while git diff: %s' % str(e), True)
                #if rows.strip():
                #    writelog("Git diff output: %s. Error: %s" % (output, rows))
                if len(output) > MAX_GIT_DIFF_LENGTH:
                    output = output[:MAX_GIT_DIFF_LENGTH] + "\n\t<b>(truncated due to too big size of git diff)</b>"
                output = DIFF_RE.sub(u'<span style="color:#000000;"><b>\g<1></b></span> <span style="color:#9F0000;"><b>\g<2></b></span> <span style="color:#007F00;"><b>\g<3></b></span>', unicode(output, 'utf-8', 'ignore'))
                output = MINUS3_RE.sub(u'<span style="color:#9F0000;"><b>\g<0></b></span>', PLUS3_RE.sub(u'<span style="color:#007F00;"><b>\g<0></b></span>', output))
                output = MINUS_RE.sub(u'<span style="color:#9F0000;">\g<0></span>', PLUS_RE.sub(u'<span style="color:#007F00;">\g<0></span>', output))
                output = ATAT_RE.sub(u'<span style="color:#0097C9;"><b>\g<1></b></span> <span style="color:#0097C9;">\g<2></span>', output)
                diff_log += u"""
<b>Commit:</b> <a href="{0}?diff=split">{1}</a>
<b>Author:</b> {2} <{3}>
<b>Date:</b> {4}

<b>Changed paths:</b>
{5}

<b>Log Message:</b>
------------
{6}

<b>Rules verification report:</b>
--------------------------
{7}

<b>Git Diff:</b>
---------
{8}

""".format(c['url'], c['id'], c['author']['name'], c['author']['email'], d, '\n'.join(info), RE['url'].sub(u'<a href="\g<0>">\g<0></a>', c['message']), res, output)
            email_text = u"""{0}
<b>Branch:</b> {1}
<b>Home:</b> <a href="{2}">{2}</a>
{3}

</pre></body></html>""".format(HEADER, payload['ref'], payload['repository']['url'], diff_log)
            msg = MIMEText(email_text, _charset='utf8')
            msg['From'] = "{0} <{1}>".format(payload['head_commit']['author']['name'], payload['head_commit']['author']['email'])
            msg['To'] = "spamstop-commits@yandex-team.ru"
            msg["Date"] = curDate
            msg["MIME-Version"] = "1.0"
            msg["Content-Type"] = 'text/html; charset="UTF-8"'
            msg["Subject"] = "[%s] Commits of code to GitHub" % url
            # send pushed commits log to public maillist spamstop-commits@mail.yandex-team.ru
            s = sendEmail(msg.as_string(), msg['From'], msg['To'])
            writelog("Rules hook: Rules have no faults, sendEmail answered: %s" % s)
            # Pushing commits to stable branch
            cs = '{0}^..{1}'.format(payload['commits'][0]['id'], payload['commits'][-1]['id'])
            checkoutBranch(repoFolder, 'master')
            tmpFolder = '{0}/{1}'.format(CFG['rules_check_tmp_dir'], createTmpDir(rulesDir))
            tmpRulesDir = "%s/rules" % tmpFolder
            try:
                call("cp -a %s %s/" % (repoFolder, tmpFolder), shell=True)
            except Exception, e:
                writelog("Rules hook: Copying master branch of rules repo with new changes to temporary folder failed: %s" % str(e), True)
            c = checkoutBranch(repoFolder, 'stable')
            c += pullRepo(repoFolder)
            if re.search(r'reject|error|fatal', c, re.I):
                writelog('Rules hook: Pulling commits into stable branch from remote error: %s' % c)
            sf = {}
            for f in map(lambda (f, t): f, filter(lambda (f, t): t != 'D', files.items())):
                n = f.rfind('/')
                s = f[: n + 1] if n > -1 else ''
                if s in sf:
                    sf[s].append(f)
                else:
                    sf[s] = [f]
            try:
                call("cd {0} && {1}".format(tmpRulesDir, ' && '.join(map(lambda (s, fs): "mkdir -p {0}{1} && cp {2} {0}{1}".format(repoFolder, s, ' '.join(fs)), sf.items()))), shell=True)
            except Exception, e:
                writelog("Rules hook: Copying changes to stable branch of rules repo failed: %s" % str(e), True)
            try:
                deletes = filter(lambda (f, t): t == 'D', files.items())
                if len(deletes) > 0:
                    deleting_files = ' '.join(map(lambda (f, t): f, deletes))
                    c = check_output("cd {0} && git rm -f {1}".format(repoFolder, deleting_files), stderr=STDOUT, shell=True, universal_newlines=True)
                    if c:
                        writelog("Deleting files %s: %s" % (deleting_files, c), False)
            except Exception, e:
                writelog("Rules hook: Removing files {%s} from repo failed: %s" % (str(deletes), str(e)), True)
            try:
                c = check_output('cd {0} && git log --format=\%B --reverse {1}'.format(repoFolder, cs), stderr=STDOUT, shell=True, universal_newlines=True)
                commitsMess = '; '.join(filter(str, map(lambda s: s.strip().rstrip('.'), c.split('\n'))))
                (output, rows) = Popen('cd {0} && git add . 2>&1 && git commit -m"{1}" --author="{2}"'.format(repoFolder, commitsMess, CFG['robot']['name']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
            except Exception, e:
                writelog('Rules hook: Exception while git commit to stable branch: %s' % str(e), True)
            if re.search(r'reject|error|fatal', output, re.I):
                writelog('Rules hook: Committing into stable branch failed: %s' % output)
            else:
                if not commitsMess:
                    commitsMess = '; '.join(map(lambda c: "'{}' ({})".format(c["message"], c["author"].get("username", c["author"]["name"])), payload['commits']))
                c = pushRepo(repoFolder, 'stable')
                if re.search(r'reject|error|fatal', c, re.I):
                    writelog('Rules hook: Pushing commits in stable branch to remote error: %s' % c)
                routes = {}
                for (subfolder, commits) in subfolders.items():
                    if subfolder == "common":
                        for route in ['In', 'Out', 'Corp']:
                            commonFolder = ("../" if route == "Out" else "") + "common"
                            if route not in routes:
                                routes[route] = {
                                    "subfolder":   "outgoing" if route == "Out" else "",
                                    "add_folders": [commonFolder],
                                    "commits":     commits.keys(),
                                    "info":        commits.values()
                                }
                            if commonFolder not in routes[route]['add_folders']:
                                routes[route]['add_folders'].append(commonFolder)
                            if route == 'Corp':
                                routes[route]['add_folders'].append('local')
                            for commit in commits.keys():
                                if commit not in routes[route]['commits']:
                                    routes[route]['commits'].append(commit)
                                    routes[route]['info'].append(commits[commit])
                    elif subfolder == "test/common":
                        for route in ['Test_In', 'Test_Out', 'Test_Corp']:
                            commonFolder = ("../" if route == "Test_Out" else "") + "common"
                            if route not in routes:
                                routes[route] = {
                                    "subfolder":   "test/outgoing" if route == "Test_Out" else "test",
                                    "add_folders": [commonFolder],
                                    "commits":     commits.keys(),
                                    "info":        commits.values()
                                }
                            if commonFolder not in routes[route]['add_folders']:
                                routes[route]['add_folders'].append(commonFolder)
                            if route == 'Test_Corp':
                                routes[route]['add_folders'].append('test/local')
                            for commit in commits.keys():
                                if commit not in routes[route]['commits']:
                                    routes[route]['commits'].append(commit)
                                    routes[route]['info'].append(commits[commit])
                    else:
                        for (route, rulesDirs) in RULES_DIRS.items():
                            addFolders, subFolder = [], ''
                            if route == 'Out' and subfolder.startswith('outgoing') or route == 'Test_Out' and subfolder.startswith('test/outgoing'):
                                subFolder = ('test/' if subfolder.startswith('test/') else '') + 'outgoing'
                                if subfolder.endswith('/mn'):
                                    addFolders += ['mn']
                            if route == 'Corp' and subfolder.startswith('local') or route == 'Test_Corp' and subfolder.startswith('test/local'):
                                addFolders += ['local']
                                subFolder = ('test' if subfolder.startswith('test/') else '')
                                if subfolder.endswith('/mn'):
                                    addFolders += ['mn']
                            elif route == 'Sopassport' and subfolder.startswith('passport'):
                                subFolder = 'passport'
                                addFolders += ['lists', 'lists_sp']
                            elif route == 'Sostatip' and subfolder.startswith('statv6'):
                                subFolder = 'statv6'
                                addFolders += ['lists', 'rules']
                            else:
                                subFolder = subfolder
                                if subfolder.endswith('/mn'):
                                    addFolders += ['mn']
                            repoFolder2 = repoFolder + subFolder + ('/' if subFolder else '')
                            if repoFolder2 in rulesDirs:
                                if route not in routes:
                                    routes[route] = {
                                        'subfolder':   subFolder,
                                        'add_folders': list(addFolders),
                                        'commits':     commits.keys(),
                                        'info':        commits.values()
                                    }
                                for commit in commits.keys():
                                    if commit not in routes[route]['commits']:
                                        routes[route]['commits'].append(commit)
                                        routes[route]['info'].append(commits[commit])
                                for addFolder in ['mn', 'alg', 'rules', 'local', 'lists', 'lists_sp', '../lists']:
                                    if os.path.exists(repoFolder2 + addFolder) and addFolder not in routes[route]['add_folders']:
                                        routes[route]['add_folders'].append(addFolder)
                                if route in ['In', 'Out', 'Corp']:
                                    commonFolder = ("../" if route == "Out" else "") + "common"
                                    if commonFolder not in routes[route]['add_folders']:
                                        routes[route]['add_folders'].append(commonFolder)
                                elif route in ['Test_In', 'Test_Out', 'Test_Corp']:
                                    commonFolder = ("../" if route == "Test_Out" else "") + "common"
                                    if commonFolder not in routes[route]['add_folders']:
                                        routes[route]['add_folders'].append(commonFolder)
                            else:
                                writelog("Rules hook: route=%s, folder '%s' is not in list: %s" % (route, repoFolder2, rulesDirs))
                writelog("Rules hook: Changed subfolders: %s. Changed routes: %s" % (str(subfolders), str(routes)))
                workersCount = len(routes) + 1
                uploadParams = zip(routes.keys(), routes.values(), [tmpFolder] * len(routes), [os.environ['ROBOT_SANDBOX_TOKEN']] * len(routes), ["bundle"] * len(routes))
                for route in ['In', 'Out', 'Corp']:
                    if route in routes:
                        workersCount += 1
                        uploadParams.append((route, routes[route], tmpFolder, os.environ['ROBOT_SANDBOX_TOKEN'], "dict"))
                pool = Pool(workersCount)
                for output in pool.map(uploadRulesResource, uploadParams):
                    if output:
                        writelog("Rules hook: Uploading rules bundle to SandBox: %s" % output)
            checkoutBranch(repoFolder, 'master')
            try:
                rmtree(tmpFolder)
            except Exception, e:
                writelog('Rules hook: Exception while deleting of temporary folder "%s": %s' % (tmpFolder, str(e)), True)

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'push' and payload['ref'] == 'refs/heads/stable' and not res:
    res = u"Changes made by {0} <{1}>\nhave pushed to stable branch.".format(payload['head_commit']['author']['name'], payload['head_commit']['author']['email'])

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'pull_request':
    writelog('Rules hook: You have pull request: %s' % json.dumps(payload))

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'ping':
    writelog('Rules hook: You have ping request: %s' % json.dumps(payload))

elif 'HTTP_X_GITHUB_EVENT' in os.environ:
    writelog('Rules hook: You have %s request: %s' % (os.environ['HTTP_X_GITHUB_EVENT'], json.dumps(payload)))

else:
    writelog('Rules hook: You have unknown request: %s' % json.dumps(payload))

#print("HTTP/1.1 %s\r\n" % ('500 Internal Server Error' if faultRulesTotal else '200 OK'), end='')
try:
    print(u'Content-Type: text/html; charset="UTF-8"\r\n\r\n%s\r\n' % res, end='')
except:
    print(u'Content-Type: text/html; charset="UTF-8"\r\n\r\n', end='')

if faultRulesTotal:
    sys.exit(1)

