#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb, re, json
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
from datetime import datetime, timedelta
from collections import defaultdict
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog
from common import getNannyInstances
from db_utils import getPGCredentials, getPGdb

reload(sys)
sys.setdefaultencoding('utf-8')


# ----------------------- DB parameters -----------------------------
PG = {
    "host":    "iva-xb3w4z7jjjpuf8sd.db.yandex.net,myt-3mdnt0clvntgeqmv.db.yandex.net,sas-5nnjcnus304urap7.db.yandex.net",
    "port":    6432,
    "db":      "complaints",
    "user":    "cmpl"
}
CMPL = {
    'rtc_service': 'so_complaints',
    'cluster':     'so_complaint',
    'hosts':       'complaint1h.so.yandex.net,complaint1g.so.yandex.net,complaint1m.so.yandex.net'
}


def unquote(text):
    if not text or len(text) < 1:
        return u''
    s, i = u'', 0
    for m in re.finditer(r'%u([0-9a-fA-F]{4})', text):
        if m.start(0) > i:
            s += "".join(map(lambda c: unichr(ord(c)), text[i:m.start(0)]))
        s += unichr(int(m.group(1), 16))
        i = m.end(0)
    if i < len(text) - 1:
        s += text[i:].encode('utf-8', 'ignore')
    return s


def distinct(pg, key, filter_query):
    a = []
    try:
        pg_cursor = pg.cursor()
        where = 'WHERE {0}'.format(' AND '.join(lambda it: "%s='%s'" % (it[0], it[1]), filter_query.items())) if len(filter_query.keys()) > 0 else ''
        pg_cursor.execute("SELECT DISTINCT ON ({0}) {0} FROM compl_stat {1}".format(key, where))
        for row in pg_cursor.fetchall():
            a.append(row[0])
        pg_cursor.close()
    except Exception, e:
        writelog("Exception: %s" % str(e))
    return a


pg = {}
getPGCredentials(PG)
try:
    pg = getPGdb(PG)
except Exception, e:
    writelog("DB exception: %s" % str(e), True)

form = cgi.FieldStorage(keep_blank_values = True)
period, view_type = form.getfirst("period", ""), form.getfirst("view_type", "")
data, items, match, group = [], {'sources': [], 'footypes': [], 'seens': []}, {}, 'date'
counters = ['with_mail', 'empty_ip', 'http_200', 'http_4xx', 'http_499', 'http_5xx', 'http_other', 'total', 'min_time', 'max_time', 'accum_time']
counterTitles = ['With mail body', 'Empty IP', 'HTTP 200', 'HTTP 4xx', 'HTTP 499', 'HTTP 5xx', 'HTTP other', 'Total', 'Min Time', 'Max Time', 'Avg Time']

print "Content-type: text/html\r\n\r\n"

try:
    hosts = getNannyInstances(CMPL['rtc_service'], CMPL['hosts'].split(','))
    hosts.append('all')
    itemVal = {'source': form.getfirst('source'), 'footype': form.getfirst('footype'), 'seen': form.getfirst('seen'), 'host': form.getfirst('host')}
    if itemVal['footype']:
        itemVal['footype'] = unquote(itemVal['footype'])
    for itemKey in ['source', 'footype', 'seen']:
        query = {}
        for key in ['source', 'footype', 'seen']:
            if itemVal[key] != 'all' and itemVal[key] != None and key != itemKey:
                query[key] = itemVal[key]
        items[itemKey + 's'] = distinct(pg, itemKey, query)
        items[itemKey + 's'].append('all')
        if itemVal[itemKey] != 'all' and itemVal[itemKey] != None:
            match[itemKey] = itemVal[itemKey]
    if itemVal['host'] != 'all' and itemVal['host'] != None:
        match['host'] = itemVal['host']
    where = ' AND '.join(map(lambda it: "%s='%s'" % (it[0], it[1]), match.items())) if len(match.keys()) > 0 else ''
    where += (' AND ' if where else '') + "date >= '{0}'".format((datetime.today() - timedelta(days = (90 if period == "3month" else 30))).strftime("%Y-%m-%d"))
    for counter in counters:
        if counter == 'min_time':
            group += ', MIN(min_time) AS min_time'
        elif counter == 'max_time':
            group += ', MAX(max_time) AS max_time'
        else:
            group += ', SUM({0}) AS {0}'.format(counter)
    pg_cursor = pg.cursor()
    pg_cursor.execute("SELECT {0} FROM compl_stat WHERE {1} GROUP BY date ORDER BY date DESC".format(group, where))
    for row in pg_cursor.fetchall():
        r = {'date': row[0]}
        for i in range(1, len(row)):
            r[counters[i - 1]] = ("%.3f" % ((row[i] / row[8]) if row[8] else 0)) if counters[i - 1] == 'accum_time' else row[i]
        data.append(r)
    pg_cursor.close()
except Exception, e:
    writelog("Error: %s" % str(e), True)

host = "%s://%s/internal/" % ('http' + ('s' if os.environ.has_key('HTTPS') else ''), os.environ['SERVER_NAME'])
try:
    env = Environment(loader = FileSystemLoader("WORKING_DIR/web/internal"))
    template = env.get_template("input_complaints_monitoring.html.template")
    if view_type == 'graph':
        graph = []
        for i in range(len(counters)):
            graph.append({"valueField": counters[i], "title": counterTitles[i], "id": "graph_" + counters[i]})
        print template.render(sources = items['sources'], footypes = items['footypes'], seens = items['seens'], hosts = sorted(hosts),
                              data = json.dumps(sorted(data, cmp = lambda a, b: cmp(b['date'], a['date']), reverse = True)), graph = json.dumps(graph),
                              host = host, dates_count = len(data), view_type = view_type, counters = counters, counter_titles = counterTitles).encode("utf-8", "ignore")
    else:
        print template.render(sources = items['sources'], footypes = items['footypes'], seens = items['seens'], hosts = sorted(hosts),
                              data = data, host = host, view_type = view_type, counters = counters, counter_titles = counterTitles).encode("utf-8", "ignore")
except Exception, e:
    writelog("Exception caught (tell developer, please): %s" % str(e), True)

print "<html>\n<body>\n</body>\n</html>\n"
