#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import time, pymongo
from datetime import datetime
from collections import defaultdict
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog
from db_utils import loadMongoDbCredentials, getMongoDB


TYPES = { 0: "MSEARCH_SPAM", 1: "SO_OUT_SPAM", 2: "HACKED_BY_RULE", 3: "HACKED_BY_MANUAL",
          4: "CHANGE_PASSWORD", 5: "CHANGE_PASSWORD_FORCE", 6: "CHANGE_PASSWORD_STRONG",
          7: "CHANGE_PASSWORD_VOLUNTARILY" }
MONGO = {
    'db':      'journal',
    'hosts':   'sas-fxovfnlkhpwojehr.db.yandex.net,vla-f8vat6i2dl9fz4vc.db.yandex.net',
    'port':    27018,
    'user':    'journal',
    'timeout': 60000
}


def type2action( type ):
    if type in TYPES:
        return TYPES[ type ]
    else:
        return ""

def eval_default( expr, default ):
    try:
        return eval( expr )
    except:
        return default


loadMongoDbCredentials(MONGO)
journal = users = None
try:
    db = getMongoDB(MONGO)
    journal, users = db["journal"], db["users"]
except Exception, e:
    writelog("DB exception: %s" % str(e), True)

form = cgi.FieldStorage()
uid = eval_default( 'int( form.getfirst( "uid", "" ) )', "" )
login = form.getfirst( "login", "" ).lower()
date_min = eval_default( 'int( time.mktime( time.strptime( form.getfirst( "date_min", "" ), "%Y-%m-%d" ) ) )', "" )
date_max = eval_default( 'int( time.mktime( time.strptime( form.getfirst( "date_max", "" ), "%Y-%m-%d" ) ) )', "" )
type = eval_default( 'int( form.getfirst( "type", "" ) )', None )
limit = eval_default( 'int( form.getfirst( "limit", "" ) )', 20 )
sid669 = eval_default( 'int( form.getfirst( "sid669", "" ) )', "" )

rows, query = [], {}
if uid:
    query["uid"] = uid
elif login and users:
    user = users.find_one({"login": login})
    if user and "uid" in user:
        query["uid"] = int(user["uid"])
elif sid669 and users:
    uids = []
    for elem in users.find({"sid669": 1}, fields = ["uid"]):
        uids.append(int(elem["uid"]))
    query["uid"] = {"$in": uids}

if date_min or date_max:
    query["date"] = {}
    if date_min:
        query["date"]["$gte"] = date_min
    if date_max:
        query["date"]["$lte"] = date_max
if type is not None:
    query["type"] = type

cache = defaultdict(lambda: defaultdict(str))
if journal:
    for obj in journal.find(query, limit = limit):
        obj["action"] = type2action(obj["type"])
        obj["date"] = datetime.fromtimestamp(obj["date"]).strftime("%Y-%m-%d")
        uid = obj["uid"] if "uid" in obj else ""
        if uid not in cache and limit <= 2000:
            user = users.find_one({"uid": uid})
            cache[uid]["sid669"] = "Yes" if user and "sid669" in user else "No"
            cache[uid]["login"] = user["login"] if user and "login" in user else ""
        obj["sid669"] = cache[uid]["sid669"]
        obj["login"] = cache[uid]["login"]
        rows.append(obj)

print "Content-type:text/html\r\n\r\n"

try:
    env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
    template = env.get_template("journal.html.template")
    args = {}
    for key in form:
        args[key] = form.getfirst(key, "")
    args["rows"] = rows
    if "limit" not in args:
        args["limit"] = "20"
    print template.render(**args).encode("utf-8")
except Exception, e:
    writelog("Exception caught (tell developer, please): %s" % str(e), True)
