#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys
from time import strftime
from traceback import format_exception


def get_traceback(exc_type, exc_value, exc_traceback):
    tb = ''
    if exc_type or exc_value or exc_traceback:
        for step in format_exception(exc_type, exc_value, exc_traceback):
            try:
                tb += "\t" + step.strip() + "\n"
            except:
                pass
    return tb


def getTraceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    return get_traceback(exc_type, exc_value, exc_traceback)


def writelog(msg, isTB=False, fh=None, prefix='', isAddTS=True):
    if not msg:
        return
    if not fh:
        fh = sys.stderr
    try:
        tb = "\n"
        if isTB:
            tb += getTraceback()
        s = prefix + msg + tb
        if isAddTS:
            s = strftime("[%Y-%m-%d %H:%M:%S]: ") + s
        os.write(fh.fileno(), s)
    except UnicodeEncodeError:
        try:
            os.write(fh.fileno(), str(s.encode('utf-8')))
        except:
            os.write(fh.fileno(), str(s.encode('utf-8', 'ignore')))
    except Exception, e:
        print >>sys.stderr, "Writelog error: %s.%s" % (str(e), getTraceback())
        print >>sys.stderr, time.strftime("[%Y-%m-%d %H:%M:%S]: ") + msg + tb
        sys.stderr.flush()
