#!/usr/bin/env python2
# encoding: utf-8

import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, time
from psycopg2.sql import SQL, Identifier
from datetime import datetime
from collections import defaultdict
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog
from db_utils import getPGCredentials, getPGdb


DB_CONNECT_TIMEOUT = 10
PG = {
    "host":    "psndrdb01e.db.yandex.net,psndrdb01f.db.yandex.net,psndrdb01f.db.yandex.net",
    "port":    6432,
    "db":      "psndrdb",
    "user":    "psndr",
    "charset": "cp1251"
}
ORDERBY = defaultdict(str, { 1: "msgtime", 2: "sender", 3: "fromaddr", 4: "spam", 5: "ham", 6: "personal_spam", 7: "personal_ham",
    8: "compl_spam", 9: "compl_spam", 10: "compl_personal_spam", 11: "compl_personal_ham" })
GROUPBY = defaultdict(str, { 1: "sender,fromaddr", 2: "sender", 3: "fromaddr" })


def replace_link_param(uri, name, value):
    return u"%s&%s=%s" % (re.sub("%s=[^&$]" % name, "", uri, re.UNICODE), name, unicode(value))


today = datetime.today().strftime("%Y-%m-%d")

form, data = cgi.FieldStorage(), []
limit = min(2000, int(form.getfirst("limit", "200")))
date_min = form.getfirst("date_min", today)
date_max = form.getfirst("date_max", today)
paysender = form.getfirst("paysender", "")
fromaddr = form.getfirst("from", "")
orderby = int(form.getfirst("orderby", "0"))
groupby = int(form.getfirst("groupby", "0"))
orderby_field = ORDERBY[orderby]
groupby_field = GROUPBY[groupby]

query, where = SQL("SELECT "), SQL("")
params = (date_min, date_max)
if paysender:
    where += SQL(" AND sender = %s")
    params += (db.escape_string(paysender),)
if fromaddr:
    where += SQL(" AND fromaddr = %s")
    params += (db.escape_string(fromaddr),)

fields = map(Identifier, ["msgtime", "sender", "fromaddr", "spam", "ham", "personal_spam", "personal_ham", "compl_spam", "compl_ham", "compl_personal_spam", "compl_personal_ham"])
if groupby_field:
    where += SQL(" GROUP BY %s")
    params += (groupby_field,)
    fields_mod = fields[:]
    fields_mod[0] = SQL("COUNT(DISTINCT {0}) as {0}").format(Identifier("msgtime"))
    if groupby_field == "sender":
        fields_mod[2] = SQL("COUNT(DISTINCT {0}) as {0}").format(Identifier("fromaddr"))
    elif groupby_field == "fromaddr":
        fields_mod[1] = SQL("COUNT(DISTINCT {0}) as {0}").format(Identifier("sender"))
    for i in xrange(3, len(fields)):
        fields_mod[i] = SQL("SUM({0}) as {0}").format(fields[i])
    query += SQL(", ").join(fields_mod)
else:
    query += SQL(", ").join(fields)
query += SQL(" FROM psndr WHERE msgtime >= %s AND msgtime <= %s") + where
if orderby_field:
    query += SQL(" ORDER BY %s DESC")
    params += (orderby_field,)
query += SQL(" LIMIT %s")
params += (limit,)
try:
    getPGCredentials(PG)
    db, i = getPGdb(PG, mode='read-only'), 0
    cursor = db.cursor()
    cursor.execute("SET NAMES 'KOI8R'")
    cursor.execute(query, vars=params)
    data = cursor.fetchall()
    cursor.close()
except Exception, e:
    writelog("Exception: %s" % str(e), True)

rows = map(lambda elem: dict(zip(fields, elem)), data)
for row in rows:
    if type(row["msgtime"]) == datetime:
        row["msgtime"] = row["msgtime"].strftime("%Y-%m-%d")
    row["fromaddr"] = str(row["fromaddr"]).decode("koi8-r", "ignore")
    if groupby_field == "sender":
        uri = replace_link_param(os.environ["REQUEST_URI"], "paysender", row["sender"])
        row["fromaddr_link"] = replace_link_param(uri, "groupby", "1")
    else:
        uri = replace_link_param(os.environ["REQUEST_URI"], "paysender", "")
        row["fromaddr_link"] = replace_link_param(uri, "from", row["fromaddr"])
    if groupby_field == "fromaddr":
        uri = replace_link_param(os.environ["REQUEST_URI"], "from", row["fromaddr"])
        row["sender_link"] = replace_link_param(uri, "groupby", "1")
    else:
        uri = replace_link_param(os.environ["REQUEST_URI"], "from", "")
        row["sender_link"] = replace_link_param(uri, "paysender", row["sender"])

print "Content-type:text/html\r\n\r\n"

try:
    env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
    template = env.get_template("paysender.html.template")
    args = {}
    args["rows"] = rows
    for key in form:
        args[key] = form.getfirst(key, "")
    args["limit"] = limit
    args["date_min"] = date_min
    args["date_max"] = date_max
    args["paysender"] = paysender
    args["from"] = fromaddr
    args["orderby"] = orderby
    args["groupby"] = groupby
    print template.render(**args).encode("utf-8")
except Exception, e:
    writelog("Exception caught (tell developer, please): %s" % str(e), True)
