#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, email, json, time
from IPy import IP
from collections import defaultdict
from subprocess import call, Popen, PIPE
from jinja2 import Environment, FileSystemLoader
from common import getHosts4Group
from log_utils import writelog
from db_utils import redisReconnect, getMongoDB


GITREPO_FOLDER = 'WORKING_DIR/rules/'
IPS_LIST_FILE = 'statv6/lists/RBLmonitor.not'
IPS_LIST_PATH = GITREPO_FOLDER + IPS_LIST_FILE

REDIS = {
    'cluster': 'so_shingler',
    'hosts':   ["shingler1%s.mail.yandex.net" % dc for dc in "hgjmo"],
    'port':    6379,
    'db':      0,
    'hash':    'rbldnsd6'
}
REDIS['hosts'] = [[host, REDIS['port']] for host in getHosts4Group(REDIS['cluster'], REDIS['hosts'])]
MONGO = {
    'cluster': 'mail_sostatip_db',
    'port':    27017,
    'db':      'spstat',
    'hosts':   ','.join(["sostatip1%s.mail.yandex.net" % dc for dc in "hjm"]),
    'timeout': 2000
}


def read_config(filename):
    cfg, last_section = defaultdict(lambda: []), ''
    f = open(filename)
    for line in f:
        line = line.strip()
        if not line or re.match(r'\s*#', line):
            if line:
                cfg['comments'].append(line)
            continue
        m = re.match(r'\[\s*(\w+)\s*\]', line)
        if m and m.group(1):
            last_section = m.group(1)
            cfg[last_section] = []
            cfg['sections'].append(last_section)
        elif last_section:
            line = line[:(line.find('#') if line.find('#') > -1 else None)]
            cfg[last_section].append(line)
    f.close()
    return cfg


def write_config(filename, cfg, msg):
    f = open(filename, 'w')
    for line in cfg['comments']:
        f.write(line + "\n")
    if len(cfg['comments']) > 0:
        f.write("\n")
    for section in cfg['sections']:
        f.write("[%s]\n" % section)
        for line in cfg[section]:
            f.write(line + "\n")
        if section != cfg['sections'][-1]:
            f.write("\n")
    f.close()
    if not msg:
        msg = "new changes in the file %s" % IPS_LIST_FILE
    call('cd %s && git pull' % GITREPO_FOLDER, shell = True)
    if not call('cd %s && git add %s && git commit -m "RBL IPs monitoring script: %s"' % (GITREPO_FOLDER, IPS_LIST_FILE, msg), shell = True):
        call('cd %s && git pull' % GITREPO_FOLDER, shell = True)
    else:
        call('cd %s && git reset --hard' % GITREPO_FOLDER, shell = True)


form = cgi.FieldStorage()
action = form.getfirst("action", "show")
if action == 'check_ips':
    print "Content-type: application/json\r\n\r\n"
else:
    print "Content-type: text/html\r\n\r\n"
config = read_config(IPS_LIST_PATH)

if action == 'show':
    try:
        rediscli, ips, mon_ips, check_ips = redisReconnect(REDIS), [], [], []
        db = getMongoDB(MONGO)
        sync_info = db['sync_info'].find_one({'_id': 1})
        sortorder, is_redis_keys = form.getfirst("sort", "ip"), form.getfirst("redis", "")
        for ip in sorted(form.getfirst("ips_to_check", "").split()):
            m = re.match(r'\d+\.\d+\.\d+\.\d+', ip)
            ip0 = '::ffff:' + ip if m else ip
            check_ips.append({'ip': ip, 'in_redis': 'yes' if rediscli.hexists(REDIS['hash'], ip0) else 'no'})
        host = "%s://%s/internal/" % ('http' + ('s' if os.environ.has_key('HTTPS') else ''), os.environ['SERVER_NAME'])
        for ip in sorted(config['ips']):
            m = re.match(r'\d+\.\d+\.\d+\.\d+', ip)
            ip0 = '::ffff:' + ip if m else ip
            mon_ips.append({'ip': ip, 'in_redis': 'yes' if rediscli.hexists(REDIS['hash'], ip0) else 'no'})
        if is_redis_keys == '1':
            ips = rediscli.hkeys(REDIS['hash'])
        env = Environment(loader = FileSystemLoader("WORKING_DIR/web/internal"))
        template = env.get_template("rbl_ips_monitoring.html.template")
        print template.render(ips=ips, mon_ips=mon_ips, rcpts=config['rcpts'], sync_info=sync_info,
                              check_ips=sorted(check_ips, cmp=lambda a, b: cmp(a[sortorder], b[sortorder])), host=host).encode("utf-8")
    except Exception, e:
        writelog("Exception caught (tell developer, please): %s" % str(e), True)

elif action == 'add_ip':
    ip_str = form.getfirst("ip", "")
    if ip_str:
        ip = IP(ip_str)
        config['ips'].append(str(ip.strCompressed()))
        write_config(IPS_LIST_PATH, config, "added new IP-address '%s' for monitoring" % str(ip))

elif action == 'remove_ip':
    ip_str = form.getfirst("ip", "")
    if ip_str:
        try:
            ip = IP(ip_str)
            config['ips'].remove(str(ip.strCompressed()))
            write_config(IPS_LIST_PATH, config, "removed IP-address '%s' from monitoring" % str(ip))
        except Exception:
            pass

elif action == 'add_rcpt':
    rcpt = form.getfirst("rcpt", "")
    if rcpt:
        config['rcpts'].append(rcpt)
        write_config(IPS_LIST_PATH, config, "added new recipient '%s' to the list of recipients of monitoring's notifications" % rcpt)

elif action == 'remove_rcpt':
    rcpt = form.getfirst("rcpt", "")
    if rcpt:
        try:
            config['rcpts'].remove(rcpt)
            write_config(IPS_LIST_PATH, config, "removed recipient '%s' from the list of recipients of monitoring's notifications" % rcpt)
        except Exception:
            pass

elif action == 'monitor':
    writelog("Monitoring started")
    call('cd %s && git pull' % GITREPO_FOLDER, shell = True)
    rediscli, existed = redisReconnect(REDIS), defaultdict(lambda: '')
    for ip in config['ips']:
        m = re.match(r'\d+\.\d+\.\d+\.\d+', ip)
        if m: ip = '::ffff:' + ip
        if rediscli.hexists(REDIS['hash'], ip):
            existed[ip] = 1
            writelog("Found: %s" % ip)

    if len(existed) > 0:
        txt = "<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='ru'>\n" \
            "<head>\n\t<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />\n</head>\n" \
            "<body>\n\t<h4 style='white-space:nowrap;'>Данные IP-адреса были обнаружены в RBL-сервере, хотя они должны там отсутствовать:</h4>" \
            "\n\t<div><b>%s</b></div>\n</body>\n</html>" % '<br />'.join(sorted(existed.keys()))
        msg = email.message_from_string(txt)
        msg['Content-Type'] = 'text/html'
        msg['From'] = 'so-dev@yandex-team.ru'
        msg['To'] = ' '.join(map(lambda login: login + '@yandex-team.ru', config['rcpts']))
        msg['Subject'] = 'Мониторинг присутствия в RBL нежелательных IP-адресов'
        try:
            p = Popen(['/usr/sbin/sendmail', '-r', msg['From'], msg['To']], stdin=PIPE, stderr=sys.stdout)
            output, error_output = p.communicate(input = msg.as_string())
        except OSError as e:
            writelog("Sending mail failed: %s. Message:\n%s" % (str(e), msg.as_string())); sys.exit(1)
        writelog("Message has sended to '%s' successfully" % msg['To'])
    t = int(time.time() / 1800) * 1800
    if int(time.time() / 60) * 60 == t:
        db = getMongoDB(MONGO)
        sync_info, wrong_data, s = db['sync_info'].find_one({'_id': 1}), [], ""
        if 'banned_min_30min' in sync_info and sync_info['banned_min_30min'] and int(sync_info['banned_min']) > int(sync_info['banned_min_30min']):
            s += "<td>Забанено:</td><td>%d (min: %d)</td>" % (int(sync_info['banned_min_30min']), int(sync_info['banned_min']))
        elif 'banned_max_30min' in sync_info and sync_info['banned_max_30min'] and int(sync_info['banned_max']) < int(sync_info['banned_max_30min']):
            s += "<td>Забанено:</td><td>%d (max: %d)</td>" % (int(sync_info['banned_max_30min']), int(sync_info['banned_min']))
        if s: wrong_data.append(s)
        if 'added_ips_30min' in sync_info and sync_info['added_ips_30min']:
            s = ""
            if int(sync_info['added_min']) > int(sync_info['added_ips_30min']):
                s += "<td>Добавлено:</td><td>%d (min: %d)</td>" % (int(sync_info['added_ips_30min']), int(sync_info['added_min']))
            elif int(sync_info['added_max']) < int(sync_info['added_ips_30min']):
                s += "<td>Добавлено:</td><td>%d (max: %d)</td>" % (int(sync_info['added_ips_30min']), int(sync_info['added_max']))
            if s: wrong_data.append(s)
        if 'removed_ips_30min' in sync_info and sync_info['removed_ips_30min']:
            s = ""
            if int(sync_info['removed_min']) > int(sync_info['removed_ips_30min']):
                s += "<td>Удалено: %d</td><td>(min: %d)</td>" % (int(sync_info['removed_ips_30min']), int(sync_info['removed_min']))
            elif int(sync_info['removed_max']) < int(sync_info['removed_ips_30min']):
                s += "<td>Удалено: %d</td><td>(max: %d)</td>" % (int(sync_info['removed_ips_30min']), int(sync_info['removed_max']))
            if s: wrong_data.append(s)
        if len(wrong_data) > 0:
            txt = "<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='ru'>\n" \
                "<head>\n\t<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />\n</head>\n" \
                "<body>\n\t<h4 style='white-space:nowrap;'>Список недопустимых параметров динамики количества забаненных IP-адресов за период с %s по %s:</h4>" \
                "\n\t<table><tbody><tr>%s</tr></tbody></table>\n</body>\n</html>" % (time.strftime("%Y-%m-%d %H:%M", time.localtime(t - 1800)), \
                    time.strftime("%Y-%m-%d %H:%M", time.localtime(t)), '</tr><tr>'.join(wrong_data))
            msg = email.message_from_string(txt)
            msg['Content-Type'] = 'text/html'
            msg['From'] = 'so-dev@yandex-team.ru'
            msg['To'] = ' '.join(map(lambda login: login + '@yandex-team.ru', config['rcpts']))
            msg['Subject'] = 'Мониторинг динамики количества забаненных IP-адресов'
            try:
                p = Popen(['/usr/sbin/sendmail', '-r', msg['From'], msg['To']], stdin=PIPE, stderr=sys.stdout)
                output, error_output = p.communicate(input = msg.as_string())
            except OSError as e:
                writelog("Sending mail failed: %s. Message:\n%s" % (str(e), msg.as_string())); sys.exit(1)
            writelog("Message has sended to '%s' successfully" % msg['To'])
    writelog("Monitoring done")

elif action == 'check_ips':
    rediscli, check_ips, ips = redisReconnect(REDIS), [], form.getfirst("ips_to_check", "")
    try:
        for ip_str in sorted(ips.split()):
            try:
                ip, nslookup = IP(ip_str), ''
                ip0, iprev = str(ip.v46map()) if ip.version() == 4 else str(ip.strCompressed()), ip.reverseName()
            except Exception, e:
                writeLog("Error: %s" % str(e)); continue
            if iprev.find('.ip6') > 0: iprev = iprev[0:iprev.find('.ip6')]
            elif iprev.find('.in-addr') > 0: iprev = iprev[0:iprev.find('.in-addr')]
            else: iprev = ''
            if iprev:
                try:
                    output = Popen(['nslookup', "%s.spamsource.yandex.ru." % iprev, 'georbl.so.yandex.net'], stdout = PIPE).communicate()[0]
                    if output.find("** server can't find") > -1:
                        nslookup = 'no'
                    m = re.search(r'\nName:\s+\S+\s+Address:\s+(\S+)', output, re.S)
                    if m:
                        nslookup = m.group(1)
                except Exception, e:
                    writeLog("Error while nslookup: %s" % str(e))
            check_ips.append({
                'ip':       str(ip.strCompressed()),
                'in_redis': 'yes' if rediscli.hexists(REDIS['hash'], ip0) else 'no',
                'nslookup': nslookup
            })
        print json.dumps(check_ips)
    except Exception, e:
        writelog("Check IPs error: %s" % str(e), True)

elif action == 'check_syncing':
    sync_info = {}
    try:
        db = getMongoDB(MONGO)
        sync_info = db['sync_info'].find_one({'_id': 1})
        sync_info['banned_ips_count'] = db['banobj'].count({"sendtorbl": 1})
        sync_info['last_success_time'] = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(sync_info['last_success_sync']))
        sync_info['last_failed_time'] = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(sync_info['last_failed_sync'])) if 'last_failed_sync' in sync_info else ""
        if int(sync_info['last_success_sync']) >= int(time.time() - 300) and \
            ('last_failed_sync' not in sync_info or int(sync_info['last_failed_sync']) <= int(sync_info['last_success_sync'])):
                sync_info['color'] = 'green'
                sync_info['sync_state'] = u'Синхронизация есть'
        elif int(sync_info['last_success_sync']) >= int(time.time() - 600) and \
            ('last_failed_sync' not in sync_info or int(sync_info['last_failed_sync']) <= int(sync_info['last_success_sync'])):
                sync_info['color'] = 'yellow'
                sync_info['sync_state'] = u'Синхронизация есть'
        else:
            sync_info['color'] = 'red'
            sync_info['sync_state'] = u'Синхронизация нарушена'
    except Exception, e:
        writelog("Check syncing error: %s" % str(e), True)
    print json.dumps(sync_info)

elif action == 'apply_alarmers_params':
    try:
        db = getMongoDB(MONGO)
        sync_info = db['sync_info']
        params = {
            'banned_min':  form.getfirst("banned_min", None),
            'banned_max':  form.getfirst("banned_max", None),
            'added_min':   form.getfirst("added_min", None),
            'added_max':   form.getfirst("added_max", None),
            'removed_min': form.getfirst("removed_min", None),
            'removed_max': form.getfirst("removed_max", None)
        }
        sync_info.update({"_id": 1}, {"$set": params})
    except Exception, e:
        writelog("Applying alarmers params error: %s" % str(e), True)
else:
    print "<html>\n<body>\n</body>\n</html>\n"
