#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, fcntl
from bson.int64 import Int64
from subprocess import check_output, call, Popen, PIPE, STDOUT, CalledProcessError
from time import mktime, localtime, strftime
from datetime import date, timedelta
from collections import OrderedDict
from base64 import urlsafe_b64encode
from shutil import rmtree
from glob import glob
from log_utils import get_traceback, writelog
from db_utils import loadMongoDbCredentials, getMongoDB
from common import CFG, RE, getUUID


reload(sys)
sys.setdefaultencoding('utf-8')


HREF = {
    'showrule': '/showrule.py?rule='
}
RULES_TYPES = [
    [
        'In',
        u'Входящей почты',
        ['{}/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'spampf', 'ham', 'hampf', 'malic', 'spampercent', 'nopf', 'total', 'cmpl_spam_nopf', 'cmpl_spam_percent', 'cmpl_ham_nopf', 'cmpl_ham_percent']
    ], [
        'Out',
        u'Исходящей почты',
        ['{}/outgoing/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'spampf', 'ham', 'hampf', 'malic', 'spampercent', 'nopf', 'total', 'cmpl_spam_nopf', 'cmpl_spam_percent', 'cmpl_ham_nopf', 'cmpl_ham_percent']
    ], [
        'Corp',
        u'Корпоративной почты',
        ['{}/'.format(CFG["so_rules"]["folder"]), '{}/local/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'spampf', 'ham', 'hampf', 'malic', 'spampercent', 'nopf', 'total', 'cmpl_spam_nopf', 'cmpl_spam_percent', 'cmpl_ham_nopf', 'cmpl_ham_percent']
    ], [
        'Sosearch',
        u'Поиска по почте',
        ['{}/msearch/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'ham', 'malic', 'spampercent', 'total']
    ], [
        'Sopassport',
        u'Паспорта',
        ['{}/passport/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'ham', 'malic', 'spampercent', 'total']
    ], [
        'Socheckform',
        u'Проверки форм',
        ['{}/checkform/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'ham', 'malic', 'spampercent', 'total']
    ], [
        'Socheckmessages',
        u'Проверки коротких сообщений',
        ['{}/checkmessages/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'ham', 'malic', 'spampercent', 'total']
    ], [
        'Sostatip',
        u'Спамстата',
        ['{}/statv6/rules/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'ham', 'malic', 'spampercent', 'total']
    ], [
        'Test_In',
        u'Тестирования СО для входящей почты',
        ['{}/test/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'spampf', 'ham', 'hampf', 'malic', 'spampercent', 'nopf', 'total']
    ], [
        'Test_Out',
        u'Тестирования СО для исходящей почты',
        ['{}/test/outgoing/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'spampf', 'ham', 'hampf', 'malic', 'spampercent', 'nopf', 'total']
    ], [
        'Test_Corp',
        u'Тестирования СО для корп-ной почты',
        ['{}/test/'.format(CFG["so_rules"]["folder"]), '{}/test/local/'.format(CFG["so_rules"]["folder"])],
        ['spam', 'spampf', 'ham', 'hampf', 'malic', 'spampercent', 'nopf', 'total']
    ]
]

RULE_PARAM = dict(map(lambda rt: (rt[0], rt[3]), RULES_TYPES))
RULES_DIRS = dict(map(lambda rt: (rt[0], rt[2]), RULES_TYPES))

PARAM = {
    'spam':              ['Spam',   u'Количество спама', 'Spam', '#FF0000'],
    'spampf':            ['SpamPF', u'Количество спама с учётом персональных фильтров', 'SpamPF', '#FF6600'],
    'ham':               ['Ham', u'Количество хама', 'Ham', '#00FF00'],
    'hampf':             ['HamPF', u'Количество хама  с учётом персональных фильтров', 'HamPF', '#B0DE09'],
    'malic':             ['Malicious', u'Malicious', 'Malic', '#960018'],
    'spampercent':       ['Spam%', u'Процент спама', 'SpamPerc', '#FF9100'],
    'nopf':              ['noPF%', u'Процент спама без учета персональных фильтров', 'noPFperc', '#FF00C3'],
    'total':             ['Total', u'Всего', 'Total', '#0D8ECF'],
    'cmpl_spam_nopf':    [u'Кол-во жалоб<br/>на спам без ПФ<br/>(с ПФ)', u'Количество жалоб на спам без персональных фильтров (количество жалоб на спам с персональными фильтрами)', 'CmplSpam', '#550022'],
    'cmpl_spam_percent': [u'% от Ham', u'Процент жалоб на спам без персональных фильтров по отношению к хаму', 'CmplSpamPerc', '#9F0DCF'],
    'cmpl_ham_nopf':     [u'Кол-во жалоб<br/>на хам без ПФ<br/>(с ПФ)', u'Количество жалоб на хам без персональных фильтров (количество жалоб на хам с персональными фильтрами)', 'CmplHam', '#2A0CD0'],
    'cmpl_ham_percent':  [u'% от Spam', u'Процент жалоб на хам без персональных фильтров по отношению к спаму', 'CmplHamPerc', '#9FD00C']
}

MONGO_RULES = {
    'db':            'rules',
    'hosts':         'vla-hwmeehtmq450wvke.db.yandex.net,sas-agixxin7fbr78u0o.db.yandex.net,vlx-g9q00jkxh959zk6m.db.yandex.net',
    'port':          27018,
    'user':          'solog',
    'errorsLogFile': '/logs/so-web.log',
    'timeout':       120000,
    'db_type':       'mongodb'
}

AUTHOR = {
    'alex':           'Alexandr Kozlov <alex@yandex-team.ru>',
    'andy':           'Andrey Olokhtonov <andy@yandex-team.ru>',
    'bolotin':        'Evgeniy Bolotin <bolotin@yandex-team.ru>',
    'kerrik':         'Sergey Yudin <kerrik@yandex-team.ru>',
    'klimiky':        'Yaroslav Klimik <klimiky@yandex-team.ru>',
    'pvd':            'Valentin Petrov <pvd@yandex-team.ru>',
    'sgeorge':        'Georgy Shmarovoz <sgeorge@yandex-team.ru>',
    'asamoylov':      'Alexandr Samoylov <asamoylov@yandex-team.ru>',
    'luckybug':       'Vasily Lomanov <luckybug@yandex-team.ru>',
    'nimrod':         'Nikita Subbotin <nimrod@yandex-team.ru>',
    'robot-mailspam': CFG['robot']['name']
}


class CheckingRepoContext:
    def __init__(self, lockFile=CFG["so_rules"]['check_lock_path']):
        self.LOCK = None
        self.lockFile = lockFile
    def __enter__(self):
        try:
            self.LOCK = open(self.lockFile, 'w')
        except Exception, e:
            writelog("Error while opening file '%s' for writing: %s" % (self.lockFile, str(e)), True)
        try:
            fcntl.flock(self.LOCK, fcntl.LOCK_EX)
        except Exception, e:
            writelog("Unable to lock file '%s' (%s). Most likely web-hook process has already launched." % (self.lockFile, str(e)), True)
        return self.LOCK

    def __exit__(self, exc_type, exc_value, exc_traceback):
        if self.LOCK:
            try:
                fcntl.lockf(self.LOCK, fcntl.LOCK_UN)
                self.LOCK.close()
            except Exception, e:
                writelog("Error occured in finalizing checkingRepoContext: %s" % str(e), True)
        tb = get_traceback(exc_type, exc_value, exc_traceback)
        if tb:
            writelog("Error occured in the context of repository checking." + tb)
        return True


def checkoutRepo():
    s = RULES_DIRS['In'][0]
    try:
        s = check_output('cd {0} && git checkout master && GIT_SSH="WORKING_DIR/ssh-rules.sh" git pull -Xtheirs'.format(s), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('Exception while checking out of master branch of repository "%s": %s' % (s, str(e)), True)
    if re.search(r'reject|error|fatal', s, re.I):
        writelog('Pulling commits into master branch from remote error: %s' % s)


def checkoutBranch(repoFolder, branch='master'):
    output = ''
    try:
        output = check_output('cd {0} && git checkout {1}'.format(repoFolder, branch), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('Exception while git checkout "%s" for repo "%s": %s' % (branch, repoFolder, str(e)), True)
    #writelog("Done checkouting branch '%s' with result: '%s'" % (branch, output.strip()))
    return output


def cloneRepo(repoFolder, repoUrl):
    res = ''
    try:
        res = check_output('cd {0} && GIT_SSH="WORKING_DIR/ssh-rules.sh" git clone git@{1}:{2}.git .'.format(repoFolder, CFG['github_host'], repoUrl), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('Exception while git clone for repo "%s" into folder "%s": %s' % (repoUrl, repoFolder, str(e)), True)
    return res


def pullRepo(repoFolder):
    res = ''
    try:
        res = check_output('cd {0} && GIT_SSH="WORKING_DIR/ssh-rules.sh" git pull -Xtheirs'.format(repoFolder), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('Exception while git pull into repo "%s": %s' % (repoFolder, str(e)), True)
    #writelog("Done pulling repo '%s' with result: '%s'" % (repoFolder, res.strip()))
    return res


def pushRepo(repoFolder, branch='master'):
    res = ''
    try:
        res = check_output('cd {0} && GIT_SSH="WORKING_DIR/ssh-rules.sh" git push origin {1}'.format(repoFolder, branch), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('Exception while git push into repo "%s": %s' % (repoFolder, str(e)), True)
    return res


def refreshRepo(repoFolder, isClone=False, repoUrl=''):
    for i in range(CFG['retry_cnt']):
        res = cloneRepo(repoFolder, repoUrl) if isClone else pullRepo(repoFolder)
        if re.search(r'Permission denied (publickey)', res):
            try:
                res = check_output('ps -ef | grep "ssh-agent"', stderr=STDOUT, shell=True, universal_newlines=True)
            except Exception, e:
                writelog('refreshRepo for folder "%s": Exception while grep ssh-agent: %s' % (repoFolder, str(e)), True)
            if not res.strip():
                try:
                    res = check_output('eval "$(ssh-agent -s)" && ssh-add /home/klimiky/test/rules-key/id_rsa', stderr=STDOUT, shell=True, universal_newlines=True)
                except Exception, e:
                    writelog('refreshRepo for folder "%s": Exception while launching ssh-agent: %s' % (repoFolder, str(e)), True)
                if res.strip():
                    writelog("refreshRepo for folder '%s': Launching ssh-agent: %s" % (repoFolder, res))
                else:
                    continue
        elif re.search(r'reject|error|fatal', res, re.I):
            writelog("refreshRepo for folder '%s': Pulling commits into master branch from remote error: %s" % (repoFolder, res))
        break


def createTmpDir(subfolder, folder=CFG['rules_check_tmp_dir'], inner_folder='rules'):
    newTmpDir = ''
    while os.path.exists("%s/%s" % (folder, subfolder)):
        subfolder = getUUID()
    newTmpDir = "%s/%s" % (folder, subfolder)
    try:
        os.makedirs('{0}{1}'.format(newTmpDir, "/{0}".format(inner_folder) if inner_folder else ''))
    except Exception, e:
        writelog("Error while creating temporary folder '%s': %s" % (subfolder, str(e)), True)
        sys.exit(1)
    writelog("Creation of temp dir '%s' done" % newTmpDir)
    return subfolder


def verifyRules(rulesDir, rulesType='In'):
    faultRulesCnt = 0
    res = resText = ''
    dirName = createTmpDir(rulesDir, inner_folder=CFG["so_rules"]["folder_name"])
    tmpRulesParentDir = '{0}/{1}'.format(CFG['rules_check_tmp_dir'], dirName)
    tmpRulesDir = '{0}/{1}/'.format(tmpRulesParentDir, CFG["so_rules"]["folder_name"])

    for rulesFolder in RULES_DIRS[rulesType]:
        call("cp %s* %s" % (rulesFolder, tmpRulesDir), shell=True)
        if rulesType in ['In', 'Out', 'Corp']:
            call("cp -f %scommon/* %s" % (RULES_DIRS['In'][0], tmpRulesDir), shell=True)
        elif rulesType in ['Test_In', 'Test_Out', 'Test_Corp']:
            call("cp -f %scommon/* %s" % (RULES_DIRS['Test_In'][0], tmpRulesDir), shell=True)
    try:
        try:
            resText = check_output('{0} -R {1} -C {2}/.rules_cache'.format(CFG["so_rules"]['reader_path'], tmpRulesDir, tmpRulesParentDir), stderr=STDOUT, shell=True, universal_newlines=True)
        except CalledProcessError, e:
            faultRulesCnt += 1
            if hasattr(e, 'output'):
                resText += "\nRules Reader failed: %s\n" % e.output
        if isinstance(resText, str):
            resText = resText.decode("utf-8", "ignore")
    except Exception, e:
        writelog('verifyRules: Exception while rules reader processing of rules %s in folder %s: %s' % (rulesType, tmpRulesDir, str(e)), True)
    try:
        res = check_output('{0} -R {1} -C {2}/.rules_cache | grep "All\|err\|Err\|Rules cs:"'.format(CFG["so_rules"]['reader_path'], tmpRulesDir, tmpRulesParentDir), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('verifyRules: Exception while rules reader processing of rules %s  (2nd iteration): %s' % (rulesType, str(e)), True)
    m = re.search(r'All fault rules:\s+(\d+)', res)
    if m:
        faultRulesCnt += int(m.group(1)) if m.group(1) else 0
    try:
        rmtree(tmpRulesParentDir)
    except Exception, e:
        writelog("verifyRules: Exception while removing folder '%s': %s" % (tmpRulesParentDir, str(e)), True)
    return resText, faultRulesCnt


def verifyAFRules(rulesDir, submodule, repoName):
    faultRulesCnt = 0
    res = resText = ''
    repoPath = CFG["af_rules"]["folder"] + ("{}/".format(submodule) if submodule else "")
    dirName = createTmpDir(rulesDir, inner_folder=repoName)
    tmpRulesParentDir = '{}/{}'.format(CFG['rules_check_tmp_dir'], dirName)
    tmpRulesDir = '{}/{}/'.format(tmpRulesParentDir, repoName)

    writelog("verifyAFRules: copying rules from submodule '%s' to temporary folder '%s'" % (submodule, tmpRulesDir))
    call("cp -ar %s* %s" % (repoPath, tmpRulesDir), shell=True)
    try:
        try:
            resText = check_output('{0} {1}'.format(CFG["af_rules"]['reader_path'], tmpRulesDir), stderr=STDOUT, shell=True, universal_newlines=True)
        except CalledProcessError, e:
            faultRulesCnt += 1
            if hasattr(e, 'output'):
                resText += "\nRules Reader failed: %s\n" % e.output
        if isinstance(resText, str):
            resText = resText.decode("utf-8", "ignore")
    except Exception, e:
        writelog('verifyAFRules: Exception while rules reader processing of folder %s (submodule %s): %s' % (tmpRulesDir, submodule, str(e)), True)
    try:
        res = check_output('{0} {1} | grep "All\|err\|Err\|Rules cs:"'.format(CFG["af_rules"]['reader_path'], tmpRulesDir), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('verifyAFRules: Exception while rules reader processing (2nd iteration for submodule %s): %s' % (submodule, str(e)), True)
    m = re.search(r'All fault rules:\s+(\d+)', res)
    if m:
        faultRulesCnt += int(m.group(1)) if m.group(1) else 0
    try:
        rmtree(tmpRulesParentDir)
    except Exception, e:
        writelog("verifyAFRules: Exception while removing folder '%s': %s" % (tmpRulesParentDir, str(e)), True)
    writelog("verifyAFRules: checking of rules in submodule '%s' done: errosCount=%s, checkResult='%s'" % (submodule, faultRulesCnt, resText))
    return resText, faultRulesCnt


def time2str(ts):
    return strftime('%Y-%m-%d %H:%M', localtime(ts))


def eFilter(s):
    if not s:
        s = ''
    return s.replace(r'&', r'&amp;').replace(r'<', r'&lt;').replace(r'>', r'&gt;').replace(r'"', r'&quot;')


def fmtValue(val, n = 0):
    if not n:
        n = 2
    return format(val, ".{0}f".format(n)).rstrip('0').rstrip('.')


def encodeBase64Url(s):
    es = ''
    try:
        es = urlsafe_b64encode(s)
    except Exception, e:
        writelog("Error while encoding string '%s': %s" % (s, str(e)))
    return re.sub(r'=[-]*\z', r'', es)


def getRulesForPeriod(route, rules_filter):
    loadMongoDbCredentials(MONGO_RULES)
    rules, rules_constraint, bornday_constraint = {}, {}, {}
    db = collection = None
    try:
        db = getMongoDB(MONGO_RULES)
        collection = db['Rules_{0}'.format(route)]
    except Exception, e:
        writelog("DB exception: %s" % str(e), True)
    if 'rules' in rules_filter and isinstance(rules_filter['rules'], list):
        rules_constraint['rule'] = {'$in': rules_filter['rules']}
    if ('age_min' in rules_filter and rules_filter['age_min']) or ('age_max' in rules_filter and rules_filter['age_max']):
        bornday1, bornday2 = int(rules_filter.get('age_min', 0)), int(rules_filter.get('age_max', 0))
        bornday_constraint['borndate'] = {}
        if rules_filter['age_min']:
            bornday_constraint['borndate']['$lte'] = (date.today() - timedelta(days = bornday1)).isoformat()
        if rules_filter['age_max']:
            bornday_constraint['borndate']['$gte'] = (date.today() - timedelta(days = bornday2)).isoformat()
    try:
        for doc in collection.aggregate([{'$match': rules_constraint}, {'$project': {'date': 1, 'rule': 1}}, {'$group': {'_id': '$rule', 'borndate':   {'$min': '$date'}}}, {'$match': bornday_constraint}]):
            rules[doc['_id']] = doc.get('borndate', '')
    except Exception, e:
        writelog("DB data aggregation for rules constraint '%s' and bornday constraint '%s' failed: %s" % (rules_constraint, bornday_constraint, str(e)), True)
    return rules


def gatherWeights(data, filename, filetype, route):
    s, w, cnt, charset = '', '', 0, 'windows-1251' if route[:2] == 'So' else 'koi8-r'
    try:
        with open(filename) as f:
            while True:
                row = f.readline()
                if not row:
                    break
                if row.startswith('#') or re.match(r'^\s*$', row):
                    continue
                m = re.match(r'^rule\s+(.*)$', row)
                if m:
                    s = m.group(1)
                    m = RE["rule_weight"].match(s)
                    if not m:
                        continue
                    if m.group(1) is None or m.group(2) is None or m.group(1) not in data:
                        continue
                    s = m.group(1)
                    cnt += 1
                    data[s]['weight'] = m.group(2)
                    data[s]['type'] = filetype
                    data[s]['text'] = row.decode(charset, 'ignore')
                    data[s]['file'] = filename[len('WORKING_DIR') + 1:] if filename.startswith('WORKING_DIR') else filename
                    while True:
                        line = f.readline()
                        if not line or re.match(r'^\s*$', line):
                            break
                        data[s]['text'] += line.decode(charset, 'ignore')
                        m = re.match(r'^describe\s+(.*)$', line)
                        if m:
                            data[s]['describe'] = m.group(1).decode(charset, 'ignore')
                            break
    except Exception, e:
        writelog("Exception: %s" % str(e), True)
    return cnt


def parseRulesInfo(info, s, f):
    while s:
        m = re.match(r'^([a-z]\S*)(?:\s+(\d+))?(?:\s+(\d+))?', s, re.I)
        if m and m.group(1):
            s1, s2, s3 = m.group(1), m.group(2) if m.group(2) else '', m.group(3) if m.group(3) else ''
            info['%s_%s_min' % (f, s1)] = int(s2) if s2.isdigit() else None
            info['%s_%s_max' % (f, s1)] = int(s3) if s3.isdigit() else None
            s = s[len(s1 + s2 + s3):]
            s = re.sub(r'^\s', r'', s)
        else:
            m = re.match(r'^([^a-z]\S*\s*)', s, re.I)
            if m:
                s = s[len(m.group(1) if m.group(1) else ''):]
    return info


def getRulesMonitoringInfo(rule, route, update_rules):
    if not route:
        return {}
    #if update_rules:
    #    checkoutRepo()
    info = {}
    rules = {}
    for d in RULES_DIRS[route]:
        if route == 'Corp' and d.find('local') == -1:
            continue
        for f in ['daily', '10min']:
            try:
                with open("%s.%s.mon" % (d, f)) as fh:
                    for row in fh:
                        if row.startswith('#'):
                            continue
                        m = re.match(r'^\s*\b{0}\b(?:\s+(.+))?'.format(rule), row)
                        if rule and m:
                            info['rule'] = rule
                            info['%s_path' % f] = "%s.%s.mon" % (d, f)
                            parseRulesInfo(info, m.group(1), f)
                            break
                        elif not rule:
                            m = re.match(r'^\s*\b(\w+)\b(?:\s+(.+))?', row)
                            if m and m.group(1):
                                if m.group(1) not in rules:
                                    rules[m.group(1)] = {}
                                parseRulesInfo(rules[m.group(1)], m.group(2), f)
            except Exception, e:
                writelog("Exception while processing file '%s.%s.mon': %s" % (d, f, str(e)), True)
    return info if rule else rules


def getRuleData(rule, route, detailed, day, period, sortorder, update_rules, data):
    loadMongoDbCredentials(MONGO_RULES)
    regex, cnt, d, match = '=' if re.match(r'^[A-Z0-9_]+$', rule) else 'REGEXP', 0, '', {}
    #if update_rules:
    #    checkoutRepo()
    y, m, md = map(int, day.split('-'))
    if detailed:
        dt, ts = 24 * 3600, int(mktime(date(*map(int, day.split('-'))).timetuple()))
        match['time'] = {'$gte': ts, '$lt': ts + dt}
    elif period != 99:
        match['date'] = {'$gte': data['dates']['from'], '$lte': data['dates']['to']}
    db = collection = None
    try:
        db = getMongoDB(MONGO_RULES)
        collection = db['{0}Rules_{1}'.format('detailed_' if detailed else '', route)]
    except Exception, e:
        writelog("DB exception: %s" % str(e), True)
    data['isregexp'] = '(задано регулярное выражение)' if regex == 'REGEXP' else ''
    if regex == '=':
        rules = [rule]
    else:
        rules = collection.distinct('rule', {'rule': re.compile(r'{0}'.format(rule))})
    data['rules_count'] = len(rules)
    data2 = {}
    if data['rules_count'] == 1:
        h = {
            '_id':   '${0}'.format('time' if detailed else 'date'),
            'malic': {'$sum': {'$ifNull': ['$R256', 0]}},
            'spam':  {'$sum': {'$ifNull': ['$R4', 0]}}
        }
        if route[:2] == 'So':
            h['ham']            = {'$sum': '$R1'}
            h['total']          = {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R4', 0]}]}}
        else:
            h['ham']            = {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R2', 0]}]}}
            h['hampf']          = {'$sum': '$R8'}
            h['spampf']         = {'$sum': '$R127'}
            h['total']          = {'$sum': {'$add': [
                {'$ifNull': ['$R1', 0]},
                {'$ifNull': ['$R2', 0]},
                {'$ifNull': ['$R4', 0]},
                {'$ifNull': ['$R8', 0]},
                {'$ifNull': ['$R127', 0]},
                {'$ifNull': ['$R256', 0]}]}}
            h['cmpl_spam']      = {'$sum': {'$ifNull': ['$cmpl_spam', 0]}}
            h['cmpl_spam_nopf'] = {'$sum': {'$ifNull': ['$cmpl_spam_nopf', 0]}}
            h['cmpl_ham']       = {'$sum': {'$ifNull': ['$cmpl_ham', 0]}}
            h['cmpl_ham_nopf']  = {'$sum': {'$ifNull': ['$cmpl_ham_nopf', 0]}}
        for r in rules:
            if r not in data2:
                data2[r] = {}
            m = match.copy()
            m['rule'] = r
            data2[r]['statistics'] = OrderedDict(map(lambda row: (time2str(row['_id']) if detailed else row['_id'], row),
                collection.aggregate([{'$match': m}, {'$group': h}, {'$sort': {('_id' if sortorder == 'date' else sortorder): -1}}])))
            data2[r]['weight'] = None
            p = collection.aggregate([
                {'$match': {'rule': r}}, {'$project': {str('time' if detailed else 'date'): 1, 'rule': 1}},
                {'$group': {'_id': '$rule', 'borndate': {'$min': '${0}'.format('time' if detailed else 'date')}, 'lastdate': {'$max': '${0}'.format('time' if detailed else 'date')}}}
            ])
            if p and p.alive:
                p = p.next()
                data2[r]['borndate'] = time2str(p['borndate']) if detailed else p['borndate']
                if period == 99:
                    lastdate = time2str(p['lastdate']) if detailed else p['lastdate']
                    if 'from' not in data['dates']:
                        data['dates']['from'] = data2[r]['borndate']
                    else:
                        data['dates']['from'] = min(data['dates']['from'], data2[r]['borndate'])
                    if 'to' not in data['dates']:
                        data['dates']['to'] = lastdate
                    else:
                        data['dates']['to'] = min(data['dates']['to'], lastdate)
            for (t, row) in data2[r]['statistics'].iteritems():
                if route[:2] == 'So':
                    row['spampercent'] = fmtValue(row['spam'] * 100.0 / row['total']) if row['total'] > 0 else '0'
                else:
                    row['spampercent'] = fmtValue((row['spam'] + row['spampf'] + row['malic']) * 100.0 / row['total']) if row['total'] > 0 else '0'
                    row['nopf'] = fmtValue((row['spam'] + row['hampf'] + row['malic']) * 100.0 / row['total']) if row['total'] > 0 else '0'
                    row['cmpl_spam_percent'] = fmtValue(row['cmpl_spam_nopf'] * 100.0 / row['ham'], 6) if row['ham'] > 0 else ''
                    row['cmpl_ham_percent'] = fmtValue(row['cmpl_ham_nopf'] * 100.0 / row['spam'], 6) if row['spam'] > 0 else ''
                    row['spampf'] = fmtValue(float(row['spampf']))
                    row['hampf'] = fmtValue(float(row['hampf']))
                    row['cmpl_spam'] = fmtValue(float(row['cmpl_spam']))
                    row['cmpl_ham'] = fmtValue(float(row['cmpl_ham']))
                row['ham'] = fmtValue(float(row['ham']))
                row['spam'] = fmtValue(float(row['spam']))
                row['ham'] = fmtValue(float(row['ham']))
                row['malic'] = fmtValue(float(row['malic']))
                row['total'] = fmtValue(float(row['total']))
        for d in RULES_DIRS[route]:
            for filename in glob(d + '*.rul'):
                if not os.path.isfile(filename):
                    continue
                cnt += gatherWeights(data2, filename, 'rul', route)
                if cnt >= data['rules_count']:
                    break
            for filename in glob(d + '*.dlv'):
                if not os.path.isfile(filename):
                    continue
                cnt += gatherWeights(data2, filename, 'dlv', route)
                if cnt >= data['rules_count']:
                    break
        for r in data2:
            for par in ['type', 'weight', 'text', 'file', 'borndate']:
                if par not in data2[r]:
                    data2[r][par] = ''
    else:
        for r in rules:
            data2[r] = {}
    return data2


def getRulesData(route, rules, params):
    loadMongoDbCredentials(MONGO_RULES)
    #if params['update_rules']:
    #    checkoutRepo()
    cnt, rules_count, d = 0, len(rules), ''
    p = params['period'] * 30 if params['period'] > 0 and params['period'] < 7 else (params['days_period'] if params['days_period'] else 90)
    today = date.today().isoformat()
    fromday = (date.today() - timedelta(days = p)).isoformat()
    db = collection = None
    try:
        db = getMongoDB(MONGO_RULES)
        collection = db['Rules_{0}'.format(route)]
    except Exception, e:
        writelog("DB exception: %s" % str(e), True)
    h = {
        '_id':   '$rule',
        'malic': {'$sum': '$R256'},
        'spam':  {'$sum': '$R4'}
    }
    if route.startswith('So'):
        h['ham']            = {'$sum': '$R1'}
        h['total']          = {'$sum': {'$add': [{'$ifNull': ['$R1', Int64(0)]}, {'$ifNull': ['$R4', Int64(0)]}]}}
    else:
        h['ham']            = {'$sum': {'$add': [{'$ifNull': ['$R1', Int64(0)]}, {'$ifNull': ['$R2', Int64(0)]}]}}
        h['hampf']          = {'$sum': '$R8'}
        h['spampf']         = {'$sum': '$R127'}
        h['total']          = {'$sum': {'$add': [{'$ifNull': ['$R1', Int64(0)]}, {'$ifNull': ['$R2', Int64(0)]}, {'$ifNull': ['$R4', Int64(0)]},
            {'$ifNull': ['$R8', Int64(0)]}, {'$ifNull': ['$R127', Int64(0)]}, {'$ifNull': ['$R256', Int64(0)]}]}}
        h['cmpl_spam']      = {'$sum': '$cmpl_spam'}
        h['cmpl_spam_nopf'] = {'$sum': '$cmpl_spam_nopf'}
        h['cmpl_ham']       = {'$sum': '$cmpl_ham'}
        h['cmpl_ham_nopf']  = {'$sum': '$cmpl_ham_nopf'}
    data = OrderedDict()
    for doc in collection.aggregate([{'$match': {'$and': [{'date': {'$gte': fromday}}, {'date': {'$lte': today}}, {'rule': {'$in': rules.keys()}}]}}, {'$group': h}]):
        r = doc['_id']
        data[r] = {}
        for (k, v) in doc.iteritems():
            if k != '_id':
                data[r][k] = v
    for (r, rinfo) in data.iteritems():
        rinfo['weight'] = ''
        rinfo['borndate'] = rules[r] if r in rules else ''
        if route.startswith('So'):
            rinfo['spampercent'] = fmtValue(rinfo['spam'] * 100.0 / rinfo['total']) if rinfo['total'] > 0 else '0'
            continue
        rinfo['spampercent'] = fmtValue((rinfo['spam'] + rinfo['spampf'] + rinfo['malic']) * 100.0 / rinfo['total']) if rinfo['total'] > 0 else '0'
        rinfo['nopf'] = fmtValue((rinfo['spam'] + rinfo['hampf'] + rinfo['malic']) * 100.0 / rinfo['total']) if rinfo['total'] > 0 else '0'
        rinfo['cmpl_spam_percent'] = fmtValue(rinfo['cmpl_spam_nopf'] * 100.0 / rinfo['ham'], 6) if rinfo['ham'] > 0 else ''
        rinfo['cmpl_ham_percent'] = fmtValue(rinfo['cmpl_ham_nopf'] * 100.0 / rinfo['spam'], 6) if rinfo['spam'] > 0 else ''
    if params['choice'] == 2:
        for r in data:
            if params['sp_min'] and data[r]['spampercent'] < params['sp_min'] or params['sp_max'] and data[r]['spampercent'] > params['sp_max'] or \
                params['nopf_min'] and data[r]['nopf'] < params['nopf_min'] or params['nopf_max'] and data[r]['nopf'] > params['nopf_max'] or \
                params['total_min'] and data[r]['total'] < params['total_min'] or params['total_max'] and data[r]['total'] > params['total_max'] or \
                params['cs_nopf_min'] and data[r]['cmpl_spam_nopf'] < params['cs_nopf_min'] or params['cs_nopf_max'] and data[r]['cmpl_spam_nopf'] > params['cs_nopf_max'] or \
                params['ch_nopf_min'] and data[r]['cmpl_ham_nopf'] < params['ch_nopf_min'] or params['ch_nopf_max'] and data[r]['cmpl_ham_nopf'] > params['ch_nopf_max'] or \
                params['cs_min'] and data[r]['cmpl_spam'] < params['cs_min'] or params['cs_max'] and data[r]['cmpl_spam'] > params['cs_max'] or \
                params['ch_min'] and data[r]['cmpl_ham'] < params['ch_min'] or params['ch_max'] and data[r]['cmpl_ham'] > params['ch_max']:
                    del data[r]
                    del rules[r]
                    rules_count -= 1
        rules_count = len(rules)
    for d in RULES_DIRS[route]:
        for filename in glob(d + '*.rul'):
            if not os.path.isfile(filename):
                continue
            cnt += gatherWeights(data, filename, 'rul', route)
            if cnt >= rules_count:
                break
        for filename in glob(d + '*.dlv'):
            if not os.path.isfile(filename):
                continue
            cnt += gatherWeights(data, filename, 'dlv', route)
            if cnt >= rules_count:
                break
    for r in data:
        for par in ['type', 'weight', 'text', 'file']:
            if par not in data[r]:
                data[r][par] = ''
    if params['choice'] == 2:
        text_re = re.compile(r'\bbexpr\b|\barithmetic\b|\bR_ANTI\b')
        w_re = re.compile(r'^\d+')
        for r in data:
            try:
                w_m = w_re.match(data[r]['weight'])
                w = float(data[r]['weight']) if w_m else 0
                if w_m and (params['heavy_min'] and w < params['heavy_min'] or params['heavy_max'] and w > params['heavy_max']) or not w_m and (params['heavy_min'] or params['heavy_max']) or params['is_atomic'] and text_re.search(data[r]['text']):
                    del data[r]
                    del rules[r]
                    rules_count -= 1
            except Exception, e:
                writelog("Error while filtering DB data by weight and atomicity condition for rule %s: %s" % (r, str(e)), True)
        rules_count = len(rules)
        if params['max_rules_count'] and rules_count > params['max_rules_count']:
            for i in range(rules_count):
                if i >= params['max_rules_count']:
                    del data[r]
                    del rules[r]
                    rules_count -= 1
                    i -= 1
    return data


def buildRulesTable(params, table_title, tp, sortorder, ruledata, route):
    n = 1 if tp == 'rul' else (2 if tp == 'dlv' else 3)
    rules = filter(lambda r: ruledata[r]['type'] and ruledata[r]['type'] == tp, ruledata.keys()) if n < 3 else filter(lambda r: not ruledata[r]['type'], ruledata.keys())
    table_type = '' if len(rules) > 0 else 'style="display:none;"'
    table = u'<a name="table{0}"/>'.format(n)
    if len(rules) > 0:
        table += u'<hr><h4>{0}</h4>'.format(table_title)
    table += u"""<table cellspacing="0" cellpadding="2" border="1" id="table{0}" {1}> <thead><tr>
        <th rowspan=2><a class="headsort" id="rule" onClick="ChangeSortOrder(this,{0});" title="Имя правила"> Rule </a></th>
        <th align="center" rowspan=2 style="padding: 2px 0.2em;"><a class="headsort" id="weight" onClick="ChangeSortOrder(this,{0});" title="Вес правила"> Weight </a></th>
        <th align="center" rowspan=2 style="padding: 2px 0.2em;"><a class="headsort" id="borndate" onClick="ChangeSortOrder(this,{0});" title="Дата появления правила в статистике"> BornDate </a></th>
        <th style="padding: 2px 0.2em;" rowspan=2><a class="headsort" id="spam" onClick="ChangeSortOrder(this,{0});" title="{2}"> {3} </a></th>""".format(n, table_type, PARAM['spam'][1], PARAM['spam'][0])
    if not route.startswith('So'):
        table += u'<th style="padding: 2px 0.2em;" rowspan=2><a class="headsort" id="spamPF" onClick="ChangeSortOrder(this,{0});" title="{1}"> {2} </a></th>'.format(n, PARAM['spampf'][1], PARAM['spampf'][0])
    table += u'<th style="padding: 2px 0.2em;" rowspan=2><a class="headsort" id="ham" onClick="ChangeSortOrder(this,{0});" title="{1}"> {2} </a></th>'.format(n, PARAM['ham'][1], PARAM['ham'][0])
    if not route.startswith('So'):
        table += u'<th style="padding: 2px 0.2em;" rowspan=2><a class="headsort" id="hamPF" onClick="ChangeSortOrder(this,{0});" title="{1}"> {2} </a></th>'.format(n, PARAM['hampf'][1], PARAM['hampf'][0])
    table += u'<th style="padding: 2px 0.2em;" rowspan=2><a class="headsort" id="malic" onClick="ChangeSortOrder(this,{0});" title="{1}"> {2} </a></th>'.format(n, PARAM['malic'][1], PARAM['malic'][0])
    if route.startswith('So'):
        table += u'<th align="center" rowspan=2 style="padding: 2px 0.2em;"><a class="headsort" id="spampercent" onClick="ChangeSortOrder(this,{0});" title="{1}"> {2} </a></th>'.format(n, PARAM['spampercent'][1], PARAM['spampercent'][0])
    else:
        table += u'<th align="center" rowspan=2 style="padding: 2px 0.2em;"><a class="headsort" id="spampercent" onClick="ChangeSortOrder(this,{0});" title="{1} ({2})"> {3} ({4}) </a></th>'.format(n, PARAM['spampercent'][1], PARAM['nopf'][1], PARAM['spampercent'][0], PARAM['nopf'][0])
    table += u'<th style="padding: 2px 0.2em;" rowspan=2><a class="headsort" id="total" onClick="ChangeSortOrder(this,{0});" title="{1}"> {2} </a></th>'.format(n, PARAM['total'][1], PARAM['total'][0])
    if route.startswith('So'):
        table += u'<th rowspan=2> Rule\'s description </th> </tr><tr>'
    else:
        table += u"""<th style="padding: 2px 0.2em;" colspan=2 title="Жалобы на спам"> Cmpl_spam </th>
            <th style="padding: 2px 0.2em;" colspan=2 title="Жалобы на хам"> Cmpl_ham </th>
            <th rowspan=2> Rule's description </th> </tr><tr>
            <th><a class="headsort" id="cmpl_spam_nopf" onClick="ChangeSortOrder(this,{0});" title="{1}"> {2} </a></th>
            <th><a class="headsort" id="cmpl_spam_percent" onClick="ChangeSortOrder(this,{0});" title="{3}"> {4} </a></th>
            <th><a class="headsort" id="cmpl_ham_nopf" onClick="ChangeSortOrder(this,{0});" title="{5}"> {6} </a></th>
            <th><a class="headsort" id="cmpl_ham_percent" onClick="ChangeSortOrder(this,{0});" title="{7}"> {8} </a></th>""".format(n, PARAM['cmpl_spam_nopf'][1], PARAM['cmpl_spam_nopf'][0], PARAM['cmpl_spam_percent'][1], PARAM['cmpl_spam_percent'][0], PARAM['cmpl_ham_nopf'][1], PARAM['cmpl_ham_nopf'][0], PARAM['cmpl_ham_percent'][1], PARAM['cmpl_ham_percent'][0])
    table += u'</tr></thead><tbody>'
    try:
        def printRow(rule, route, ruledata):
            table = ""
            table += u"""<tr><td style="text-align: left;"><a href="{0}{1}&route={2}">{1}</a></td>
                <td style="text-align:center;padding: 2px 0.2em;">{3}</td>
                <td style="text-align:center;white-space:nowrap;padding: 2px 0.4em;">{4}</td>
                <td style="text-align:center;padding: 2px 0.3em;">{5}</td>""".format(HREF['showrule'], rule, route, ruledata[rule]['weight'], ruledata[rule]['borndate'], ruledata[rule]['spam'])
            if not route.startswith('So'):
                table += '<td style="text-align:center;padding: 2px 0.3em;">{0}</td>'.format(ruledata[rule]['spampf'])
            table += u'<td style="text-align:center;padding: 2px 0.3em;">{0}</td>'.format(ruledata[rule]['ham'])
            if not route.startswith('So'):
                table += u'<td style="text-align:center;padding: 2px 0.3em;">{0}</td>'.format(ruledata[rule]['hampf'])
            table += u'<td style="text-align:center;padding: 2px 0.3em;">{0}</td>'.format(ruledata[rule]['malic'])
            if route.startswith('So'):
                table += u'<td style="text-align:center;padding: 2px 0.3em;">{0}</td>'.format(ruledata[rule]['spampercent'])
            else:
                table += u'<td style="text-align:center;padding: 2px 0.2em;">{0} ({1})</td>'.format(ruledata[rule]['spampercent'], ruledata[rule]['nopf'])
            table += u'<td style="text-align:center;padding: 2px 0.3em;">{0}</td>'.format(ruledata[rule]['total'])
            if not route.startswith('So'):
                table += u"""<td style="text-align:center;padding: 2px 0.2em;">{0} ({1})</td>
                    <td style="text-align:center;padding: 2px 0.3em;">{2}</td>
                    <td style="text-align:center;padding: 2px 0.2em;">{3} ({4})</td>
                    <td style="text-align:center;padding: 2px 0.3em;">{5}</td>""".format(ruledata[rule]['cmpl_spam_nopf'], ruledata[rule]['cmpl_spam'], ruledata[rule]['cmpl_spam_percent'], ruledata[rule]['cmpl_ham_nopf'], ruledata[rule]['cmpl_ham'], ruledata[rule]['cmpl_ham_percent'])
            table += u'<td style="text-align:left;">{0}</td></tr>'.format(eFilter(ruledata[rule].get('describe', '')))
            return table
        for r in sorted(filter(lambda x: ruledata[x][sortorder], rules), cmp=lambda a, b: cmp(a, b) if sortorder == 'rule' else (cmp(ruledata[b][sortorder], ruledata[a][sortorder]) if sortorder == 'borndate' else int((float(ruledata[b][sortorder]) - float(ruledata[a][sortorder])) * 1000))):
            table += printRow(r, route, ruledata)
        for r in sorted(filter(lambda x: not ruledata[x][sortorder], rules)):
            table += printRow(r, route, ruledata)
    except Exception, e:
        writelog("Exception: %s" % str(e), True)
    table += u'</tbody></table>'
    if len(rules) > 0:
        table += u'<br />'
    return table
