#!/usr/bin/perl
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
use strict;
use warnings;
use CGI;
use CGI::Carp qw(carpout fatalsToBrowser set_message);

my ($q, $proto) = (CGI->new, 'http'.($ENV{'HTTPS'} ? 's' : ''));
my @f;
my ($fc, $n, $ml) = ($q->param('field_count') || 10, 0, $q->param('min_limit') || 2);

foreach (0..$fc-1) {
    $f[$_] = $q->param('f'.$_) || ''; $n++ if $f[$_]
}
##----------------------------------------------------------------------------##
print $q->header(-type => 'text/html', -charset => 'utf-8'); # or KOI8-R ?
print $q->start_html(-title => 'Differences between rules\' sets', -style => {-verbatim => 'body, td {font-family: Arial, GenevaCY,Sans-Serif;}'}, #-background => 'spamstat.jpg',
    -head => '<link rel="shortcut icon" href="/images/favicon.ico" />');
print qq{<table><tr><td style="width:22em;vertical-align:top;"><a href="$proto://}.$ENV{'HTTP_HOST'}.'/internal/"><img width=90 height=90 src="/images/sign_so.gif"><img src="/images/logo.gif"></a></td>';
print '<td>&nbsp;<h2 style="white-space:nowrap;">Сравнение наборов правил на предмет их общего подмножества</h2></td></tr></table>', $q->br;
print <<EOH;
    <table cellspacing="0" cellpadding="5" border="0"><tr>
      <td valign="top"><form method="POST">
            <table width=100%>
              <tr>
                <td><input type="submit" value="DIFF">&nbsp;&nbsp;&nbsp</td><td></td>
                <td align="right"><label for="field_count">Количество полей ввода:</label><input type="number" name="field_count" style="width:3em;" value=$fc /></td>
              </tr><tr>
                <td></td><td></td>
                <td align="right"><label for="min_limit">Мин.кол-во повторений правил:</label><input type="number" name="min_limit" style="width:3em;" value=$ml /></td>
              </tr><tr>
                <td></td><td></td>
                <td align="right"><label for="gether">Собрать правила вместе</label><input type="checkbox" checked name="gether"></td>
              </tr>
            </table><br />
EOH
print('<textarea name="f'.$_.'" rows ="16" cols="50" width=100% >'.($f[$_] || '').'</textarea><br />'."\n") foreach (0..$fc-1);
print '</form></td><td valign="top">';
if ($n > 0) {
    my (%rules1, %rules2, %r, $k); %rules1 = (); %rules2 = (); %r = ();
    foreach (0..$fc-1) {
        next unless $f[$_];
        $r{$1}->{$_}++ while ($f[$_] =~ m/[\s\(]*([A-Z_][\dA-Z_]+)[^\dA-Z_]*/go);
    }
    foreach (keys %r) {
        $k = scalar(keys(%{$r{$_}}));
        if ($k == $n) { $rules1{$_} = $k }
        elsif ($k >= $ml) { $rules2{$_} = $k }
    }
    print '<span style="white-space:nowrap;margin: 0 0 1em 0.5em;"><b>Правила, имеющиеся в каждом поле</b></span><br />';
    print_table(%rules1);
    print '</td><td valign="top">';
    print '<span style="white-space:nowrap;margin: 0 0 1em 0.5em;"><b>Правила, имеющиеся не в каждом поле</b></span><br />';
    print_table(%rules2);
    if ($q->param('gether')) {
        print '</td><td valign="top">';
        print '<textarea rows ="24" cols="40" width=100% >'.join(' + ', keys %rules1).'</textarea><br />'."\n";
        print '<textarea rows ="24" cols="40" width=100% >'.join(' + ', sort { $rules2{$b} <=> $rules2{$a} } keys %rules2).'</textarea><br />'."\n";
    }
}
print '</td></tr></table>'.$q->end_html;

##----------------------------------------------------------------------------##
BEGIN {
sub print_table {
    my %rules = @_;
    print '<span style="white-space:nowrap;margin: 0 0 1em 0.5em;"><i>Количество правил</i>:&nbsp;&nbsp;'.(scalar keys %rules).'</span><br /><br />';
    print '<table cellspacing="0" cellpadding="4" border="1" width=100%>';
    print('<tr><td>'.$_.'</td><td style="width:2em;text-align:center;">'.$rules{$_}.'</td></tr>') foreach (sort { $rules{$b} <=> $rules{$a} } keys %rules);
    print '</table>'."\n";
}
}
##----------------------------------------------------------------------------##
