#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
import re, json, time
from tempfile import mkstemp, mkdtemp
from collections import defaultdict
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog


TEMPDIR = 'WORKING_DIR/temp/'


def loadDlvLog(f, rules_diff, rules_stat, i = 0):
    if not f:
        return
    row = f.readline()
    while row:
        if re.match(r'mess: \w+\s+\d+', row):
            r_sp = r_nl = r_dl = queueid = msgid = ''
        elif row.startswith('X-Yandex-QueueID: '):
            m = re.match(r'X-Yandex-QueueID: (\S+)', row)
            if m and m.group(1):
                queueid = m.group(1)
        elif row.startswith('MESSAGEID: '):
            m = re.match(r'MESSAGEID: (\S+)', row)
            if m and m.group(1):
                msgid = m.group(1)
        elif row.startswith('r_sp: ') and queueid and msgid:
            m = re.match(r'^r_sp: (.*)$', row)
            if m and m.group(1):
                for rule in m.group(1).split(', '):
                    if rule:
                        rules_diff["%s_%s" % (queueid, msgid)].add(rule.split()[0])
                        rules_stat[rule.split()[0]][i] += 1
        elif row.startswith('r_dl: ') and queueid and msgid:
            m = re.match(r'^r_dl: (.*)$', row)
            if m and m.group(1):
                for rule in m.group(1).split(', '):
                    if rule:
                        rules_diff["%s_%s" % (queueid, msgid)].add(rule.split()[0])
                        rules_stat[rule.split()[0]][i] += 1
        elif row.startswith('r_nl: ') and queueid and msgid:
            m = re.match(r'^r_nl: (.*)$', row)
            if m and m.group(1):
                for rule in m.group(1).split(', '):
                    if rule:
                        rules_diff["%s_%s" % (queueid, msgid)].add(rule.split(',')[0])
                        rules_stat[rule.split(',')[0]][i] += 1
        row = f.readline()


def saveUploadedFile(form_file, fout):
    if not form_file.file:
        return
    while 1:
        chunk = form_file.file.read(100000)
        if not chunk:
            break
        fout.write(chunk)
    fout.close()


form = cgi.FieldStorage()
action = form.getfirst("action", "show")
if action.startswith('upload_'):
    print "Content-type: application/json\r\n\r\n"
else:
    print "Content-type: text/html\r\n\r\n"

if action == 'show':
    data, host = [], "%s://%s/internal/" % ('http' + ('s' if os.environ.has_key('HTTPS') else ''), os.environ['HTTP_HOST'])
    file_type1, file_type2 = form.getfirst('file_type1', 'file'), form.getfirst('file_type2', 'file')
    filename1, filename2, d = form.getfirst('dlvlog1', ''), form.getfirst('dlvlog2', ''), form.getfirst('hash', '')
    rules, rules1, rules2, n = defaultdict(lambda: [0, 0, 0, 0]), defaultdict(lambda: set()), defaultdict(lambda: set()), 0
    d = TEMPDIR + d + ('' if d == '' else '/')
    if 'dlvlog1' in form:
        if file_type1 == 'file':
            loadDlvLog(open(d + filename1), rules1, rules, 0)
            os.unlink(d + filename1)
        elif file_type1 == 'SCP':
            tmpfile1, tmp_filename1 = mkstemp(text = True)
            os.system('scp -i WORKING_DIR/rules-key/id_rsa robot-mailspam@%s %s' % (form.getfirst('dlvlog1', ''), tmp_filename1))
            loadDlvLog(os.fdopen(tmpfile1), rules1, rules, 0)
            os.unlink(tmp_filename1)
    if 'dlvlog2' in form:
        if file_type2 == 'file':
            loadDlvLog(open(d + filename2), rules2, rules, 1)
            os.unlink(d + filename2)
        elif file_type2 == 'SCP':
            tmpfile2, tmp_filename2 = mkstemp(text = True)
            os.system('scp -i WORKING_DIR/rules-key/id_rsa robot-mailspam@%s %s' % (form.getfirst('dlvlog2', ''), tmp_filename2))
            loadDlvLog(os.fdopen(tmpfile2), rules2, rules, 1)
            os.unlink(tmp_filename2)
    if file_type1 == 'file' or file_type2 == 'file':
        try:
            os.rmdir(d)
        except:
            pass
    for (k, v) in rules1.iteritems():
        if k not in rules2:
            continue
        n += 1
        data.append({'queueid': k[:k.find('_')], 'msgid': k[(k.find('_') + 1):], 'deliverylog_rules1': ', '.join(v - rules2[k]), 'deliverylog_rules2': ', '.join(rules2[k] - v)})
        for rule in (v - rules2[k]):
            rules[rule][2] += 1
        for rule in (rules2[k] - v):
            rules[rule][3] += 1
    info = {'dlvlog_recs1': len(rules1.keys()), 'dlvlog_recs2': len(rules2.keys()), 'intersec_recs': n}
    try:
        env = Environment(loader = FileSystemLoader("WORKING_DIR/web/internal"))
        template = env.get_template("show_deliverylog_diff.html.template")
        print template.render(data=data, info=info, rules=sorted(filter(lambda r: r[1] + r[2] + r[3] + r[4] > 0, map(lambda (k, v): [k, v[0], v[1], v[2], v[3]], rules.iteritems())), key=lambda r: r[1], reverse=True), host=host).encode("utf-8")
    except Exception, e:
        writelog("Exception caught (tell developer, please): %s" % str(e), True)

elif action == 'upload_file':
    h = form.getfirst('hash', '')
    if h:
        d = TEMPDIR + h
    else:
        d = mkdtemp(dir = TEMPDIR)
        h = d[(d.rfind('/') + 1):]
    saveUploadedFile(form['file'], file(os.path.join(d, form['file'].filename), 'wb'))
    print '{"hash": "%s"}' % h
