#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import IPy, json, pymongo, base64
from collections import defaultdict
from datetime import datetime
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog
from db_utils import getMongoDB
from common import doRequest, getHosts4Group


LOGS_NEEDED = 3
SERVERS = getHosts4Group("so_statlog", ["statlog1%s.so.yandex.net" % letter for letter in "fghmo"])
MONGO = {
    'cluster': 'mail_sostatip_db',
    'port':    27017,
    'db':      'spstat',
    'hosts':   ','.join(["sostatip1%s.mail.yandex.net" % dc for dc in "jhm"])
}


form = cgi.FieldStorage()
offsets = json.loads(base64.urlsafe_b64decode(form.getfirst("offsets", "")))
ip = form.getfirst("ip", "")
user = form.getfirst("user", "alex")
starttime = form.getfirst("starttime", "")
endtime = form.getfirst("endtime", "")
timerange = [starttime, endtime]

logs = []
for (server, offsets) in offsets:
    offsets = ",".join(filter(lambda elem: elem != "0", offsets.split(",")))
    content = doRequest("http://%s/searchjson?offsets=%s" % (server, offsets), "Get delivery-log offsets")
    if content:
        server_logs = json.loads(content)
        logs.extend(server_logs)
    if len(logs) >= LOGS_NEEDED:
        logs = logs[:3]
        break

print "Content-type:text/html\r\n\r\n"

db = {}
try:
    db = getMongoDB(MONGO)
except Exception, e:
    writelog("DB exception: %s" % str(e), True)
try:
    setup = db["setup"].find_one({ "_id" : "00000000000000000000FFFF7F000001" })
    bantime = setup["bantime"] if setup else 24
    longbantime = setup["longbantime"] if setup else 720

    env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
    template = env.get_template("showdlv.html.template")
    print template.render(locals()).encode("utf-8")
except Exception, e:
    writelog("Exception: %s" % str(e), True)
