#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, json
from urlparse import parse_qsl
from subprocess import check_output, STDOUT
from datetime import date, timedelta
from jinja2 import Environment, FileSystemLoader
from tempfile import mkstemp
from common import CFG, LOGINS
from log_utils import writelog
from rules_common import RULE_PARAM, RULES_TYPES, PARAM, HREF, getRulesMonitoringInfo, getRuleData, encodeBase64Url, eFilter


form = cgi.FieldStorage()
action, route, rule, period = form.getfirst("action", "show"), form.getfirst("route", "In"), form.getfirst("rule", ""), int(form.getfirst("period", "3"))
sortorder, update_rules, isregexp = form.getfirst("sortorder", "date"), form.getfirst("update_rules", "on"), form.getfirst("isregexp", "")
detailed, day, view = int(form.getfirst("detailed", "0")), form.getfirst("day", date.today().isoformat()), form.getfirst("view", "table")

print "Content-type: text/html\r\n\r\n"

if action == 'show':
    rule_params = RULE_PARAM[route]
    routes = map(lambda r: (r[0], r[1]), RULES_TYPES)
    rule_params_info = dict(map(lambda (p, pi): (p, re.sub(r'\s+\(.+?\)', r'', re.sub(r'<br/>', r' ', pi[0]))), PARAM.iteritems()))
    data = {'dates': {}, 'isregexp': isregexp, 'rules_count': 0}
    host = "%s://%s/internal/" % ('http' + ('s' if os.environ.has_key('HTTPS') else ''), os.environ['SERVER_NAME'])
    url = '%s%s&route=%s&sortorder=%s' % (HREF['showrule'], rule, route, sortorder)
    rule_info = {}
    rule_data, rules = {}, []
    if rule:
        #rule_info.update(getRulesMonitoringInfo(rule, route, update_rules))
        y, m, md = map(int, day.split('-'))
        if detailed:
            mdc = {1: 31, 2: 31, 3: 29 if y % 400 == 0 or y % 4 == 0 and y % 100 != 0 else 28, 4: 31, 5: 30, 6: 31, 7: 30, 8: 31, 9: 31, 10: 30, 11: 31, 12: 30}
            data['dates']['day'] = day
            data['dates']['to'] = (date(y, m, md) + timedelta(days=1)).isoformat()
            data['dates']['tomorrow'] = data['dates']['to']
            data['dates']['from'], data['dates']['to'] = '{0} 00:00'.format(data['dates']['day']), '{0} 00:00'.format(data['dates']['to']);
            data['dates']['yesterday'] = (date(y, m, md) - timedelta(days=1)).isoformat()
            data['dates']['today'] = date.today().isoformat()
            data['dates']['month_ago'] = (date(y, m, md) - timedelta(days=mdc[m])).isoformat()
            data['dates']['period'] = u"сутки %s" % data['dates']['day']
        else:
            if period == 99:
                data['dates']['period'] = u'всё время'
            else:
                p1 = period * 30
                data['dates']['to'] = date.today().isoformat()
                data['dates']['from'] = (date(y, m, md) - timedelta(days=p1)).isoformat()
                data['dates']['period'] = u"период с {0} по {1}".format(data['dates']['from'], data['dates']['to'])
        rule_data.update(getRuleData(rule, route, detailed, day, period, sortorder, update_rules, data))
        if data['rules_count'] == 1:
            data['dates']['from_z'] = data['dates']['from'].replace(' ', '+') if detailed else (data['dates']['from'] + '+00:00')
            data['dates']['to_z'] = data['dates']['to'].replace(' ', '+') if detailed else (data['dates']['to'] + '+00:00')
            try:
                if view == 'graph':
                    metric = {
                        'spampercent':       "(so.{0}rules.{1}.{2}.spam + so.{0}rules.{1}.{2}.spampf + so.{0}rules.{1}.{2}.malic) * 100.0 / so.{0}rules.{1}.{2}.total",
                        'nopf':              "(so.{0}rules.{1}.{2}.spam + so.{0}rules.{1}.{2}.hampf + so.{0}rules.{1}.{2}.malic) * 100.0 / so.{0}rules.{1}.{2}.total",
                        'cmpl_spam_percent': "so.{0}rules.{1}.{2}.cmpl_spam_nopf * 100.0 / so.{0}rules.{1}.{2}.ham",
                        'cmpl_ham_percent':  "so.{0}rules.{1}.{2}.cmpl_ham_nopf * 100.0 / so.{0}rules.{1}.{2}.spam",
                        '_default_':         "so.{0}rules.{1}.{2}.{3}"
                    }
                    data['chart'] = encodeBase64Url(json.dumps({
                        'charts': [{
                            'graphs':       map(lambda p: {
                                'color':  PARAM[p][3],
                                'metric': metric[p].format('detail' if detailed else '', rule, route.lower()) if p in metric else metric['_default_'].format('detail' if detailed else '', rule, route.lower(), p),
                                'title':  PARAM[p][2],
                                'fill':   0
                            }, RULE_PARAM[route]),
                            'height':        '480px',
                            'width':         '98%',
                            'marginLeft':    80,
                            'marginRight':   60,
                            'stacktype':     'none',
                            'balloonformat': 'YYYY-MM-DD JJ:NN' if detailed else 'YYYY-MM-DD',
                            'aggregation':   'AVG',
                            'valuegrid':     1,
                            'minperiod':     600 if detailed else 86400
                        }]
                    }))
                for (r, rd) in rule_data.iteritems():
                    if 'text' in rd:
                        rd['text'] = eFilter(rd['text']).replace(u'\n', r'</p><p>').replace(u'\t', r'&nbsp;')
                        rd['text'] = re.sub(r'^rule\s+([A-Z0-9_]+)', r'rule <b>\1<\/b>', rd['text'])
                    else:
                        rd['text'] = ''
            except Exception, e:
                writelog("Error: %s" % str(e), True)
        else:
            for r in rule_data.keys():
                rules.append(r)
    try:
        env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
        template = env.get_template("showrule.html.template")
        print template.render(locals()).encode("utf-8")
    except Exception, e:
        writelog("Exception caught (tell developer, please): %s" % str(e), True)

elif action == 'save_monparams' and rule and route:
    params = dict(parse_qsl(os.environ['QUERY_STRING']))
    #rule_info = getRulesMonitoringInfo(rule, route, update_rules)
    rule_info = {}
    is_updated, repoDir = 0, RULES_DIRS['In'][0]
    if not rule_info or len(rule_info.keys()) < 1:
        writelog("Error while retrieving rule's monitoring parameters")
    user = AUTHOR[LOGINS[os.environ['REMOTE_ADDR']] if os.environ['REMOTE_ADDR'] in LOGINS else CFG['robot']['login']]
    for f in ['daily', '10min']:
        path = '{0}_path'.format(f)
        if path not in rule_info or not rule_info[path]:
            continue
        with open(rule_info[path]) as fh:
            fh_to, file_name = mkstemp(dir='WORKING_DIR')
            for row in fh:
                if re.match(r'^\s*\b{0}\b(?:\s+(.+))?'.format(rule), row):
                    s = ''
                    for p in RULE_PARAM[route]:
                        m1, m2 = '{0}_{1}_min'.format(f, p), '{0}_{1}_max'.format(f, p)
                        if (m1 not in params or not params[m1]) and (m2 not in params or not params[m2]):
                            continue
                        s += '{0}{1} {2}{3}'.format(' ' if s else '', p, params[m1] if m1 in params and params[m1] else '0', ' {0}'.format(params[m2]) if m2 in params and params[m2] else '')
                    print >>fh_to, '{0}{1}'.format(rule, ' {0}'.format(s) if s else '')
                else:
                    print >>fh_to, row
        fh_to.close()
        fh.close()
        try:
            os.rename(file_name, path)
        except Exception, e:
            writelog("Exception while rewriting file %s: %s" % (path, str(e)))
    try:
        s = check_output('cd {0} && git commit -am "Changed monitoring parameters for rule {1}" --author="{2}"'.format(repoDir, rule, user), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('Exception while pulling commits into master branch from remote: %s' % str(e), True)
    if re.search(r'reject|error|fatal', s, re.I):
        writelog('Making commit into master branch error: %s' % s)
    try:
        s = check_output('cd {0} && GIT_SSH="WORKING_DIR/ssh-rules.sh" git push origin master'.format(repoDir), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('Exception while pushing commits into master branch: %s' % str(e), True)
    if re.search(r'reject|error|fatal', s, re.I):
        writelog('Pushing commits in master branch to remote error: %s' % s)
