-- -*- Encoding: utf-8 -*-
-- kate: space-indent on; indent-width 4; replace-tabs on;

local data = redis.call("get", KEYS[1])
local lines, data_ids = {}, {}
for elem in string.gmatch(data, "[^\n]+") do
    local date_str = string.match(elem, "msgdate\": \"([^\"]+)")
    if date_str >= ARGV[1] then
        lines[#lines + 1] = elem
    else
        data_ids[#data_ids + 1] = string.match(elem, "data_id\": \"([^\"]+)")
    end
end
if #lines == 0 then -- Удаляем элемент KEYS[1] из базы
    redis.call('del', KEYS[1])
    redis.call('hdel', 'blocks', KEYS[1])
else --Перезаписать элемент тем, что осталось в lines 
    redis.call("set", KEYS[1], table.concat(lines, "\n").."\n")
    redis.call('hset', 'blocks', KEYS[1], #lines)
end
--Увеличить минимум msg_id на removed
local folder = string.match(KEYS[1], "([%w_]+)_%d+")
local min_msgid = redis.call("hget", "info", folder.."_min_msgid")
if #data_ids > 0 then redis.call("hset", "info", folder.."_min_msgid", min_msgid + #data_ids) end

return table.concat(data_ids, ',')
