#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, cgi, urlparse, urllib2, json, pymongo, string, redis, time
import email, email.header, email.mime.text, email.mime.multipart, email.mime.message
import ConfigParser, bson.binary, subprocess, socket
from datetime import datetime, timedelta
from traceback import format_exception
from collections import defaultdict
from bson.objectid import ObjectId
from smtplib import SMTP
from urllib import urlopen, unquote, urlencode
from mimetypes_icons import *

LOGFILE = "WORKING_DIR/logs/so-imapchick-ui.log"
MONTHS = {"Jan": 1, "Feb": 2, "Mar": 3, "Apr": 4, "May": 5, "Jun": 6, "Jul": 7, "Aug": 8, "Sep": 9, "Oct": 10, "Nov": 11, "Dec": 12}
logins = {
    '95.108.174.99': 'klimiky',
    '95.108.174.70': 'sgeorge',
    '95.108.173.38': 'luckybug',
    '2a02:6b8:0:408:ccd:af80:1b98:b58d':  'klimiky',
    '2a02:6b8:0:408:51bd:8959:f7fa:94f8': 'sgeorge',
    '2a02:6b8:0:408:ebe6:b59:2f43:77':    'luckybug'
}
cfg = ConfigParser.SafeConfigParser({
    'redis_cluster_name':    'imapchick',
    'redis_hosts':           'sas-9hj1mqfnn09ivo2p.db.yandex.net,vla-lypu9dngze8qheim.db.yandex.net',
    'redis_port':            6379,
    'redis_sentinel_port':   26379,
    'redis_db':              0,
    'redis_timeout':         2.0,
    'mongo_cluster':         'mail_so_813',
    'mongo_hosts':           'compldb1m.so.yandex.net,compldb1j.so.yandex.net,compldb1o.so.yandex.net',
    'mongo_uri':             'mongodb://compldb1jm.so.yandex.net,compldb1j.so.yandex.net,compldb1o.so.yandex.net/imap',
    'mongo_port':            27017,
    'mongo_db':              'imap',
    'mongo_replset':         'compldb',
    'block_size':            10000,
    'cleanup_folder_script': 'WORKING_DIR/so-imapchick-ui/cleanup_folder.lua',
    'search_folders_script': 'WORKING_DIR/so-imapchick-ui/search_folders.lua'
})
cfg.read('WORKING_DIR/so-imapchick-ui/imapui.ini')
BLOCK_SIZE, RETRY_COUNT = cfg.getint('imap', 'block_size'), 3
COMPLDLV_YT_LOG = "/logs/compldlv_yt.log"
SPDAEMON_HOST_IN = "complaint2-in.so.yandex-team.ru"
SPDAEMON_HOST_OUT = "complaint2-out.so.yandex-team.ru"
SPDAEMON_TIMEOUT = 5.0
SPDAEMON_MAX_MSG_SIZE = 64 * 1024
EMAIL_RE = "[\w+\-\.]+@(?:(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?|xn\-\-[a-z0-9-]+)\.)+(?:xn\-\-[a-z0-9-]+|[a-z]+)"
DEFAULT_RCPTTO = "undisclosed_recipients@added_manual.ru"
REDIS = {
    'cluster_name':  cfg.get('imap', 'redis_cluster_name') if cfg.has_option('imap', 'redis_cluster_name') else '',
    'cluster':       cfg.get('imap', 'redis_cluster') if cfg.has_option('imap', 'redis_cluster') else '',
    'hosts':         cfg.get('imap', 'redis_hosts'),
    'port':          cfg.getint('imap', 'redis_port') if cfg.has_option('imap', 'redis_port') else 6379,
    'sentinel_port': cfg.getint('imap', 'redis_sentinel_port') if cfg.has_option('imap', 'redis_sentinel_port') else 26379,
    'db':            cfg.getint('imap', 'redis_db') if cfg.has_option('imap', 'redis_db') else 0,
    'timeout':       cfg.getfloat('imap', 'redis_timeout') if cfg.has_option('imap', 'redis_timeout') else 2.0,
    'auth':          cfg.getboolean('imap', 'redis_auth') if cfg.has_option('imap', 'redis_auth') else True
}
SMTP_CONF = {   # SMTP settings
    'host':    "outbound-relay.yandex.net",
    'port':    25,
    'timeout': 5.0
}

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def writelog(msg, isTB=False, log_path=LOGFILE, prefx="", timePrefx=True):
    if not msg:
        return
    if timePrefx:
        prefx = time.strftime("[%Y-%m-%d %H:%M:%S]: ") + prefx
    try:
        tb = "\n"
        if isTB:
            tb = get_traceback()
        f = open(log_path, 'a')
        f.write(prefx + msg + tb)
        f.close()
    except Exception, e:
        print("Writelog error: %s" % str(e), file=sys.stderr)

def doRequest(url, prompt):
    try:
        f = urlopen(url)
        if f.getcode() == 200:
            return f.read()
        else:
            writelog('{0} response HTTP code: {1}, body: {2}'.format(prompt, f.getcode(), f.info()))
    except Exception, e:
        writelog('%s HTTP request failed: %s.' % (prompt, str(e)), True)
    return ""

def cluster_hosts(conductor_group, default_hosts=[]):
    if conductor_group:
        for i in range(RETRY_COUNT):
            r = doRequest("https://c.yandex-team.ru/api-cached/groups2hosts/%s" % conductor_group, "Get DB cluster hosts for group %s" % conductor_group)
            if r:
                hosts = map(str.strip, r.splitlines())
                return hosts if len(hosts) > 0 else default_hosts
            else: continue
    return default_hosts

def getRedisCredentials(redis_cfg):
    f, CURDIR, dbname = None, 'WORKING_DIR', ''
    if 'cluster_name' in redis_cfg and redis_cfg['cluster_name']:
        dbname = redis_cfg['cluster_name']
        if dbname.endswith('db'):
            dbname = dbname[:len(dbname) - 2]
    try:
        if dbname:
            if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                CURDIR = os.path.dirname(os.path.abspath(__file__))
                if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                    CURDIR = '.'
            if os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                f = open('{0}/.redis.{1}'.format(CURDIR, dbname))
                for line in f:
                    sf = line.split(':')
                    if len(sf) == 1:
                        redis_cfg['password'] = sf[0].strip()
                        break
                    elif len(sf) == 2 and sf[0] == redis_cfg['cluster_name']:
                        redis_cfg['password'] = sf[1].strip()
                        break
                f.close()
            else:
                writelog("Failed to locate file with redis secret!")
        else:
            writelog("Failed to determine Redis cluster_name!")
    except Exception, e:
        writelog("getRedisCredentials exception: %s" % str(e), True)

def redis_connect(host, port, redis_cfg):
    if 'password' in redis_cfg and redis_cfg['password']:
        return redis.Redis(host=host, port=port, db=redis_cfg['db'], password=redis_cfg['password'], socket_timeout=redis_cfg['timeout'])
    else:
        return redis.Redis(host=host, port=port, db=redis_cfg['db'], socket_timeout=redis_cfg['timeout'])

def redis_reconnect(redis_cfg):
    rediscli = None
    try:
        if 'auth' in redis_cfg and redis_cfg['auth']:
            getRedisCredentials(redis_cfg)
        else:
            redis_cfg['password'] = None
        if 'host' in redis_cfg and redis_cfg['host']:
            rediscli = redis.Redis(host=redis_cfg['host'], port=redis_cfg['port'], db=redis_cfg['db'], passport=redis_cfg['password'], socket_timeout=redis_cfg['timeout'])
        elif 'hosts' in redis_cfg and redis_cfg['hosts']:
            if 'cluster_name' in redis_cfg and redis_cfg['cluster_name']:
                try:
                    redis_sentinel = redis.Redis(host=redis_cfg['hosts'].split(',')[0], port=redis_cfg['sentinel_port'], socket_timeout=redis_cfg['timeout'])
                    host = redis_sentinel.sentinel_get_master_addr_by_name(redis_cfg['cluster_name'])
                    rediscli = redis_connect(host[0], host[1], redis_cfg)
                except Exception, e:
                    writelog("Exception in redis_reconnect for cluster '%s': %s" % (redis_cfg['cluster_name'], str(e)), True)
            else:
                for host in redis_cfg['hosts'].split(','):
                    try:
                        rediscli = redis_connect(host, redis_cfg['port'], redis_cfg)
                        if rediscli.info()["role"] == "master":
                            return rediscli
                    except Exception, e:
                        writelog("Exception in redis_reconnect: %s" % str(e), True)
    except Exception, e:
        writelog("Exception while redis_reconnect: %s" % str(e), True)
    return rediscli

def redis_autoreconnect(r):
    try:
        if not r or r and r.execute_command('role')[0] != 'master':
            r = redis_reconnect(REDIS)
    except:
        r = redis_reconnect(REDIS)

def get_dlvlog(queueid, msgid, route, msgtime):
    try:
        for i in range(2):
            content = doRequest("http://statlog.so.yandex.net:5005/searchall?qid=%s&mid=%s&route=%s&time=%d" % (queueid, msgid, route, msgtime))
            if content:
                return content.strip()
            else:
                continue
    except Exception, e:
        writelog("get_dlvlog exception: %s" % str(e), True)
    return ""

def decode_part(part):
    try:
        return part[0].decode(part[1] if part[1] else "ascii", "ignore")
    except:
        pass
    return part[0]

def decode_header(s):
    if s is None:
        return ""
    try:
        parts = email.header.decode_header(s)
        if not parts:
            return s.decode("ascii", "ignore").strip()
        return " ".join(map(decode_part, parts)).strip()
    except:
        return s.decode("ascii", "ignore").strip()

def to_utf8(data, default = ''):
    try:
        return data.encode("utf-8", "ignore")
    except UnicodeDecodeError:
        try:
            return "".join(map(lambda c: unichr(ord(c)), data))
        except:
            return default

def decode_email_str(email):
    emails = []
    for (label, email) in re.findall("([^@]*\s+)?<?\s*([^\s<>,]+@[^\s<>,]+)\s*>?", email if email else ""):
        label = re.sub("\"|'|,", "", re.sub("<?\s*([^\s<>,]+@[^\s<>,]+)\s*>?", "", label)).strip()
        try:
            if label:
                emails.append("%s <%s>" % (decode_header(label), email))
            else:
                emails.append(email)
        except Exception, e:
            writelog("decode_email_str error: '%s'" % str(e), True)
    return ", ".join(emails)

def decode_email(email):
    emails = re.findall("<?\s*([^\s<>,]+@[^\s<>,]+)\s*>?", email)
    msgto = re.sub("\"|'|,", "", re.sub("<?\s*([^\s<>,]+@[^\s<>,]+)\s*>?", "", email)).strip()
    return decode_header(msgto), ", ".join(map(lambda email: email.strip().strip("<>"), emails))

def decodestring(s, encoding=''):
    sp, s2, enc = s.split('?'), s, encoding
    try:
        if len(sp) < 3:
            try:
                return to_utf8(s, s)
            except Exception, e:
                writelog("to_utf8 error: '%s'" % str(e), True)
            try:
                (s2, enc) = email.header.decode_header(s)
                return s2
            except Exception, e:
                writelog("decode error: '%s'" % str(e), True)
            s2 = (s + '==').decode(encoding)
        else:
            s2 = ""
            for match in re.finditer("(=\?\S+\?=)", s):
                sp = match.group(1).split('?')
                enc = 'base-64' if sp[2] == 'B' or len(sp) > 1 and encoding == "base64" and sp[2] != 'Q' else 'quopri'
                s2 += (sp[3] + '=' + ('=' if enc == 'base-64' else '')).decode(enc).decode(sp[1])
            return s2
    except Exception, e:
        writelog("decodestring error: '%s'" % str(e), True)
    return s2

KEY = ["subj", "from_label", "from_email", "to_label", "to_email", "ip", "cmpldate", "msgdate", "from_domain", "quueid", "stid" ]
indexes = defaultdict(lambda: defaultdict(countedset))
docs = defaultdict(dict)

def load_indexes():
    sys.stdout.flush()
    for collection in db.collection_names(False):
        if not collection.startswith("so_") or collection.find("_indexes") < 0:
            continue
        for i, obj in enumerate(db[collection].find()):
            if i % 10000 == 0:
                gevent.sleep()
            data_id = str(obj["data_id"])
            for key in KEY:
                docs[data_id][key] = obj[key]
                indexes[collection][key].add((obj[key], data_id))

def get_msg_time(msgdate):
    try:
        da = decode_header(msgdate.strip()).split();
        d = "%s-%02d-%02d %s" % (da[3], MONTHS[da[2].strip()], int(da[1]), da[4])
    except Exception, e:
        writelog("get_msg_time exception: %s" % str(e), True)
    return d

def get_msg_timestamp(msgdate):
    try:
        da = decode_header(msgdate.strip()).split();
        dt = da[4].split(':')
        d = datetime(da[3], MONTHS[da[2].strip()], int(da[1]), dt[0], dt[1], dt[2])
    except Exception, e:
        writelog("get_msg_timestamp exception: %s" % str(e), True)
    return int(d)

def replace_html_chars(m):
    if m.group(1) == "lt":
        return "<"
    elif m.group(1) == "gt":
        return ">"
    elif m.group(1) == "amp":
        return "&"
    elif m.group(1) == "quot":
        return '"'

def replace_dlvlog(header, dlvlog):
    m = re.search(r'^<b>{}:</b>(.*?)<br>$'.format(header), dlvlog, re.M)
    if m and m.group(1):
        try:
            dlvlog = dlvlog[:m.start()] + '<b>{}:</b>'.format(header) + re.sub(r'&([a-z]+);', replace_html_chars, cgi.escape(decode_part([m.group(1), "utf-8"])).encode('ascii', 'xmlcharrefreplace')) + "<br>" + replace_dlvlog(header, dlvlog[m.end():])
        except Exception, e:
            writelog("replace_dlvlog failed: %s" % str(e), True)
    return dlvlog

def create_header_part(msg):
    params = {}
    try:
        params["from"] = cgi.escape(decode_part([decode_email_str(msg["from"]), "utf-8"])).encode('ascii', 'xmlcharrefreplace')
        params["to"] =   cgi.escape(decode_part([decode_email_str(msg["to"]), "utf-8"])).encode('ascii', 'xmlcharrefreplace')
        params["subj"] = cgi.escape(decode_header(msg["subject"])).encode('ascii', 'xmlcharrefreplace') if msg["subject"] else ""
        params["d"] =    get_msg_time(msg["date"])
        params["complrequest"] = msg["iy-complrequest"]
        params["queueid"] = msg["x-yandex-queueid"]
        params["route"] = msg["x-yandex-route"]
    except Exception, e:
        writelog("create_header_part error: '%s'" % str(e), True)
    return u"""
        <html>
        <body><div style="font-family: monospace;">
        <table border='0' width='100%%'>
        <tr><td width='1%%'><b>From:</b></td><td>%(from)s</td><td align='right' style="white-space:nowrap;">%(d)s</td></tr>
        <tr><td width='1%%'><b>To:</b></td><td>%(to)s</td><td align='right'></td></tr>
        <tr><td width='1%%'><b>Subject:</b></td><td>%(subj)s</td><td align='right'></td></tr>
        <tr><td width='1%%'><b>IY-ComplRequest:</b></td><td>%(complrequest)s</td><td align='right'></td></tr>
        <tr><td width='1%%'><b>X-Yandex-QueueID:</b></td><td>%(queueid)s</td><td align='right'></td></tr>
        <tr><td width='1%%'><b>X-Yandex-Route:</b></td><td>%(route)s</td><td align='right'></td></tr>
        </table></div></body>
        </html>""" % params

def remove_external_links(msgpart):
    ext_urls, txt = defaultdict(int), ''
    for m in re.finditer(r'<meta [^<>]*\bcontent=(["\']).*?\burl=(https?://[^"\']+?)\1[^<>]*>', msgpart):
        if m.group(2):
            ext_urls[m.group(2)] += 1
    for m in re.finditer(r'<\w+ [^<>]*\bstyle=(["\'])[^<>]*?\burl[=\(](https?://[^"\']+?)[\s\);][^"\']+?\1[^<>]*>', msgpart):
        if m.group(2):
            ext_urls[m.group(2)] += 1
    for m in re.finditer(r'<\w+ [^<>]*\b(?:src|href)=(["\'])(https?://[^"\']+?)\1[^<>]*>', msgpart):
        if m.group(2):
            ext_urls[m.group(2)] += 1
    txt = re.sub(r'<meta [^<>]*\bcontent=(["\']).*?\burl=https?://[^"\']+?\1[^<>]*>', '', msgpart)
    txt = re.sub(r'(<\w+ [^<>]*\bstyle=(["\'])[^<>]*?)\burl[=\(](https?://[^"\']+?)[\s\);]([^"\']+?\2[^<>]*>)', r'\1none\4', txt)
    txt = re.sub(r'(<\w+ [^<>]*\b(?:src|href)=(["\']))(https?://[^"\']+?)(\2[^<>]*>)', r'\1\4', txt)
    return (ext_urls.keys(), txt)

def email_to_html(msg, is_top = 1):
    parts, attaches, texts, text_attaches = [], [], [], []
    for part in msg.walk():
        ct, cd = part.get_content_type(), part.get('Content-Disposition')
        if ct.startswith("text/"):
            if cd and cd.startswith('attachment'):
                text_attaches.append(part)
            else: texts.append(part)
        elif ct == "message/rfc822":
            msg_attaches = []
            msgpart = part.get_payload()[0]
            (inner_parts, msg_attaches) = email_to_html(msgpart, 0)
            if inner_parts:
                parts.append({
                    'type':         'part-header',
                    'content-type': ct,
                    'text':         create_header_part(msgpart)
                })
                parts.extend(inner_parts)
        elif not ct.startswith("multipart/"):
            if cd and cd.startswith('attachment'):
                filename = part.get_filename()
                enc = part.get('Content-Transfer-Encoding')
                filename = decodestring(filename, enc)
                attaches.append({
                    'type':         'binary-attachment',
                    'content-type': part.get_content_type(),
                    'params':       [part.get_params()],
                    'filename':     filename,
                    'encoding':     enc,
                    'icon':         mt_icons.get(ct)
                })
    if is_top and len(texts) > 0:
        msgpart = texts[0].get_payload(decode=True)
        if msgpart:
            for header in ['subj', 'from', 'to', 'phon', 'flin', 'atch', 'rptn', 'log ']:
                msgpart = replace_dlvlog(header, msgpart)
            m, charset = re.search(r'^<b>mess:</b> (.*)$', msgpart, re.M), texts[0].get_content_charset()
            if m and m.group(1):
                s = m.group(1)
                s = re.sub(r' id=(\d+)', r' id=<a target="_blank" href="https://web.so.yandex-team.ru/users_abuse.py?suid=\1">\1</a>', s);
                msgpart = re.sub(r'(?m)^<b>mess:</b> (.*)$', '<b>mess:</b> %s' % s, msgpart);
            else:
                msgpart = re.sub(r'(<b>mess:</b> .*?\bid=)(\d+)(.*?<br>)', r'\1<a target="_blank" href="https://web.so.yandex-team.ru/users_abuse.py?suid=\2">\2</a>\3', msgpart)
            #msgpart = re.sub(r'(<b>mfrm:</b>.*?\bid=)(\d+)(.*?<br>)', r'\1<a target="_blank" href="http://freemail.so.yandex.net/fms/getsenderinfo/?type=YAN&email=\2&shingle=">\2</a>\3', msgpart)
            #msgpart = re.sub(r'(<b>log :</b> t = (\d+), .*? )\b([a-z0-9]+)(\s+(?:\(.*?\))?\s*<br>)', r'\1<a target=\'_blank\' href="http://complshingler1h.so.yandex.net/compl_shingler?shingle=\3&type=\2&actiface=viewshinfo&authlogin=%s">\3</a>\4' % login, msgpart)
            msgpart = re.sub(r'(<b>rcvd:</b> source ip = )(\d+\.\d+\.\d+\.\d+)(.*?<br>)', r'\1<a target="_blank" href="http://statip.so.yandex.net/sostatip?ip=\2&actiface=viewipstat&authlogin=%s">\2</a>\3' % login, msgpart)
            msgpart = re.sub(r'(<b>rcvd:</b> source ip = )(\S+:\S+)(.*?<br>)', r'\1<a target="_blank" href="http://statip.so.yandex.net/sostatip?ip=\2&actiface=viewipstat&authlogin=%s">\2</a>\3' % login, msgpart)
            if not charset: charset = "ascii"
            parts.insert(0, {
                'type':         'dlvlog',
                'content-type': 'text/html',
                'text':         "<div style=\"font-family: monospace;\">%s</div>" % unicode(msgpart, charset, "ignore")
            })
    else:
        text_parts = []
        for part in texts:
            msgpart = part.get_payload(decode = True)
            if msgpart:
                charset = part.get_content_charset()
                if not charset: charset = "ascii"
                text_parts.append({
                    'type':         'text',
                    'content-type': part.get_content_type(),
                    'text':         unicode(msgpart, charset, "ignore"),
                    'text_raw':     cgi.escape(unicode(msgpart, charset, "ignore"))
                })
        for part in text_attaches:
            msgpart = part.get_payload(decode = True)
            if msgpart:
                charset, filename = part.get_content_charset(), decode_header(part.get_filename())
                if not charset: charset = "ascii"
                ext_urls, msgpart_clear = remove_external_links(msgpart)
                if len(ext_urls) < 1:
                    s1 = s2 = s3 = ''
                elif len(ext_urls) < 3:
                    s1, s2, s3 = "<div id='ext_urls_brief'>%s</div>" % '<br />'.join(ext_urls), '', ''
                else:
                    s1 = "<div id='ext_urls_brief'>%s<br />%s ...</div>" % (ext_urls[0], ext_urls[1])
                    s2 = "<div id='ext_urls' style='display:none;'>%s</div>" % '<br />'.join(ext_urls)
                    s3 = "<input type='button' onclick='showSpoiler(this, \"ext_urls\");' value='Показать' />"
                text_parts.append({
                    'type':         'part-header',
                    'content-type': part.get_content_type(),
                    'text':         u"""
        <html><head><script>
        function showSpoiler(obj, id){
          var urls_full = document.getElementById(id), urls_brief = document.getElementById(id + '_brief');
          if (urls_full.style.display == "none") {
            urls_full.style.display = ""; urls_brief.style.display = "none"; obj.value = "Скрыть"
          } else { urls_full.style.display = "none"; urls_brief.style.display = ""; obj.value = "Показать" }
        }</script></head><body><div style="font-family: monospace;"><table border='0' width='100%%'>
        <tr><td width='1%%'><b>Filename:</b></td><td>%s</td><td></td></tr>
        <tr><td width='1%%' style="white-space:nowrap;"><b>External links:</b></td><td>%s%s</td><td>%s</td></tr>
        </table></div></body></html>""" % (filename, s1, s2, s3)
                })
                text_parts.append({
                    'type':         'text-attachment',
                    'content-type': part.get_content_type(),
                    'text':         unicode(msgpart_clear, charset, "ignore"),
                    'text_raw':     cgi.escape(unicode(msgpart, charset, "ignore"))
                })
        parts = text_parts + parts
    return (parts, attaches)

def add_to_pipe(pipe, collection, key, value, data_id):
    pipe.oadd("%s_%s" % (collection, key), ("%s_%s" % (unicode(value, "utf-8", "ignore").upper(), data_id)).encode("utf-32"))

def get_block(collection, msgid):
    return "%s_%d" % (collection, msgid / BLOCK_SIZE)

def getfolderinfo(folders, info, result):
    for folder in folders:
        f = folder['id'] if isinstance(folder, dict) else folder
        try:
            minid = int(info.get("%s_min_msgid" % f, 0))
            maxid = int(info.get("%s_max_msgid" % f, 0))
            result[f] = (maxid, minid)
            if isinstance(folder, dict) and "nodes" in folder:
                getfolderinfo(folder["nodes"], info, result)
        except Exception, e:
            writelog("Exception for folder '%s': %s" % (folder, str(e)), True)

def attachNode(arr, node):
    node['id'] = node['_id']
    if not node['nodes']: return arr
    for i in range(0, len(node['nodes'])):
        j = 0
        while j < len(arr):
            if arr[j]['_id'] == node['nodes'][i]: break
            else: j += 1
        if j < len(arr) and arr[j]['_id'] == node['nodes'][i]:
            node['nodes'][i] = arr.pop(j)
            attachNode(arr, node['nodes'][i])

def load_foldertree():
    folders = []
    try:
        for folder in db['folders'].find({'hidden': {'$ne': 1}}, sort=[('_id', 1)]):
            folders.append(folder)
    except Exception, e:
        writelog("TokuMX DB error: %s" % str(e), True)
    for node in folders: attachNode(folders, node)
    return folders

def request_getinfo(env, start_response, address, params):
    global r
    redis_autoreconnect(r)
    folderinfo, info, blocks = {}, {}, {}
    for i in range(RETRY_COUNT):
        try:
            blocks, info = r.hgetall("blocks"), r.hgetall("info")
            break
        except Exception, e:
            writelog("Exception: %s" % str(e), True)
            continue
    getfolderinfo(load_foldertree(), info, folderinfo)
    start_response("200 OK", [("Content-type", "application/json")])
    return [json.dumps({"folders": folderinfo, "blocks": blocks}) if info else ""]

def request_getblock(env, start_response, address, params):
    global r
    redis_autoreconnect(r)
    block = params.get("block", "").replace("-", "_")
    start = time.time()
    def getblock(r):
        for i in range(RETRY_COUNT):
            try:
                pipe = r.pipeline()
                pipe.hget("blocks", block)
                pipe.get(block); break
            except Exception, e:
                writelog("Exception: %s" % str(e), True)
                continue
        return pipe.execute()
    count, data = getblock(r)
    writelog(' '.join([block, str(count), str(time.time() - start)]))
    start_response("200 OK", [("Content-type", "text/plain")])
    if data:
        return ["%s %s" % (count, data)]
    else:
        return [""]

def request_folderoptions(env, start_response, address, params):
    global r
    redis_autoreconnect(r)
    collection = params.get("folder", "").replace("-", "_")
    for i in range(RETRY_COUNT):
        try:
            info = r.hgetall("%s_info" % collection); break
        except Exception, e:
            writelog("Exception: %s" % str(e), True)
            continue
    start_response("200 OK", [("Content-type", "application/json")])
    return [json.dumps(info) if info else ""]

def send_to_imapchick(data, params):
    start, answer, err = time.time(), '', ''
    try:
        r = urllib2.Request(url=cfg.get('imap', 'imapchick_host') + "/imapchick/addmessage?%s" % urlencode(params),
                            data=data, timeout=cfg.getint('imap', 'imapchick_timeout'))
        f = urllib2.urlopen(r)
        if f:
            answer = f.read()
        else:
            writelog('send_to_imapchick request response is empty!')
    except urllib2.URLError, e:
        writelog('send_to_imapchick HTTP request failed: %s' % e.reason, True)
        err = e.reason
    except urllib2.HTTPError, e:
        writelog('send_to_imapchick HTTP request failed (code=%s): %s' % (e.code, e.reason), True)
        err = e.reason
    except Exception, e:
        writelog('send_to_imapchick HTTP request failed: %s' % str(e), True)
        err = str(e)
    if answer:
        status = "OK"
    else:
        status = str(err)
    return time.time() - start, status

def default(s, defaultval):
    return s if s else defaultval

def sp_daemon_command(sock, cmd):
    sock.send(cmd, socket.MSG_DONTWAIT)
    answer = sock.recv(3)
    if not answer.startswith("OK"):
        raise Exception("Answer not OK. Cmd: %s. Answer: %s" % (cmd, answer))

def sp_daemon_answer(sock):
    return sock.recv(1024)

def parse_msg(msg):
    match = re.search("^From:\s.*?<(%s)>" % EMAIL_RE, msg, re.IGNORECASE | re.MULTILINE)
    if not match:
        match = re.search("^From:\s(%s)" % EMAIL_RE, msg, re.IGNORECASE | re.MULTILINE)
    from_addr = match.group(1) if match else ""
    match = re.search("^To:\s.*?<(%s)>" % EMAIL_RE, msg, re.IGNORECASE | re.MULTILINE)
    if not match:
        match = re.search("^To:\s(%s)" % EMAIL_RE, msg, re.IGNORECASE | re.MULTILINE)
    to_addr = match.group(1) if match else ""
    match = re.search("^Received:\s+.+?(\[[0-9\.\:]+?\])", msg, re.IGNORECASE | re.MULTILINE)
    domain = match.group(1) if match else ""
    return from_addr, to_addr, domain

def sp_daemon_check(route, msg):
    if not route or route in ("in", "corp"):
        host, port = SPDAEMON_HOST_IN, 2525
    else:
        host, port = SPDAEMON_HOST_OUT, 5252
    msg = msg[:SPDAEMON_MAX_MSG_SIZE]
    try:
        sock = socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
        sock.settimeout(SPDAEMON_TIMEOUT)
        sock.connect((host, port))
        from_addr, to_addr, domain = parse_msg(msg)
        sp_daemon_command(sock, "CONNECT %s\n" % default(domain, "[1.1.1.1]"))
        sp_daemon_command(sock, "HELO \n")
        sp_daemon_command(sock, "MAILFROM %s SIZE=%d\n" % (from_addr, len(msg)))
        sp_daemon_command(sock, "RCPTTO %s\n" % default(to_addr, DEFAULT_RCPTTO))
        sp_daemon_command(sock, "DATA SIZE=%d\n" % len(msg))
        sock.sendall(msg, socket.MSG_DONTWAIT)
    except Exception, e:
        writelog("Exception: %s" % str(e), True)
        return "sp-daemon error: " + str(e)
    return "OK"

def sendEmail(msg, fromaddr, toaddr):
    try:
        if toaddr:
            server = SMTP(SMTP_CONF['host'], SMTP_CONF['port'], timeout=SMTP_CONF['timeout'])
            server.sendmail(fromaddr, toaddr, msg)
            server.quit()
        else:
            writelog("Sending email failed: to-addr must be set!")
    except Exception, e:
        writelog("Error in sendEmail: %s" % str(e), True)

def application(env, start_response):
    if not hasattr(application, "init"):
        application.init = True
        global r, db, mt_icons, login
        r = None
        try:
            if cfg.has_option('imap', 'redis_cluster'):
                REDIS['hosts'] = ','.join(cluster_hosts(REDIS['cluster'], REDIS['hosts'].split(',')))
            r = redis_reconnect(REDIS)
            if cfg.has_option('imap', 'mongo_cluster'):
                cfg.set('imap', 'mongo_uri', "mongodb://%s/%s" % (','.join(cluster_hosts(cfg.get('imap', 'mongo_cluster'),
                                                                          cfg.get('imap', 'mongo_hosts').split(','))), cfg.get('imap', 'mongo_db')))
        except Exception, e:
            writelog("Redis DB connection error: %s" % str(e), True)

    redis_autoreconnect(r)
    db = pymongo.MongoClient(host=cfg.get('imap', 'mongo_uri'), port=cfg.getint('imap', 'mongo_port'),
                             replicaSet=cfg.get('imap', 'mongo_replset'))[cfg.get('imap', 'mongo_db')]
    mt_icons = MimeTypesIcons()
    request_method = env.get("REQUEST_METHOD", "")
    request_uri = env["REQUEST_URI"]
    login = logins[env["REMOTE_ADDR"]] if env["REMOTE_ADDR"] and env["REMOTE_ADDR"] in logins else ""
    params = dict(urlparse.parse_qsl(request_uri.split("?")[-1]))
    address = request_uri.split("?")[0].rstrip("/")

    if address == "/ping":
        start_response("200 OK", [])
        return []
    elif address == "/imapui/message":
        folder = params.get("folder", "").replace("_indexes", "")
        recid = params.get("id", "")
        answer = """<html>
<head>
    <script src="/js/jquery/jquery.js"></script>
    <script language="javascript" type="text/javascript">
        function addEvent(el, t, handler, data) {
            if (el.addEventListener)
                el.addEventListener(t, handler, false);
            else el.attachEvent("on" + t, handler);
        }
        function addFrame(html, id) {
            var iframe = document.createElement("iframe");
            iframe.srcdoc = html;
            iframe.width = "100%%";
            iframe.frameBorder = "0";
            iframe.style = "word-wrap:break-word;";
            if (id)
                iframe.id = 'frame' + id.toString();
            //iframe.scrolling = "no";
            iframe.onload = function() {
                var is_chrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
                if (id != undefined) {
                    if(is_chrome)
                        this.height = this.contentDocument.documentElement.scrollHeight + 15; //Chrome
                    else
                        this.height = this.contentWindow.document.body.scrollHeight + 20;
                } else this.height = 20;
                iframe.contentWindow.onkeydown = function(event) {
                    if(event.ctrlKey && event.keyCode == 85) {
                        window.open("/imapui/messagebody?folder=%s&id=%s", "_blank");
                        event.preventDefault();
                    }
                };
                var elements = iframe.contentWindow.document.getElementsByTagName("a");
                for(var i = 0; i < elements.length; i++)
                    elements[i].target = "_blank";
            };
            document.body.appendChild(iframe);
        }
        function onChangeViewFmt(id, part_text) {
            var iframe = document.getElementById('frame' + id);
            iframe.srcdoc = "<html><body><pre>" + part_text + "</pre></body></html>";
        }
        function addCell(tr, text, styleRules) {
            var td = document.createElement("td");
            td.innerHTML = text;
            for (var tag in styleRules)
                td.style[tag] = styleRules[tag];
            tr.appendChild(td);
        }
        function addRadioCell(tr, id, v, text, part_text, is_checked) {
            var td = document.createElement("td"), input = document.createElement("input");
            input.type = "radio";
            input.name = "view_format" + id.toString();
            input.value = v;
            if (is_checked) input.checked = "checked";
            addEvent(input, 'change', function() { onChangeViewFmt(id.toString(), part_text); });
            td.appendChild(input);
            var t = document.createTextNode(text);
            td.appendChild(t);
            td.style['width'] = '5em';
            tr.appendChild(td);
        }
        function addBar(part, id) {
            var table = document.createElement("table"), tr = document.createElement("tr");
            table.width = "100%%";
            table.id = "table" + id.toString();
            table.style['margin-left'] = '0.5em';
            table.style['font-family'] = 'monospace';
            table.style['border-bottom-style'] = 'dashed';
            if ("content-type" in part) {
                addCell(tr, "Content-Type:", {'font-weight': 'bold', 'width': '8em'});
                addCell(tr, part["content-type"]);
            } else { addCell(tr, ""); addCell(tr, ""); }
            addRadioCell(tr, id, "html", "HTML", part['text'], true);
            if (!('text_raw' in part))
                part['text_raw'] = part['text'];
            addRadioCell(tr, id, "raw", "Raw", part['text_raw']);
            table.appendChild(tr);
            document.body.appendChild(table);
        }
        function onLoad() {
            $.ajax({
                url:      "/imapui/messagedata",
                dataType: "json",
                data:     "folder=%s&id=%s",
                success:  function(data) {
                    for (var i = 0; i < data['parts'].length; i++) {
                        var part = data['parts'][i];
                        var text = part['text'];
                        if (part['type'] != 'part-header' && part['type'] != 'dlvlog') {
                            addBar(part, i);
                            text = "<html><body><pre>" + text + "</pre></body></html>";
                        }
                        addFrame(text, i);
                        if (i + 1 < data['parts'].length)
                            addFrame("<html><body><hr></body></html>");
                    }
                    if (data['attachments'].length > 0) {
                        var frame = "<html><body><table>", a = {};
                        for (var i = 0; i < data['attachments'].length; i++) {
                            a = data['attachments'][i]
                            frame += '<tr><td><table><tr><td><img width=' + a['icon']['w'] + ' height=' + a['icon']['h'] + ' src="' + a['icon']['path'] +
                                '"></td><td style="white-space: nowrap;vertical-align: middle;">' + a['filename'] + '</span></td><tr></table></td></tr>';
                        }
                        addFrame(frame + "</table></body></html>");
                    }
                }
            });
        }
    </script>
</head>
<body onload="onLoad()">
</body>
</html>""" % (folder, recid, folder, recid)
        start_response("200 OK", [])
        return [answer]

    elif address == "/imapui/messagedata":
        folder = params.get("folder", "").replace("_indexes", "")
        recid = params.get("id", "")
        try:
            obj = db[folder].find_one({"_id": ObjectId(recid)})
        except Exception, e:
            msg = "DB error in retrieving of data with _id = %s in folder '%s'" % (recid, folder)
            writelog(msg)
            start_response("200 OK", [("Content-type", "application/json")])
            return [json.dumps({'parts': [msg]})]
        #print obj
        data = obj.get("data", "") if obj else ""
        msg = email.message_from_string(data)
        message = {'parts': [], 'attachments': []}
        (message['parts'], message['attachments']) = email_to_html(msg)
        message['parts'].insert(0, {
            'type': 'part-header',
            'text': create_header_part(msg)
        })
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(message)]

    elif address == "/imapui/messagebody":
        folder = params.get("folder", "").replace("_indexes", "")
        recid = params.get("id", "")
        try:
            obj = db[folder].find_one({"_id": ObjectId(recid)})
        except Exception, e:
            msg = "DB error in retrieving of data with _id = %s in folder '%s': %s" % (recid, folder, str(e))
            writelog(msg, True)
            start_response("200 OK", [("Content-type", "application/json")])
            return [json.dumps({'parts': [msg]})]
        data = obj.get("data", "") if obj else ""
        start_response("200 OK", [("Content-type", "text/plain")])
        return [data]

    elif address == "/imapui/folderlist":
        info = {}
        for collection in db.collection_names(False):
            if not collection.startswith("so_"):
                continue
            keyname = "%s_subj" % collection
            total = r.ocard(keyname)
            info[collection] = total

        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(info)]

    elif address == "/imapui/getblock":
        return request_getblock(env, start_response, address, params)

    elif address == "/imapui/getinfo":
        return request_getinfo(env, start_response, address, params)

    elif address == "/imapui/folderoptions":
        return request_folderoptions(env, start_response, address, params)

    elif address == "/imapui/foldertree":
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(load_foldertree())]

    elif address == "/imapui/folderinfo":
        folder = params.get("folder", "")
        keyname = "%s_subj" % folder
        total = r.ocard(keyname)
        start_response("200 OK", [])
        return [json.dumps({"total": total})]

    elif address == "/imapui/fishing":
        folder = params.get("folder", "").replace("_indexes", "")
        recid = params.get("id", "")
        obj = db[folder].find_one({"_id": ObjectId(recid)})
        data = obj.get("data", "") if obj else ""
        m = re.search(r'^IY-ComplRequest: .*?\&stid=([^&\s]+?)\&', data, re.I | re.M)
        stid = m.group(1) if m else ''
        params['folder'] = 'so_phishing_report'
        t, status = send_to_imapchick(data, params)
        start_response("200 OK", [("Content-type", "application/json")])
        return json.dumps({'stid': stid, 'status': status, 'time': t})

    elif address == "/imapui/email-send":
        folder = params.get('folder', '').replace('_indexes', '')
        recid = params.get('id', '')
        fromaddr = "so-analytics@yandex-team.ru"
        rcpt = params.get('rcpt', 'so-analytics@yandex-team.ru')
        subj = params.get('subj', '')
        comment = params.get('comment', '')
        obj = db[folder].find_one({"_id": ObjectId(recid)})
        data = obj.get("data", "") if obj else ""
        if not subj:
            m = re.search(r'\nSubject: (.*?)\n\S*?:', data, re.I | re.S)
            subj = m.group(1) if m else ''
        msg = email.mime.multipart.MIMEMultipart('mixed')
        msg['From'] = fromaddr
        msg['To'] = rcpt
        msg['Subject'] = subj
        output, error_output = '', ''
        msg.attach(email.mime.text.MIMEText(unquote(comment)))
        msg.attach(email.mime.message.MIMEMessage(email.message_from_string(data)))
        sendEmail(msg.as_string(), fromaddr, rcpt)
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps({"output": output, "error_output": error_output})]

    elif address == "/imapui/getcols":
        folder = params.get('folder', '').replace('_indexes', '')
        sortCol = params.get('col', '')
        sortDir = params.get('dir', 'down')
        saveType = int(params.get('type', '1'))
        cols = params.get('cols', '').split(',')
        rows, filterCond = defaultdict(int), defaultdict(lambda: '')
        data, dataRes = [], []; i = i1 = 0
        name = folder + '_' + (sortCol if saveType == 1 else 'columns')
        while 1:
            i += 1
            col, txt = params.get("filtertype%d" % i, None), params.get("filter%d" % i, None)
            if not col or not txt: break
            filterCond[col] = unicode(unquote(txt), "utf-8")
        redis_autoreconnect(r)
        for block in r.hgetall("blocks"):
            if not re.match(r'%s_\d+' % folder, block): continue
            for b in r.get(block).split("\n"):
                try:
                    if b:
                        block_obj, is_add = json.loads(b), 0
                        for col in sorted(filterCond.keys()):
                            if not col in block_obj: continue
                            if re.search(filterCond[col], block_obj[col], re.I): is_add += 1
                        if is_add == len(filterCond.keys()): data.append(block_obj)
                except Exception, e:
                    writelog("Error in parsing JSON in string '%s': %s" % (b, str(e)), True)
        if saveType == 1:
            for row in data: rows[row[sortCol]] += 1
            m1, m2 = int(params.get('min', 0)), int(params.get('max', 0))
            for k in sorted(rows.keys(), cmp = lambda x,y: cmp(rows[x], rows[y]), reverse = (sortDir == 'down')):
                if m1 > 0 and rows[k] < m1 or m2 > 0 and rows[k] > m2: continue
                dataRes.append({'cnt': rows[k], sortCol: k})
        elif saveType == 2:
            dataRes = sorted(data, cmp = lambda x,y: cmp(x[sortCol], y[sortCol]), reverse = (sortDir == 'down'))
        start_response('200 OK', [("Content-type", "application/json")])
        return [json.dumps(dataRes)]

    elif address == "/imapui/folder-get-info":
        folder = params.get('folder', '').replace('_indexes', '')
        try:
            folder_info = db['folders'].find_one({'_id': folder})
        except Exception, e:
            writelog("DB error: %s" % str(e), True)
            folder_info = {'error': str(e)}
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(folder_info)]

    elif address == "/imapui/folder-set-dtl":
        folder = params.get('folder', '').replace('_indexes', '')
        dtl = int(params.get('dtl', 14)); ret = {'result': None, 'error': None}
        try:
            ret['result'] = db['folders'].update({'_id': folder}, {'$set': {'dtl': dtl}})
        except Exception, e:
            writelog("Cleanup DB error: %s" % str(e), True)
            ret['error'] = str(e)
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(ret)]

    elif address == "/imapui/folder-remove-messages":
        folder = params.get('folder', '').replace('_indexes', '')
        dtl_remove = int(params.get('dtl', 14))
        topdate = (datetime.today() - timedelta(days = dtl_remove)).strftime('%Y-%m-%d %H:%M:%S')
        script, n, ret = open(cfg.get('imap', 'cleanup_folder_script')).read(), 0, {'result': None, 'error': None, 'cnt': 0}
        redis_autoreconnect(r)
        for key in sorted(r.keys(folder + '_*')):
            writelog("Cleanup key %s" % key)
            for data_id in r.eval(script, 1, key, topdate).split(','):
                if data_id:
                    try:
                        db[folder].remove({'_id': ObjectId(data_id)}); n += 1
                    except Exception, e:
                        writelog("Cleanup DB error:" % str(e), True)
                        ret['error'] = str(e)
        try:
            ret['result'] = db['folders'].remove({'_id': folder, 'cmpldate': {'$lt': topdate}})
        except Exception, e:
            writelog("Cleanup DB error: %s" % str(e), True)
            ret['error2'] = str(e)
        ret['cnt'] = n
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(ret)]

    elif address == "/imapui/search-folders":
        folders, keys_and_args, script, subset = defaultdict(int), [], open(cfg.get('imap', 'search_folders_script')).read(), params.get('subset', 'all')
        keys_and_args.append(params.get('cnt', '0'))
        keys_and_args.append(params.get('cond', 'or'))
        for key in params.keys():
            if key == 'cnt' or key == 'cond' or key == 'subset': continue
            par_val = "".join(map(lambda c: c if ord(c) < 256 else "\\u%04x" % ord(c), unicode(params[key], 'utf-8', 'ignore')))
            keys_and_args.append(key); keys_and_args.append(par_val)
        redis_autoreconnect(r)
        for key in sorted(r.keys()):
            if key == 'info' or key == 'blocks' or key.startswith('_'): continue
            m = re.search(r'(\w+)_\d+', key)
            if not m or not m.group(1):
                writelog("Redis DB error: unable to determine folder name for block '%s'" % key)
                continue
            folder = m.group(1)
            if subset == 'spambutton' and folder.startswith('so_wm_') or subset == 'whitemail' and folder.startswith('so_sb_') or folders[folder] > 0: continue
            for i in range(RETRY_COUNT):
                try:
                    folders[folder] += r.eval(script, 1, key, *keys_and_args); break
                except Exception, e:
                    writelog("Redis DB error: %s" % str(e), True)
                    continue
            if folders[folder] > 0:
                writelog('Key: %s, Count: %s' % (key, folders[folder]))
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(map(lambda item: item[0], filter(lambda item: item[1] > 0, folders.items())))]

    elif address == "/imapui/compldlv2yt":
        folder, ids = params.get('folder', '').replace('_indexes', ''), params.get('ids', '').split(',')
        #compldlv_yt_log = writeLog(COMPLDLV_YT_LOG, prefix = "tskv\ttskv_format=mail-so-compldlv-log\t")
        ret, cnt, obj = {'error': [], 'cnt': 0}, 0, {}
        for data_id in ids:
            if data_id:
                try:
                    obj = db[folder].find_one({'_id': ObjectId(data_id)})
                except Exception, e:
                    writelog("compldlv2yt: TokuMX DB error: %s" % str(e), True)
                    ret['error'].append(str(e))
            else: continue
            if obj and 'sent2yt' in obj and obj['sent2yt']:
                writelog("Complaint %s always in YT" % data_id)
                continue
            msg, tskv, s1, s2 = email.message_from_string(obj.get("data", "") if obj else ""), '', '', ''
            for part in msg.walk():
                if part.get_content_type() != 'text/html': continue
                msgpart, msgtime = part.get_payload(decode = True), get_msg_timestamp(msg['date'])
                cmpl, uids = {'rcp_to_count': 0, 'rcpt': '', 'date': ''}, []
                if re.search(r'(?mi)^<b>mess:</b> (.*)$', msgpart):
                    s1, s2 = '<b>', '</b>'
                else:
                    msgid, queueid, route = '', msg['x-yandex-queueid'], msg['X-Yandex-Route'].split()[0]
                    for m in re.findall(r'\bid=([^\"\'<>]+)', msgpart):
                        msgid = m
                    dlvlog = get_dlvlog(queueid, msgid, route, msgtime)
                    if dlvlog: msgpart = dlvlog
                    else: break
                tskv += "unixtime=%d" % msgtime
                m = re.search(r'(?mi)^%syaml:%s (\S+)\s+(\d+)' % (s1, s2), msgpart)
                for (key, v) in re.findall("(?mi)^%s([\w-]+)\s*:%s (.*?)(?:<br>)?$" % (s1, s2), msgpart):
                    if key == 'log' or key == 'clog' or key == 'cmpl': continue
                    v = re.sub(r'<([a-z]+) [^<>]*?>([^<>]*)</\1>', r'\2', v)
                    v = re.sub(r'&lt;', r'<', v); v = re.sub(r'&gt;', r'>', v)
                    cmpl[key.lower()] = v
                cmpl['rcpt_active'] = cmpl['rcpt_zones'] = rcpt = ''
                for (suid, uid, c) in re.findall(" id=(\d+) uid=(\d+) country=([a-z]+)", cmpl['rcpt']):
                    cmpl['rcp_to_count'] += 1; uids.append(uid)
                    rcpt += (';' if rcpt else '') + suid
                    cmpl['rcpt_zones'] += (';' if cmpl['rcpt_zones'] else '') + c
                cmpl['date'], cmpl['rcpt'] = get_msg_timestamp(cmpl['date']), rcpt
                m = re.search(r'(?mi)^%sFrom:%saddr: [^@]+@([\w\.-]+)' % (s1, s2), msgpart)
                cmpl['from'] = m.group(1) if m else ''
                m = re.search(r'(?mi)^%smfrm:%s [^@]+@([\w\.-]+)' % (s1, s2), msgpart)
                cmpl['mfrm'] = m.group(1) if m else ''
                cmpl['msid'] = cmpl.get('messageid', "")
                m = re.search(r'(?mi)^%slngg:%s ([a-z]+)' % (s1, s2), msgpart)
                cmpl['lngg'] = m.group(1) if m else ''
                m = re.search(r'(?mi)^%srcvd:%s (source ip = .+?)(?:<br>)?$' % (s1, s2), msgpart)
                cmpl['rcvd'] = m.group(1) if m else ''
                m = re.search(r'(?mi)^%slog :%s active at (.*?)(?:<br>)?$' % (s1, s2), msgpart)
                if m:
                    d0 = int(datetime.today().strftime("%Y%m%d"))
                    for d in m.group(1).split('; '):
                        cmpl['rcpt_active'] += (';' if cmpl['rcpt_active'] else '') + "%d" % (d0 - int(d))
                else: del cmpl['rcpt_active']
                cmpl['yaml'] = re.sub(r'(\S+)\s+(\d+)', r'\1 \2', cmpl.get('yaml', ""))
                cmpl['spam'] = 'no' if cmpl['spam'] == 'yes' else 'yes'
                m = re.search(r'(?mi)^%slog :%s cl (.+?)(?:<br>)?$' % (s1, s2), msgpart)
                if m: cmpl['logcl'] = m.group(1)
                rules, rulesList = '', cmpl['r_sp'].split(',')
                rulesList.extend(cmpl['r_nl'].split(','))
                rulesList.extend(cmpl['r_dl'].split(','))
                for rule_info in rulesList:
                    m = re.match(r'(\w+)', rule_info.strip())
                    if m:
                        rules += (';' if rules else '') + m.group(1)
                cmpl['r_sp'], cmpl['r_cancel'] = rules, ""
                m = re.search(r'(?mi)^%slog :%s Cancel: (.+?)(?:<br>)?$' % (s1, s2), msgpart)
                if m:
                    rules = m.group(1).split()
                    if len(rules) > 0: cmpl['r_cancel'] = ";".join(rules)
                for key in ['rcp_to_count', 'mfrm', 'iy-geozone', 'x-yandex-queueid', 'x-yandex-authentication-results', 'x-yandex-pop-server', 'x-original-size', 'msid', 'from', 'date', 'xmlr',
                            'subj', 'lngg', 'psnd', 'rcpt', 'rcvd', 'reply-to', 'rcpt_active', 'rcpt_zones', 'sndr', 'sdmn', 'logcl', 'r_cancel', 'yaml', 'spam', 'r_sp']:
                    if key in cmpl:
                        tskv += "\t%s=%s" % (key, cmpl[key])
                writelog(tskv, False, COMPLDLV_YT_LOG, "tskv\ttskv_format=mail-so-compldlv-log\t", False)
                ret['cnt'] += 1
                break
            try:
                db[folder].update_one({'_id': ObjectId(data_id)}, {'$set': {'sent2yt': 1}})
            except Exception, e:
                writelog("compldlv2yt: TokuMX DB error: %s" % str(e), True)
                ret['error'].append(str(e))
            msg["IY-Expert-Complaint"] = '1'
            res = sp_daemon_check(msg['X-Yandex-Route'].split()[0], msg.as_string())
            if res != "OK":
                writelog("SP-Daemon error: '%s'" % res)
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(ret)]

    else:
        s, sm = '', []
        for h, v in env.items():
            if re.match(r'[A-Z_]+', h):
                s += "%s: %s\n" % (h, v)
            else: sm.append(h)
        start_response("200 OK", [("Content-type", "text/plain")])
        return ["Env: %sOther keys: %s\nAddress: %s\n" % (s, ', '.join(sm), address)]

    #start_response("200 OK", [])
    #return [""]
