#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, re
from mimetypes import guess_all_extensions

MRC_FILE = 'WORKING_DIR/SO/Mail/so-quarantine-utf8.mrc'

class MimeTypesIcons:
    def __init__(self):
        self.MIMETYPES = {}
        self.EXTS = {}
        self.initMimeTypes()

    def initMimeTypes(self):
        s = open(MRC_FILE).read()
        s = re.search("<Icons>(.*)</Icons>", s, re.S | re.I).group(1)
        for line in s.split():
            m = re.search("^(\S+?);\[(\d+)x(\d+)\](\S+)$", line)
            if not m: continue
            ct = m.group(1)
            self.MIMETYPES[ct] = {
                'w':    int(m.group(2)),
                'h':    int(m.group(3)),
                'path': m.group(4),
                'ext':  'generic'
            }
            m = re.search(".*\/file_(\w+)\.[a-z]+$", self.MIMETYPES[ct]['path'])
            if m:
                self.MIMETYPES[ct]['ext'] = m.group(1)
                self.EXTS[m.group(1)] = ct

    def get(self, t):
        if t in self.MIMETYPES: return self.MIMETYPES[t]
        else:
            for ext in guess_all_extensions(t):
                if ext[1:] in self.EXTS:
                    return self.MIMETYPES[self.EXTS[ext[1:]]]
            return self.MIMETYPES['*/*']
