#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys, cgi, re, json, subprocess
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import Rules, pymongo, urllib2, time, uwsgi
from collections import defaultdict
from urllib import unquote, urlopen
from bson.objectid import ObjectId
from datetime import datetime, timedelta, date
from so_ml_ui import render_ml_ui
import yt.wrapper as ytw
from so_ml_lib import *

def getCurDict(route='in'):
    cur_dict = {}
    try:
        for rec in ytw.read_table(RULES['yt_dict_%s' % route], format=ytw.JsonFormat(), raw=False):
            cur_dict[rec['rule']] = rec['num']
    except ytw.errors.YtError, e:
        writelog("YT error: %s" % str(e), True)
    return cur_dict

def uploadDict(environ, params):
    if environ['wsgi.input'] and environ['REQUEST_METHOD'] == 'POST':
        route = params['route'][0] if 'route' in params else 'in'
        cur_dict, txt, act_dict = getCurDict(route), '', {}
        max_rule_number = len(cur_dict.keys())
        n0 = max_rule_number
        for line in environ['wsgi.input']:
            if not line: break
            num, rule, flag = line.split("\t")
            if int(flag):
                if not rule in cur_dict:
                    max_rule_number += 1
                    cur_dict[rule] = max_rule_number
                act_dict[rule] = 1
        slovar_list = sorted(map(lambda k: {"num": cur_dict[k], "rule": k, "act": 1 if k in act_dict else 0}, cur_dict),
                             key = lambda el: "%10d%s" % (el['num'], el['rule']))
        for item in slovar_list:
            txt += "num: %d, rule: %s\n" % (item['num'], item['rule'])
        txt = "Rules: %s\nn0: %d\nn1: %d\n" % (txt, n0, max_rule_number)
        yt_out_file, yt_cur_dict = RULES['yt_dict_%s' % route] + datetime.now().strftime("rules_dict_{0}_%Y_%m_%d".format(route)), RULES['yt_dict_%s' % route] + "_cur"
        try:
            ytw.write_table(yt_out_file, sorted(slovar_list), format=ytw.YsonFormat(), raw=False)
            if ytw.exists(yt_cur_dict):
                ytw.remove(yt_cur_dict)
            ytw.cypress_commands.copy(yt_out_file, yt_cur_dict)
        except ytw.errors.YtError, e:
            txt = "YT error: %s\n" % str(e)
            writelog(txt, True)
    return txt

def collectRules(route='in'):
    txt = Rules.updateRulesRepo()
    if txt:
        writelog(txt); txt = ''
    cur_dict, act_dict = getCurDict(route), {}
    try:
        max_rule_number, txt = len(cur_dict.keys()), ''
        for rule in Rules.getAtomRules(route):
            if not rule in cur_dict:
                max_rule_number += 1
                cur_dict[rule] = max_rule_number
            act_dict[rule] = 1
        for item in sorted(map(lambda k: {"num": cur_dict[k], "rule": k, "act": 1 if k in act_dict else 0}, cur_dict),
                           key = lambda el: "%10d%s" % (el['num'], el['rule'])):
            txt += "%d\t%s\t%d\n" % (item['num'], item['rule'], item['act'])
    except Exception, e:
        writelog("collectRules error: %s." % str(e), True)
    return str(txt)

def collectRules2YT(route='in'):
    txt = Rules.updateRulesRepo()
    if txt:
        writelog(txt); txt = ''
    cur_dict, act_dict = getCurDict(route), {}
    n0 = max_rule_number = len(cur_dict.keys())
    for rule in Rules.getAtomRules(route):
        if not rule in cur_dict:
            max_rule_number += 1
            cur_dict[rule] = max_rule_number
        act_dict[rule] = 1
    yt_out_file, txt = datetime.now().strftime("rules_dict_{0}_%Y_%m_%d".format(route)), ''
    slovar_list = sorted(map(lambda k: {"num": cur_dict[k], "rule": k, "act": 1 if k in act_dict else 0}, cur_dict),
                         key = lambda el: "%10d%s" % (el['num'], el['rule']))
    for item in slovar_list:
        txt += "num: %d, rule: %s\n" % (item['num'], item['rule'])
    txt = "Rules: %s\nn0: %d\nn1: %d\n" % (txt, n0, max_rule_number)
    try:
        if ytw.exists(RULES['yt_dict_%s' % route]):
            ytw.remove(RULES['yt_dict_%s' % route])
        ytw.write_table(RULES['yt_dict_%s' % route], sorted(slovar_list), format = ytw.YsonFormat(), raw = False)
    except ytw.errors.YtError, e:
        txt = "YT error: %s\n" % str(e)
        writelog(txt, True)
    return str(txt)

def setMLstatus(status, workflow_id='', workflow_instance_id='', route='in', db=None):
    prod, q = {}, {'route': route}
    if workflow_id:
        q['workflow_id'] = workflow_id
    if workflow_instance_id:
        q['workflow_instance_id'] = workflow_instance_id
    try:
        if not db:
            db = getDB(MONGO)
        prod = db['prod_history'].find_one_and_update(q, {'$set': {'status': status}}, sort = [('datetime', pymongo.DESCENDING)])
    except Exception, e:
        writelog("setMLstatus DB error \"%s\" for record: %s" % (str(e), str(model)), True)
    return prod

def saveFile(params, environ):
    file_name = params['file'][0] if 'file' in params and params['file'] else 'matrixnet.info'
    file_content = environ['wsgi.input'].read(int(environ['CONTENT_LENGTH']))
    print(file_content, file = open(MODELS['folder'] + file_name, 'w'))
    return ""

def saveModelStatus(params, environ):
    formula_id = int(params['formula_id'][0]) if 'formula_id' in params else 0
    workflow_id = params['workflow_id'][0] if 'workflow_id' in params else ''
    workflow_instance_id = params['workflow_instance_id'][0] if 'workflow_instance_id' in params else ''
    status = params['status'][0] if 'status' in params else ''
    route = params['route'][0] if 'route' in params else 'in'
    if status:
        setModelStatus(status, workflow_id, workflow_instance_id, formula_id, route)
        if status != 'pool_gathering' and status != 'models_learning' and status != 'models_params_calc' and status != 'models_offline_test':
            setMLstatus(status, workflow_id, workflow_instance_id, route)

def getFormulaFileFromFML(formula_id, file_name):
    return doRequest("https://fml.yandex-team.ru/download/computed/formula?id=%s&file=%s" % (formula_id, file_name), 'getFormulaFileFromFML')

def saveModelParams(params, prefix='', db=None):
    cond, pars = {}, {}
    if 'formula_id' in params:
        cond['formula_id'] = int(params['formula_id'])
    for p in ['workflow_id', 'workflow_instance_id']:
        if p in params:
            cond[p] = params[p]
    if len(cond.keys()) < 1:
        return
    try:
        for (k, v) in params.iteritems():
            if k in cond:
                continue
            if re.match(r'^-?\d+$', str(v)):
                pars[prefix + k] = int(v)
            elif re.match(r'^-?\d+\.\d+$', str(v)):
                pars[prefix + k] = float(v)
            else:
                pars[prefix + k] = unquote(v)
        if not db:
            db = getDB(MONGO)
        if 'workflow_id' in cond:
            r = json.loads(requestNirvana('getWorkflowMetaData', {'workflowId': cond['workflow_id']}))
            if 'error' in r:
                writelog('getWorkflowMetaData error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
            else:
                r = json.loads(requestNirvana('getExecutionState', {'workflowId': cond['workflow_id'], 'workflowInstanceId': r['result']['instanceId']}))
                if 'error' in r:
                    writelog('saveModelParams requestNirvana error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
                elif 'result' in r:
                    pars['start_time'] = ' '.join(r['result']['started'][:19].split('T'))
        doc = db['models'].find_one_and_update(cond, {'$set': pars}, upsert = True)
    except Exception, e:
        writelog("saveModelParams DB error: %s. Cond: %s. Params: %s." % (str(e), str(cond), str(pars)), True)

def saveWorkflowIntermidiateYTTables(formula_id, workflow_id, workflow_instance_id, source_op):
    tables, local_ids = {}, {}
    if source_op == 'calc_threshold' or not source_op:
        local_ids.update({
            'operation-1477573675683-12':  'complaints',
            'operation-1477573689368-19':  'dlvlog_basic',
            'operation-1479400835839-111': 'dlvlog_test',
            'operation-1509716447941-180': 'reduced_dlvlog_basic',
            'operation-1509716682650-193': 'reduced_dlvlog_test',
            'operation-1509716844488-206': 'truncated_dlvlog_basic',
            'operation-1509717308973-216': 'truncated_dlvlog_forvw',
            'operation-1509750503980-399': 'truncated_dlvlog_test',
            'operation-1477573667429-5':   'rules',
            'operation-1477573711470-26':  'pool_basic',
            'operation-1479401150771-122': 'pool_test',
            'operation-1479658503193-89':  'pool_fml',
            'operation-1509717470951-227': 'vw_model'
        })
    if source_op == 'get_statistics' or not source_op:
        local_ids.update({
            'operation-1479408208302-141': 'pool_formula_test'
        })
    data = json.loads(requestNirvana('getBlockResults', {'workflowId': workflow_id, 'workflowInstanceId': workflow_instance_id, 'blocks': map(lambda c: {'code': c}, local_ids.keys())}))
    if 'error' in data:
        writelog('getSettings error: code=%s, message="%s", data="%s"' % (data['error']['code'], data['error']['message'], data['error']['data'] if 'data' in data['error'] else ''))
        return []
    db = getDB(MONGO)
    writelog("saveWorkflowIntermidiateYTTables: formula_id=%s, workflow_id=%s, source_op=%s, data=%s" % (formula_id, workflow_id, source_op, json.dumps(data)))
    for block in data['result']:
        for result in block['results']:
            try:
                if 'storagePath' in result and result['storagePath']:
                    result_data = ''
                    try:
                        f = urllib2.urlopen(urllib2.Request(url = result['storagePath'], headers = {'Content-Type': 'application/json; charset=utf-8'}))
                        if f:
                            if f.getcode() == 200:
                                result_data = f.read()
                            else:
                                writelog('Error retrieving Nirvana operation result: code: %s, info: %s' % (f.getcode(), f.info()))
                        else:
                            writelog('Storage data is empty for block "%s" !' % block['blockCode'])
                    except Exception, e:
                        writelog('saveWorkflowIntermidiateYTTables storagePath HTTP Request failed: %s.' % str(e), True)
                    path_data = {}
                    try:
                        path_data = json.loads(result_data)
                    except Exception, e:
                        writelog('saveWorkflowIntermidiateYTTables storagePath parsing JSON failed: %s. Data: %s' % (str(e), path_data), True)
                        path_data = {}
                    k = 'table' if 'table' in path_data and ytw.exists(path_data['table']) else ('path' if 'path' in path_data and ytw.exists(path_data['path']) else '')
                    if k:
                        t = local_ids[block['blockCode']]
                        if t not in tables:
                            tables[t] = []
                        tables[t].append(path_data[k])
                        db['intermidiate_tables'].insert_one({
                            'formula_id':           int(formula_id) if str(formula_id).isdigit() else None,
                            'workflow_id':          workflow_id,
                            'workflow_instance_id': workflow_instance_id,
                            'local_id':             block['blockCode'],
                            'name':                 result['endpoint'],
                            'path':                 path_data[k],
                            'op_type':              t
                        })
                    else:
                        writelog("saveWorkflowIntermidiateYTTables warning: Unable to extract table's path from Nirvana request data: %s !" % str(path_data))
                        dirname = "%s%s/%s" % (MODELS['folder'], formula_id, workflow_instance_id)
                        if not os.path.exists(dirname):
                            os.makedirs(dirname, 0755)
                        with open("%s%s/%s/%s" % (MODELS['folder'], formula_id, workflow_instance_id, result['endpoint']), 'wb') as f_out:
                            f_out.write(result_data)
                else:
                    writelog("saveWorkflowIntermidiateYTTables error: Unable to find 'storagePath' key in Nirvana request data: %s !" % result)
            except Exception, e:
                writelog("saveWorkflowIntermidiateYTTables error '%s' for block: %s." % (str(e), result), True)
    return tables

def saveFormulaInfo(params, environ):
    try:
        formula_id = params['formula_id'][0]
        dirname = MODELS['folder'] + formula_id
        if 'workflow_instance_id' in params and params['workflow_instance_id'][0]:
            dirname += "/%s" % params['workflow_instance_id'][0]
        try:
            pars = {}
            for p in params:
                pars[p] = unquote(params[p][0])
            if os.path.exists(dirname) and not os.path.isdir(dirname):
                os.remove(dirname)
            if not os.path.exists(dirname):
                os.makedirs(dirname, 0755)
            f = open(dirname + '/model.params', 'w')
            for p in pars:
                print("%s=%s" % (p.upper(), pars[p]), file = f)
            f.close()
        except Exception, e:
            writelog("saveFormulaInfo failed: %s" % str(e), True)
        saveModelParams(pars)
        for formula_file in ['matrixnet.info']:         # we has got rid of dependances from *.inc files
            print(getFormulaFileFromFML(formula_id, formula_file), file = open(dirname + '/' + formula_file, 'w'))
        if params['rules_dict'] and ytw.exists(params['rules_dict'][0]):
            f = open(dirname + '/rules.txt', 'w')
            for r in ytw.read_table(params['rules_dict'][0], format=ytw.JsonFormat(), raw=False):
                print("%d\t%s\t%d" % (r['num'], r['rule'], r['act']), file=f)
            f.close()
    except Exception, e:
        writelog('saveFormulaInfo failed: %s.' % str(e), True)
    return ""

def saveAcceptanceMetricsInfo(params, environ):
    try:
        dirname = MODELS['folder'] + params['formula_id'][0]
        if 'workflow_instance_id' in params and params['workflow_instance_id'][0]:
            dirname += "/%s" % params['workflow_instance_id'][0]
        try:
            pars = {}
            for p in params:
                pars[p] = params[p][0]
            if os.path.exists(dirname) and not os.path.isdir(dirname):
                os.remove(dirname)
            if not os.path.exists(dirname):
                os.makedirs(dirname, 0755)
            f = open(dirname + '/acceptance_metrics.params', 'w')
            for p in pars:
                print("%s=%s" % (p.upper(), pars[p]), file=f)
            f.close()
        except Exception, e:
            writelog("saveAcceptanceMetricsInfo saving to file failed: %s" % str(e), True)
        saveModelParams(pars, 'am_')
        if getSetting('offline_test') and 'formula_id' in params:
            saveModelParams({'cross_compared_total': int(getSetting('offline_test_deepness')), 'cross_compared_count': 0, 'formula_id': int(params['formula_id'][0])})
    except Exception, e:
        writelog('saveAcceptanceMetricsInfo failed: %s.' % str(e), True)
    return ""

def sendNotificationEmail(msg, title, subj = 'Автоматическое уведомление', to_email = 'so-report@yandex-team.ru', text_type = 'html'):
    txt = "Content-Type: text/%s; charset='utf-8'\nMIME-Version: 1.0\nContent-Transfer-Encoding: 8bit\nFrom: Robot Mailspam <robot-mailspam@yandex-team.ru>\nTo: %s\nSubject: %s\n\n" % (text_type, to_email, subj)
    if text_type == 'html':
        txt += "<html>\n<head>\n<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />\n</head>\n<body>\n";
        txt += "<div><p>%s<p></div>\n%s\n</body>\n</html>" % (title, msg)
    else:
        txt += '%s\n\n%s' % (title, msg)
    try:
        sendEmail(txt, toaddr = to_email)
    except Exception, e:
        writelog("sendNotificationEmail error: %s. Message:\n%s." % (str(e), txt), True)

def fillFormulaParams(format_str, prefix, suffix, pars_kind, formula_id, workflow_instance_id='', route='in'):
    txt, pars = prefix, {}
    try:
        db = getDB(MONGO)
        cond = {'formula_id': int(formula_id), 'route': route}
        if workflow_instance_id:
            cond['workflow_instance_id'] = workflow_instance_id
        model = db['models'].find_one(cond, sort = [('$natural', pymongo.DESCENDING)])
        for (k, v) in model.iteritems():
            if k == '_id':
                continue
            if pars_kind == 'acceptance_metrics':
                if k.startswith('am_'):
                    pars[k] = v
            else:
                if not k.startswith('am_'):
                    pars[k] = v
    except Exception, e:
        writelog("fillFormulaParams DB error: %s.\n" % str(e), True)
    for k in sorted(pars.keys()):
        if k == "rules_dict":
            txt += format_str.format('RULES_DICT', '<a href="https://yt.yandex-team.ru/hahn/#page=navigation&path={0}">{0}</a>'.format(pars[k]))
            txt += format_str.format('FEATURE_FOLDER', '<a href="https://yt.yandex-team.ru/hahn/#page=navigation&path={0}">{0}</a>'.format(re.sub(r'/\w+$', '', pars[k])))
        else:
            txt += format_str.format(k.upper(), pars[k])
    txt += suffix
    return txt

def sendInfoEmail(params, environ):
    if 'notify_users' not in params or not params['notify_users'][0]:
        return ""
    txt = ''
    route = params['route'][0] if 'route' in params else 'in'
    pool_type = 'тестовый пул' if params['pool_type'][0] == '2' else ('тестовый пул с наложенными резолюциями по формуле' if params['pool_type'][0] == '3' else 'основной пул')
    title = "Посчитался <a href='https://yt.yandex-team.ru/hahn/#page=navigation&path=%s'>%s и статистика по нему</a>." % (params['yt_result_folder'][0], pool_type)
    if params['pool_type'][0] == '3' and 'formula_id' in params:
        workflow_instance_id = params['workflow_instance_id'][0] if 'workflow_instance_id' in params else ''
        txt += fillFormulaParams("<li>{0}&nbsp;=&nbsp;{1}</li>", "<div><p>Параметры порога:</p><ul>\n", '</ul></div>', 'model_params', params['formula_id'][0], workflow_instance_id, route)
        txt += fillFormulaParams("<li>{0}&nbsp;=&nbsp;{1}</li>", "<div><p>Параметры приёмочной метрики:</p><ul>\n", '</ul></div>', 'acceptance_metrics', params['formula_id'][0], workflow_instance_id, route)
    sendNotificationEmail(txt, title, '[%s почта] Посчитан %s и статистика к нему' % ('Исходящая' if route == 'out' else 'Входящая', pool_type, params['notify_users'][0]))
    return ""

def getPoolFilterItems(route = 'in'):
    t = Rules.updateRulesRepo()
    if t:
        writelog(t); t = ''
    filter_items = {'ips': {'spam': [], 'ham': []}, 'rules': {'spam': [], 'ham': []}, 'rdns': {'spam': [], 'ham': []}, 'from_domain': {'spam': [], 'ham': []}}
    for file_name in os.listdir(RULES['mn_folder_%s' % route]):
        m = re.match(r'(\w+)\.no((?:sp|h)am)$', file_name)
        if not m: continue
        #print("File: %s" % file_name)
        d, dd, dc = '', 1, date.today()
        f = open(RULES['mn_folder_%s' % route] + file_name, 'r')
        for line in f:
            if not line or re.match(r'^\s*#', line): break
            sp = line.split()
            if not d or d and len(sp) > 1 and d < sp[1]:
                d, dd = sp[1] if len(sp) > 1 else dc.isoformat(), int(sp[2]) if len(sp) > 2 else dd
            if m.group(1) in filter_items and (dc - timedelta(days = dd)).isoformat() <= d:
                try:
                    filter_items[m.group(1)][m.group(2)].append(sp[0])
                except:
                    pass
    writelog("FilterItems: %s" % json.dumps(filter_items))
    return json.dumps(filter_items)

def getDomainsFilterItems(route = 'in'):
    t = Rules.updateRulesRepo()
    if t:
        writelog(t); t = ''
    domains = {'mn': {}, 'vw': {}}
    f = open(RULES['mn_folder_%s' % route] + '/domains.limit', 'r')
    for line in f:
        if not line or re.match(r'^\s*#', line): continue
        sp = line.split()
        try:
            mn = int(sp[1])
        except:
            mn = -1
        try:
            vw = int(sp[2])
        except:
            vw = -1
        if mn > -1:
            domains['mn'][sp[0]] = mn
        if vw > -1:
            domains['vw'][sp[0]] = vw
    writelog("DomainsItems: %s" % json.dumps(domains))
    return json.dumps(domains)

def saveAppliedPoolParams(params, ytw):
    formula1 = params['formula1'][0] if 'formula1' in params else ''
    formula2 = params['formula2'][0] if 'formula2' in params else ''
    status = params['status'][0] if 'status' in params else ''
    route = params['route'][0] if 'route' in params else 'in'
    if not (formula1.isdigit() and formula2.isdigit() and status):
        return {"error": "One or more query parameters is absent or empty!"}
    pool_params = {}
    for p in params:
        if p in ['formula1', 'formula2', 'status', 'route']: continue
        pool_params[p] = params[p][0]
    return saveAppliedPoolState(formula1, formula2, status, pool_params, route, ytw)

def calcCrossComparison(params):
    formula_id = params['formula_id'][0] if 'formula_id' in params else ''
    if not formula_id.isdigit():
        return {"error": "Main formula_id parameter is absent or empty!"}
    workflow_id = params['workflow_id'][0] if 'workflow_id' in params else ''
    workflow_instance_id = params['workflow_instance_id'][0] if 'workflow_instance_id' in params else ''
    deepness = int(params['deepness'][0]) if 'deepness' in params and str(params['deepness'][0]).isdigit() else 4
    route = params['route'][0] if 'route' in params else 'in'
    try:
        compared_models, i0 = getComparedModels(deepness = deepness, route = route), 0
        if compared_models[0]['formula_id'] == formula_id: i0 = 1
        for i in range(i0, deepness):
            startComparingModels(formula_id, str(compared_models[i]['formula_id']), formula_id, route)
            startComparingModels(str(compared_models[i]['formula_id']), formula_id, formula_id, route)
    except Exception, e:
        writelog("calcCrossComparison error: %s. FormulaID: %s, Deepness: %s.\n" % (str(e), formula_id, deepness), True)

def sendModelToProdBranch(formula_id, threshold, prod_number, branch, route = 'in', db = None):
    if not formula_id:
        writelog('sendModelToProdBranch error: formula_id must be specified!')
        return ""
    n, model = prod_number - 1, getModel(str(formula_id), route = route, db = db)
    prod_models = getProdModelsCurrent()
    prod_models[n]['formula'] = formula_id
    prod_models[n]['datetime'] = time.strftime("%Y-%m-%d %H:%M:%S")
    prod_models[n]['threshold'] = threshold
    prod_models[n]['comment'] = model['name']
    prod_models[n]['info'] = ''
    del prod_models[n]['name']
    setModelStatus('building_package_%s' % branch, formula_id = formula_id, route = route, db = db)
    writelog("Sending model %s in slot %s to branch '%s'" % (formula_id, prod_number, branch))
    return sendModelsToProd(prod_models, branch, formula_id, db)

def test_signal_30(num):
    #print >>sys.stderr, "Signal 30 has been called! (%s)" % num
    writelog("Signal 30 has been called!")

def getAggregationResult(cur):
    rec = None
    try:
        rec = cur.next()
    except:
        pass
    if rec and isinstance(rec, dict):
        return rec
    return {}

def getModelsRelationsStat():
    g = {'$group': {'_id': '$rule', 'total': {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R2', 0]}, {'$ifNull': ['$R4', 0]}, {'$ifNull': ['$R8', 0]}, {'$ifNull': ['$R127', 0]}, {'$ifNull': ['$R256', 0]}]}}}}
    mt = {'$gte': int(time.mktime((datetime.now() - timedelta(hours = 1.5)).timetuple())), '$lte': int(time.mktime((datetime.now() - timedelta(hours = 0.5)).timetuple()))}
    try:
        db = getDB(RULES)
        for rule in [['MN_COMP_A0B1', 'MN_HAM5', 0.2], ['MN_COMP_A1B0', 'MN_SPAM5', 0.3], ['MN_COMP_B0A1', 'MN_HAM6', 0.15], ['MN_COMP_B1A0', 'MN_SPAM6', 0.3]]:
            d1 = getAggregationResult(db['detailed_Rules_In'].aggregate([{'$match': {'rule': rule[0], 'time': mt}}, g]))
            if not ('total' in d1 and d1['total'] > 0):
                writelog("getModelsRelationsStat error: Unable retrieve statistics for rule %s" % rule[0])
                return False
            d2 = getAggregationResult(db['detailed_Rules_In'].aggregate([{'$match': {'rule': rule[1], 'time': mt}}, g]))
            if not ('total' in d2 and d2['total'] > 0):
                writelog("getModelsRelationsStat error: Unable retrieve statistics for rule %s" % rule[1])
                return False
            if d1['total'] / d2['total'] > rule[2]:
                writelog("getModelsRelationsStat error: Relation of the statistics of rules %s / %s greater than %s" % (rule[0], rule[1], rule[2]))
                return False
    except Exception, e:
        writelog("getModelsRelationsStat DB error: %s.\n" % str(e), True)
    return True

def getLastModel():
    doc = {}
    try:
        db = getDB(MONGO)
        doc = db['models'].find_one({}, sort = [('$natural', pymongo.DESCENDING)])
    except Exception, e:
        writelog("getLastModel DB error: %s.\n" % str(e), True)
    return (int(doc['formula_id']) if 'formula_id' in doc else 0)

def revertModel():
    prod_models = getProdModelsCurrent()
    writelog("Revert model %s to model %s" % (prod_models[MODELS['testing_slot'] - 1]['formula'], prod_models[MODELS['current_slot'] - 1]['formula']))
    setMLstatus('model_revert')
    setModelStatus('model_rejected', formula_id = prod_models[MODELS['testing_slot'] - 1]['formula'])
    model = prod_models[MODELS['current_slot'] - 1]
    sendModelToProdBranch(model['formula'], model['threshold'], MODELS['testing_slot'], 'stable')

def getCurrentModels():
    doc = {}
    try:
        db = getDB(MONGO)
        doc = db['prod_history'].find_one({}, sort = [('datetime', pymongo.DESCENDING)])
    except Exception, e:
        writelog("getCurrentModels DB error: %s.\n" % str(e), True)
    return doc.get('formulas', [])

def getModelLayoutAvailableTime(delay = 0):
    cfg, s = {}, 0
    try:
        db = getDB(MONGO)
        cfg = db['settings'].find_one({'_id': 1})
    except Exception, e:
        writelog("ifModelLayoutAvailable DB error: %s.\n" % str(e), True)
    try:
        wd, t = (datetime.now() + timedelta(seconds = delay)).strftime("%a %H:%M").split()
        if wd in cfg and not cfg[wd] or "limit_t1" in cfg and t < cfg["limit_t1"] or "limit_t2" in cfg and t > cfg["limit_t2"]:
            h, m = map(int, t.split(':'))
            wdays, s, h2, m2 = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'], 0, h, m
            i0 = wdays.index(wd)
            if wd in cfg and (not cfg[wd] or cfg[wd] and "limit_t2" in cfg and t > cfg["limit_t2"]):
                for i in range(i0 + 1, 7):
                    if cfg[wdays[i]]: break
                else:
                    for i in range(i0):
                        if cfg[wdays[i]]: break
                wd = i if i < 7 else i0
            else:
                wd = i0
            if wd >= i0:
                wd -= i0
            else:
                wd += 7 - i0
            s += wd * 86400
            if s > 0:
                h, m = map(int, datetime.now().strftime("%H:%M").split(':'))
                if "limit_t1" in cfg or "limit_t2" in cfg and t > cfg["limit_t2"]:
                    h2, m2 = map(int, cfg["limit_t1"].split(':'))
                else:
                    h2, m2 = h, m
            elif "limit_t1" in cfg and t < cfg["limit_t1"]:
                h2, m2 = map(int, cfg["limit_t1"].split(':'))
            elif "limit_t2" in cfg and t > cfg["limit_t2"]:
                h2, m2 = map(int, cfg["limit_t2"].split(':'))
            t1, t2 = h * 60 + m, h2 * 60 + m2
            s += (t2 - t1) * 60
    except Exception, e:
        writelog("ifModelLayoutAvailable error: %s.\n" % str(e), True)
    writelog("Step2 delayed on %s seconds" % (s + delay))
    return s + delay

def startNewModelWorkflow(route = 'in'):
    data = json.loads(requestNirvana('cloneWorkflow', {'workflowId': ID['main_workflow_%s' % route], 'workflowInstanceId': ID['main_workflow_instance_%s' % route]}))
    if 'error' in data:
        s = 'checkIfModelDelivered/cloneWorkflow error: code=%s, message="%s", data="%s"' % (data['error']['code'], data['error']['message'], data['error']['data'] if 'data' in data['error'] else '')
        writelog(s)
        return s
    writelog("Cloned new main workflow ID: %s" % data['result'])
    new_workflow_id = data['result']
    data = json.loads(requestNirvana('startWorkflow', {'workflowId': new_workflow_id}))
    if 'error' in data:
        s = 'checkIfModelDelivered/startWorkflow error: code=%s, message="%s", data="%s"' % (data['error']['code'], data['error']['message'], data['error']['data'] if 'data' in data['error'] else '')
        writelog(s)
        return s
    writelog("Route: %s, startWorkflow returned (instanceId): %s" % (route, data['result']))
    setModelStatus('pool_gathering', new_workflow_id, data['result'], route = route)

def isModelDelivered():
    t = datetime.now() - timedelta(hours = 1)
    #print >>sys.stderr, "isModelDelivered time min: %s" % int(time.mktime(t.timetuple()))
    try:
        db = getDB(RULES)
        for rule in ['MN_COMP_A0B1', 'MN_COMP_A1B0', 'MN_COMP_B0A1', 'MN_COMP_B1A0']:
            data = getAggregationResult(db['detailed_Rules_In'].aggregate([{'$match': {'rule': rule, 'time': {'$gte': int(time.mktime(t.timetuple()))}}},
                                                      {'$group': {
                                                          '_id': '$rule',
                                                          'total': {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R2', 0]}, {'$ifNull': ['$R4', 0]},
                                                                    {'$ifNull': ['$R8', 0]}, {'$ifNull': ['$R127', 0]}, {'$ifNull': ['$R256', 0]}]}}
                                                      }}
                                                     ]))
            if 'total' in data and data['total'] > 0:
                return False
        return True
    except Exception, e:
        writelog("isModelDelivered DB error: %s.\n" % str(e), True)
    return True

def checkIfModelDelivered(num):
    try:
        models = getCurrentModels()
        if isModelDelivered():
            #txt = "<div><p>Этап: 8,5 ч. после выкатки новой модели и 7 ч. после назначениея ей ненулевого веса.</p><p>Запускаем сбор пула для новой модели;)</p></div>"
            #sendNotificationEmail(txt, 'Модель была успешно протестирована онлайн и выкачена в прод в качестве решающей.', 'Новая модель выкачена в прод')
            writelog("checkIfModelDelivered: Yes")
            setModelStatus('model_accepted', formula_id = models[MODELS['current_slot'] - 1])
            if getSetting('autostart_workflow') or getModelParam('autostart_workflow', formula_id = models[MODELS['current_slot'] - 1]):
                startNewModelWorkflow()
            else:
                setMLstatus('waiting')
        else:
            writelog("checkIfModelDelivered: No")
            txt = "<div><p>ВНИМАНИЕ: посмотрите, пожалуйста, на машинках демона СО - почему модель не стала работать на всех машинках.</p><p>Этап: 8,5 ч. после выкатки новой модели и 7 ч. после назначениея ей ненулевого веса.</p></div>"
            sendNotificationEmail(txt, 'Модель была выкачена в прод в качестве решающей, однако за 1 час не смогла докатиться до всех машинок.', 'Модель недовыкачена в прод')
            setMLstatus('model_is_not_delivered')
            setModelStatus('model_is_not_delivered', formula_id = models[MODELS['current_slot'] - 1])
    except Exception, e:
        writelog("checkIfModelDelivered DB error: %s.\n" % str(e), True)

def checkModelsComplaintsComparison(num):
    data, s, db = {}, 0, None
    writelog("Start Checking Models Complaints Comparison...")
    mt = {'$gte': int(time.mktime((datetime.now() - timedelta(hours = 6.5)).timetuple())), '$lte': int(time.mktime((datetime.now() - timedelta(hours = 0.5)).timetuple()))}
    try:
        db = getDB(RULES)
        for r in db['detailed_Rules_In'].find({'rule': {'$in': ['MN_AREA_ALL', 'MN_AREA_ALL_C']}, 'time': mt}):
            if r['time'] not in data:
                data[r['time']] = {'MN_AREA_ALL': {}, 'MN_AREA_ALL_C': {}}
            for c in ['R1', 'R2', 'R4', 'cmpl_spam', 'cmpl_ham']:
                data[r['time']][r['rule']][c] = 1.0 * r[c] if c in r else 0
        for t in data:
            z = (data[t]['MN_AREA_ALL_C'].get('cmpl_ham', 0) + data[t]['MN_AREA_ALL_C'].get('cmpl_spam', 0)) * (data[t]['MN_AREA_ALL'].get('R1', 0) + data[t]['MN_AREA_ALL'].get('R2', 0) + data[t]['MN_AREA_ALL'].get('R4', 0)) * 1.0
            if z > 0:
                s += (data[t]['MN_AREA_ALL'].get('cmpl_ham', 0) + data[t]['MN_AREA_ALL'].get('cmpl_spam', 0)) * (data[t]['MN_AREA_ALL_C'].get('R1', 0) + data[t]['MN_AREA_ALL_C'].get('R2', 0) + data[t]['MN_AREA_ALL_C'].get('R4', 0)) / z
        s = (s / len(data.keys())) if len(data.keys()) > 0 else 0
    except Exception, e:
        writelog("checkModelsComplaints DB error: %s.\n" % str(e), True)
    writelog("checkModelsComplaintsComparison: s = %s" % s)
    prod_models = getProdModelsCurrent()
    if s > 0.98:
        model = prod_models[MODELS['testing_slot'] - 1]
        sendModelToProdBranch(model['formula'], model['threshold'], MODELS['current_slot'], 'stable', db)
        txt = "<div><p>Основание: отклонение с текущей моделью по жалобам (отношение) k=<b>%s > 0.98</b>.</p><p>Этап: 7,5 ч. после выкатки новой модели и 6 ч. после назначениея ей ненулевого веса.</p></div>" % s
        sendNotificationEmail(txt, 'Новая модель <b>%s</b> принята в результате сравнения по жалобам.' % model['formula'], 'Новая модель принята')
    else:
        model = prod_models[MODELS['current_slot'] - 1]
        txt = "<div><p>Причина: слишком большие отклонения с текущей моделью по жалобам (отношение k=<b>%s</b>).</p><p>Этап: 7,5 ч. после выкатки новой модели и 6 ч. после назначениея ей ненулевого веса.</p></div>" % s
        sendNotificationEmail(txt, 'Новая модель <b>%s</b> не принята в результате сравнения по жалобам. Поэтому откатываемся на старую модель <b>%s</b>.' % (prod_models[MODELS['testing_slot'] - 1]['formula'], model['formula']), 'Новая модель не принята')
        revertModel()
    writelog("Go to next step: Step3.Check_done")
    uwsgi.register_signal(SIGNALS['Step3.Check_done'], "mule", checkIfModelDelivered)
    uwsgi.add_rb_timer(SIGNALS['Step3.Check_done'], TIMERS['Step3.Check_done'], 1)

def checkModelsComparison(num):
    Rules.enableProdSlotModel()
    if getModelsRelationsStat():
        writelog("Go to next step: Step2.Check_complaints")
        uwsgi.register_signal(SIGNALS['Step2.Check_complaints'], "mule", checkModelsComplaintsComparison)
        uwsgi.add_rb_timer(SIGNALS['Step2.Check_complaints'], getModelLayoutAvailableTime(TIMERS['Step2.Check_complaints']), 1)
        models = getCurrentModels()
        setMLstatus('model_online_test_with_weight')
        setModelStatus('model_online_test_with_weight', formula_id = models[MODELS['testing_slot'] - 1])
    else:
        txt = "<div><p>Причина: слишком большие отклонения с текущей моделью.</p><p>Этап: 1,5 ч. после выкатки новой модели в прод с нулевым весом.</p></div>"
        sendNotificationEmail(txt, 'Новая модель не принята.', 'Новая модель не принята')
        revertModel()

def saveConductorTicket(params):
    deploy_group = params['deploy_group'][0] if 'deploy_group' in params else ''
    if deploy_group != 'mail_sodaemon' and deploy_group != 'mail_sodaemon_prestable':
        writelog("saveConductorTicket error: deploy_group '%s' != 'mail_sodaemon'" % deploy_group)
        return
    rec_id = params['id'][0] if 'id' in params else ''
    ticket_id = params['ticket_id'][0] if 'ticket_id' in params else ''
    comment = params['comment'][0] if 'comment' in params else ''
    branch = params['branch'][0] if 'branch' in params else ''
    status = params['new_status'][0] if 'new_status' in params else ''
    if comment:
        m = re.search(r'\(([a-z0-9]+)\)', comment)
        if m:
            rec_id = m.group(1)
    if status != 'done':
        prod_models = getProdModelsCurrent()
        model = prod_models[MODELS['current_slot' if branch == 'stable' else 'testing_slot'] - 1]
        txt = "<div><p>Причина: модель <b>%s</b> не смогла выкатиться Кондуктором в ветке '<b>%s</b>'. Статус <a href='https://c.yandex-team.ru/tickets/%s'>тикета</a>: <b>%s</b>.</p></div>" % (model['formula'], branch, ticket_id, status)
        sendNotificationEmail(txt, 'Новая модель не принята.', 'Новая модель не принята')
        return
    if not (ticket_id and rec_id):
        writelog("saveConductorTicket error: wrong input params (RecordID=%s, TicketID=%s, Comment='%s')" % (rec_id, ticket_id, comment))
        return
    try:
        db = getDB(MONGO)
        prod_rec = db['prod_history'].find_one({'_id': ObjectId(rec_id)})
        if 'tickets' not in prod_rec:
            db['prod_history'].update_one({'_id': ObjectId(rec_id)}, {'$set': {'tickets': [ticket_id]}})
        else:
            db['prod_history'].update_one({'_id': ObjectId(rec_id)}, {'$addToSet': {'tickets': ticket_id}})
    except Exception, e:
        writelog("saveConductorTicket DB error: %s.\n" % str(e), True)
    if getModelParam('online_test', formula_id = prod_rec['formulas'][MODELS['testing_slot'] - 1], default = 1):
        if branch != 'stable':
            writelog("Go to next step: Step1.Check_models_diff")
            uwsgi.register_signal(SIGNALS['Step1.Check_models_diff'], "mule", checkModelsComparison)
            uwsgi.add_rb_timer(SIGNALS['Step1.Check_models_diff'], TIMERS['Step1.Check_models_diff'], 1)
            setMLstatus('model_online_test_without_weight')
            setModelStatus('model_online_test_without_weight', formula_id = prod_rec['formulas'][MODELS['testing_slot'] - 1])
    else:
        setMLstatus('waiting')
        setModelStatus('model_accepted', formula_id = prod_rec['formulas'][MODELS['testing_slot'] - 1])

def getConductorTicketStatus(ticket_id):
    data = {}
    try:
        f = urllib2.urlopen(urllib2.Request(url = "https://c.yandex-team.ru/api/v1/tickets/{0}/".format(ticket_id),
                                            headers = {'Authorization': 'OAuth %s' % OAUTH_TOKEN['conductor'], 'Accept': 'application/json', 'Content-Type': 'application/json'}))
        if f:
            data = json.loads(f.read())
        else:
            writelog('Conductor request answer is empty!')
    except urllib2.URLError, e:
        writelog("Conductor request error reason: %s.\n" % e.reason, True)
    except Exception, e:
        writelog("Conductor request exception: %s.\n" % str(e), True)
    return data['value']['status'] if 'value' in data and 'status' in data['value'] else str(data)

def getMLSettings(route):
    data = {}
    try:
        db = getDB(MONGO)
        data = db['settings'].find_one({'_id': 'general'})
        if '_id' in data:
            del data['_id']
    except Exception, e:
        writelog("getMLSettings DB error: %s.\n" % str(e), True)
    return data

def getCurrentVWmodel(db = None):
    filepath, formula_id, res = '', 0, ''
    try:
        if not db:
            db = getDB(MONGO)
        prod = db['prod_history'].find_one({}, sort = [('datetime', pymongo.DESCENDING)])
        formula_id = prod['formulas'][MODELS['current_slot'] - 1]
        model = db['models'].find_one({'formula_id': formula_id}, sort = [('start_time', pymongo.DESCENDING)])
    except Exception, e:
        writelog("sendCurrentVWmodel DB error: %s" % str(e), True)
    for filepath in [MODELS['folder'] + str(formula_id) + '/vw.bin', MODELS['folder'] + str(formula_id) + '/vw_binary_model',
                     "%s%s/%s/vw_binary_model" % (MODELS['folder'], formula_id, model.get("workflow_instance_id", '1'))]:
        if os.path.exists(filepath):
            with open(filepath, 'rb') as f:
                while True:
                    buf = f.read(65535)
                    if not buf:
                        break
                    res += buf
            break
    return res

def application(environ, start_response):
    if not hasattr(application, "init"):
        application.init = True
        loadDBCredentials(MONGO)
        loadDBCredentials(RULES)
        loadCredentials()
    params = dict(cgi.parse_qs(environ['QUERY_STRING'], keep_blank_values=True))
    query = re.sub(r'^/ml/?([\w-]+)?.*$', r'\1', environ['PATH_INFO'])

    ytw.config['proxy']['url'] = YT['proxy']
    ytw.config['token'] = YT['token']

    if query == "upload_dict":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [uploadDict(environ, params)]

    elif query == "update_rules_repo":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [Rules.updateRulesRepo()]

    elif query == "collect_dict":
        start_response("200 OK", [("Content-type", "text/plain")])
        route = params['route'][0] if 'route' in params else 'in'
        atom = False if 'atom' in params and params["atom"][0] and params["atom"][0] != "yes" and params["atom"][0] != "1" else True
        return [Rules.collectRules(route, atom)]

    elif query == "collect_dict2yt":
        start_response("200 OK", [("Content-type", "text/plain")])
        route = params['route'][0] if 'route' in params else 'in'
        return [collectRules2YT(route)]

    elif query == "ui":
        start_response("200 OK", [("Content-type", "text/html")])
        return [render_ml_ui(params, environ, ytw)]

    elif query == "save_file":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [saveFile(params, environ)]

    elif query == "save_model_status":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [saveModelStatus(params, environ)]

    elif query == "save_model_params":
        start_response("200 OK", [("Content-type", "text/plain")])
        pars = {}
        for p in params:
            pars[p] = unquote(params[p][0])
        return [saveModelParams(pars)]

    elif query == "save_formula_info":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [saveFormulaInfo(params, environ)]

    elif query == "download_formula_info":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [saveFormulaInfo(params, environ)]

    elif query == "save_acceptance_metrics_info":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [saveAcceptanceMetricsInfo(params, environ)]

    elif query == "send_info_email":
        start_response("200 OK", [("Content-type", "text/plain")])
        return [sendInfoEmail(params, environ)]

    elif query == "save_intermidiate_tables_info":
        start_response("200 OK", [("Content-type", "text/plain")])
        formula_id = params['formula_id'][0] if 'formula_id' in params else ''
        workflow_id = params['workflow_id'][0] if 'workflow_id' in params else ''
        workflow_instance_id = params['workflow_instance_id'][0] if 'workflow_instance_id' in params else ''
        source_op = params['source_op'][0] if 'source_op' in params else ''
        if not workflow_id and formula_id:
            model = getModel(formula_id)
            if 'workflow_id' in model:
                workflow_id = model['workflow_id']
        if workflow_id:
            saveWorkflowIntermidiateYTTables(formula_id, workflow_id, workflow_instance_id, source_op)
        return []

    elif query == "get_pool_filter_items":
        start_response("200 OK", [("Content-type", "application/json")])
        route = params['route'][0] if 'route' in params else 'in'
        return [getPoolFilterItems(route)]

    elif query == "get_domains_filter_items":
        start_response("200 OK", [("Content-type", "application/json")])
        route = params['route'][0] if 'route' in params else 'in'
        return [getDomainsFilterItems(route)]

    elif query == "get_compared_models":
        start_response("200 OK", [("Content-type", "application/json")])
        deepness = int(params['deepness'][0]) if 'deepness' in params and str(params['deepness'][0]).isdigit() else -1
        route = params['route'][0] if 'route' in params else 'in'
        addon_params, db, models = {}, None, []
        for p in ["formula1", "formula2"]:
            if p in params and params[p][0]:
                addon_params[p] = params[p][0]
        if addon_params:
            formulas = {}
            try:
                db = getDB(MONGO)
                for rec in db['comparing_models_info'].find(addon_params, {'_id': False, 'formula1': True, 'formula2': True}):
                    formulas['formula1'] = 1
                    formulas['formula2'] = 1
                for rec in db['models'].find({'route': route, 'formula_id': {'$in': formulas.keys()}}, {'_id': False, 'formula_id': True}):
                    if 'formula_id' not in model or ('am_f_measure' not in model and 'f1_score' not in model) or 'threshold' not in model:
                        continue
                    models.append(getModel(int(rec['formula_id']), route = route, db = db))
            except Exception, e:
                writelog("Retrieing data from DB table comparing_models_info failed: %s" % str(e), True)
        return [json.dumps(getComparedModels(models, deepness, route, db))]

    elif query == "get_comparing_info":
        start_response("200 OK", [("Content-type", "application/json")])
        formula_id = params["formula_id"][0] if "formula_id" in params else []
        return [json.dumps(getComparedModelsInfo(formula_id))]

    elif query == "save_applied_pool_params":
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(saveAppliedPoolParams(params, ytw))]

    elif query == "calc_cross_comparison":
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(calcCrossComparison(params))]

    elif query == "save_conductor_ticket":
        start_response("200 OK", [("Content-type", "application/json")])
        return [json.dumps(saveConductorTicket(params))]

    elif query == "get_conductor_ticket_status":
        start_response("200 OK", [("Content-type", "application/json")])
        ticket_id = params['ticket_id'][0] if 'ticket_id' in params else ''
        status = getConductorTicketStatus(ticket_id)
        writelog("Ticket status: %s" % status)
        return []

    elif query == "enable_prod_slot_model":
        start_response("200 OK", [("Content-type", "application/json")])
        enable = int(params['enable'][0]) if 'enable' in params and params['enable'][0] else 0
        route = params['route'][0] if 'route' in params else 'in'
        Rules.updateRulesRepo()
        Rules.enableProdSlotModel(enable, route)
        return []

    elif query == "get_ml_settings":
        start_response("200 OK", [("Content-type", "application/json")])
        route = params['route'][0] if 'route' in params else 'in'
        return [json.dumps(getMLSettings(route))]

    elif query == "get_setting":
        start_response("200 OK", [("Content-type", "text/plain")])
        setting = params['setting'][0] if 'setting' in params else ''
        section = params['section'][0] if 'section' in params else 'general'
        s = getSetting(setting, section)
        if type(s) == dict:
            s = json.dumps(s)
        else:
            s = str(s)
        return [s]

    elif query == "send_model_to_prod":
        start_response("200 OK", [("Content-type", "application/json")])
        formula_id = int(params['formula_id'][0]) if 'formula_id' in params else 0
        threshold = float(params['threshold'][0]) if 'threshold' in params else 0
        branch = params['branch'][0] if 'branch' in params else 'prestable'
        route = params['route'][0] if 'route' in params else 'in'
        #Rules.enableProdSlotModel(branch == 'stable')
        sendModelToProdBranch(formula_id, threshold, MODELS['testing_slot'], branch, route)
        return []

    elif query == "get_current_vw_model":
        start_response("200 OK", [("Content-type", "application/octet-stream")])
        return [getCurrentVWmodel()]

    elif query == "start_step1":
        start_response("200 OK", [("Content-type", "application/json")])
        uwsgi.register_signal(SIGNALS['Step1.Check_models_diff'], "mule", checkModelsComparison)
        uwsgi.add_rb_timer(SIGNALS['Step1.Check_models_diff'], 10, 1)
        writelog("Step 1 done.")
        return []

    elif query == "start_step2":
        start_response("200 OK", [("Content-type", "application/json")])
        writelog("Go to next step: Step2.Check_complaints")
        uwsgi.register_signal(SIGNALS['Step2.Check_complaints'], "mule", checkModelsComplaintsComparison)
        uwsgi.add_rb_timer(SIGNALS['Step2.Check_complaints'], 10, 1)
        return []

    elif query == "start_step3":
        start_response("200 OK", [("Content-type", "application/json")])
        writelog("Go to next step: Step3.Check_done")
        uwsgi.register_signal(SIGNALS['Step3.Check_done'], "mule", checkIfModelDelivered)
        uwsgi.add_rb_timer(SIGNALS['Step3.Check_done'], 10, 1)
        return []

    elif query == "start_step2_test":
        start_response("200 OK", [("Content-type", "application/json")])
        data, s = {}, 0
        writelog("Start Checking Models Complaints Comparison...")
        mt = {'$gte': int(time.mktime((datetime.now() - timedelta(hours = 6.5)).timetuple())), '$lte': int(time.mktime((datetime.now() - timedelta(hours = 0.5)).timetuple()))}
        #print >>sys.stderr, "Step2_test: Time constrains: %s" % str(mt)
        try:
            db = getDB(RULES)
            for r in db['detailed_Rules_In'].find({'rule': {'$in': ['MN_AREA_ALL', 'MN_AREA_ALL_C']}, 'time': mt}):
                if r['time'] not in data:
                    data[r['time']] = {'MN_AREA_ALL': {}, 'MN_AREA_ALL_C': {}}
                for c in ['R1', 'R2', 'R4', 'cmpl_spam', 'cmpl_ham']:
                    data[r['time']][r['rule']][c] = 1.0 * r[c] if c in r else 0
            for t in data:
                z = (data[t]['MN_AREA_ALL_C'].get('cmpl_ham', 0) + data[t]['MN_AREA_ALL_C'].get('cmpl_spam', 0)) * (data[t]['MN_AREA_ALL'].get('R1', 0) + data[t]['MN_AREA_ALL'].get('R2', 0) + data[t]['MN_AREA_ALL'].get('R4', 0)) * 1.0
                #print >>sys.stderr, "Step2_test: t = %s, z = %s" % (t, z)
                if z > 0:
                    s += (data[t]['MN_AREA_ALL'].get('cmpl_ham', 0) + data[t]['MN_AREA_ALL'].get('cmpl_spam', 0)) * (data[t]['MN_AREA_ALL_C'].get('R1', 0) + data[t]['MN_AREA_ALL_C'].get('R2', 0) + data[t]['MN_AREA_ALL_C'].get('R4', 0)) / z
            #print >>sys.stderr, "Step2_test: s_sum = %s" % s
            s = (s / len(data.keys())) if len(data.keys()) > 0 else 0
            #print >>sys.stderr, "Step2_test: s = %s, data size: %s, data: %s" % (s, len(data), str(data))
        except Exception, e:
            writelog("Step2_test DB error: %s.\n" % str(e), True)
        writelog("Step2_test: s = %s" % s)
        prod_models = getProdModelsCurrent()
        if s > 0.98:
            writelog("Model accepted")
            model = prod_models[MODELS['testing_slot'] - 1]
            #sendModelToProdBranch(model['formula'], model['threshold'], MODELS['current_slot'], 'stable')
            #txt = "<div><p>Основание: отклонение с текущей моделью по жалобам (отношение) k=<b>%s > 0.98</b>.</p><p>Этап: 7,5 ч. после выкатки новой модели и 6 ч. после назначениея ей ненулевого веса.</p></div>" % s
            #sendNotificationEmail(txt, 'Новая модель <b>%s</b> принята в результате сравнения по жалобам.' % model['formula'], 'Новая модель принята')
            #fireModelStatus('model_is_accepted_by_complaints')
        else:
            writelog("Model rejected")
            model = prod_models[MODELS['current_slot'] - 1]
            #txt = "<div><p>Причина: слишком большие отклонения с текущей моделью по жалобам (отношение k=<b>%s</b>).</p><p>Этап: 7,5 ч. после выкатки новой модели и 6 ч. после назначениея ей ненулевого веса.</p></div>" % s
            #sendNotificationEmail(txt, 'Новая модель <b>%s</b> не принята в результате сравнения по жалобам. Поэтому откатываемся на старую модель <b>%s</b>.' % (prod_models[MODELS['testing_slot'] - 1]['formula'], model['formula']), 'Новая модель не принята')
            #fireModelStatus('model_is_not_accepted_by_complaints')
            #sendModelToProdBranch(model['formula'], model['threshold'], MODELS['testing_slot'], 'stable', 'revert')
        writelog("Go to next step: Step3.Check_done")
        uwsgi.register_signal(SIGNALS['Step3.Check_done'], "mule", checkIfModelDelivered)
        uwsgi.add_rb_timer(SIGNALS['Step3.Check_done'], 10, 1)
        writelog("Step 2 (test) done.")
        return []

    elif query == "start_step3_test":
        start_response("200 OK", [("Content-type", "application/json")])
        if isModelDelivered():
            #txt = "<div><p>Этап: 6,5 ч. после выкатки новой модели и 5 ч. после назначениея ей ненулевого веса.</p><p>Запускаем сбор пула для новой модели;)</p></div>"
            #sendNotificationEmail(txt, 'Модель была успешно протестирована онлайн и выкачена в прод в качестве решающей.', 'Новая модель выкачена в прод')
            #startNewModelWorkflow()
            #fireModelStatus('new_workflow')
            writelog("Model delivered")
        else:
            #txt = "<div><p>ВНИМАНИЕ: посмотрите, пожалуйста, на машинках демона СО - почему модель не стала работать на всех машинках.</p><p>Этап: 6,5 ч. после выкатки новой модели и 5 ч. после назначениея ей ненулевого веса.</p></div>"
            #sendNotificationEmail(txt, 'Модель была выкачена в прод в качестве решающей, однако за 1 час не смогла докатиться до всех машинок.', 'Модель недовыкачена в прод')
            #fireModelStatus('model_is_not_delivered')
            writelog("Model undelivered")
        return []

    elif query == "test":
        start_response("200 OK", [("Content-type", "application/json")])
        uwsgi.register_signal(30, "mule", test_signal_30)
        uwsgi.add_rb_timer(30, 4, 1)
        return []

    elif query == "test2":
        start_response("200 OK", [("Content-type", "application/json")])
        prod_models = getProdModelsCurrent()
        writelog("ProdModels: %s" % str(prod_models))
        for model in sorted(prod_models, key = lambda m: m['prod_number']):
            writelog("Model: %s" % str(model))
        return []

    else:
        s, sm = '', []
        for h, v in environ.items():
            if re.match(r'[A-Z_]+', h):
                s += "%s: %s\n" % (h, v)
            else: sm.append(h)
        start_response("200 OK", [("Content-type", "text/plain")])
        return ["Env: %sOther keys: %s\nQuery: %s\n" % (s, ', '.join(sm), query)]
