#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, json, time
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import pymongo, subprocess, Rules
from urllib import urlopen
from collections import defaultdict
from jinja2 import Environment, FileSystemLoader
from shutil import rmtree
from so_ml_lib import *

LOGFILE = 'WORKING_DIR/logs/so-ml-ui.log'

def saveModel(formula_id, model):
    if not formula_id and 'formula_id' in model and model['formula_id']:
        formula_id = int(model['formula_id'])
    try:
        for k in model.keys():
            if k == 'formula_id' or not k:
                del model[k]
        if len(model.keys()) > 0:
            db = getDB(MONGO)
            db['models'].update_one({'formula_id': formula_id}, {'$set': model})
    except Exception, e:
        writelog("saveModel error: %s" % str(e), True)

def removeModel(formula_id, yt):
    try:
        model = getModel(formula_id)
        if os.path.isdir(MODELS['folder'] + str(formula_id)):
            rmtree(MODELS['folder'] + str(formula_id))
        if 'workflow_id' in model:
            db = getDB(MONGO)
            for r in db['intermidiate_tables'].find({'workflow_id': model['workflow_id']}):
                if 'path' in r:
                    p = r['path'][:r['path'].rfind('/')]
                    if yt.exists(p) and db['intermidiate_tables'].find({'path': {'$regex': '^%s' % p}}).count() == 1:
                        yt.remove(p, recursive = True, force = True)
                db['intermidiate_tables'].delete_one({'_id': r['_id']})
        db['models'].delete_one({'formula_id': int(formula_id)})
    except Exception, e:
        writelog("removeModel error: %s" % str(e), True)

def saveModelParam(formula_id, param, param_value):
    try:
        model = getModel(formula_id)
        model[param] = param_value
        saveModel(formula_id, model)
    except Exception, e:
        writelog("saveModelParam error: %s" % str(e), True)

def setModelParams(params, workflow_id = '', formula_id = 0, db = None):
    try:
        if not db:
            db = getDB(MONGO)
        cond, d = {}, {}
        d.update(params)
        if workflow_id:
            cond['workflow_id'] = workflow_id
            if formula_id:
                d['formula_id'] = int(formula_id)
        elif formula_id:
            cond['formula_id'] = int(formula_id)
        db['models'].update_one(cond, {'$set': d}, upsert = True)
    except Exception, e:
        writelog("setModelParams DB error: %s.\n" % str(e), True)

def sendModels2Prod(formula_ids, thresholds, comments, infos, branch = 'prestable', db = None, yt = None):
    files, prod_models, t = {}, [], time.strftime("%Y-%m-%d %H:%M:%S")
    for i in range(len(formula_ids)):
        prod_models.append({
            'formula':     int(formula_ids[i]),
            'datetime':    t,
            "prod_number": i + 1,
            'threshold':   float(thresholds[i]),
            'comment':     comments[i],
            'info':        infos[i]
        })
    return sendModelsToProd(prod_models, branch, 0, db, yt)

def getMLstatus(route = 'in', db = None):
    try:
        if not db:
            db = getDB(MONGO)
        prod = db['prod_history'].find_one({'route': route}, sort = [('datetime', pymongo.DESCENDING)])
    except Exception, e:
        writelog("getMLstatus DB error \"%s\" for record: %s" % (str(e), str(model)), True)
    return (prod['status'] if 'status' in prod else '')

def getProdModelInfo(formula_id, slot, route = 'in', db = None):
    if not formula_id or not slot:
        return None
    try:
        if not db:
            db = getDB(MONGO)
        model = db['models_prod_history'].find_one({'formula': formula_id, 'slot': slot, 'route': route}, sort = [('datetime', pymongo.DESCENDING)], limit = 1)
        if model and model['_id']:
            del model['_id']
            return model
    except Exception, e:
        writelog("getProdModelInfo DB error \"%s\" for record: %s" % (str(e), str(model)), True)
    return None

def getProdModelsInfo(dt, route = 'in', db = None):
    models = []
    if not dt:
        return models
    try:
        if not db:
            db = getDB(MONGO)
        prod = db['prod_history'].find_one({'datetime': dt, 'route': route})
        if prod and 'formulas' in prod:
            for (slot, formula_id) in prod['formulas'].iteritems():
                model = db['models_prod_history'].find_one({"formula": int(formula_id), 'slot': slot, "datetime": {'$lte': dt}, 'route': route}, sort = [('datetime', pymongo.DESCENDING)], limit = 1)
                if model:
                    del model['_id']
                    models.append(model)
    except Exception, e:
        writelog("getProdModelsInfo DB error: \"%s\"" % str(e), True)
    return models

def getProdModelsHistory(start = -1, size = -1, route = 'in', db = None):
    if start < 0:
        start = 0
    if size < 0:
        size = 20
    prod_history = []
    try:
        if not db:
            db = getDB(MONGO)
        for prod in db['prod_history'].find({'route': route}, sort = [('datetime', pymongo.DESCENDING)], skip = start, limit = size):
            if prod and prod['_id']:
                del prod['_id']
                prod_history.append(prod)
    except Exception, e:
        writelog("getProdModelsHistory DB error: %s" % str(e), True)
    return prod_history

def makePoolFromDlvLog(model, dlvlog, yt):
    rules, selur, result = {}, {}, ''
    writelog("Model: %s" % json.dumps(model))
    if not ('rules_dict' in model and yt.exists(model['rules_dict'])):
        return None
    for r in yt.read_table(model['rules_dict'], format = yt.JsonFormat(), raw = False):
        rules[r['rule']] = r['num'] if r['act'] else 0
        if r['act']:
            selur[r['num']] = r['rule']
    m = re.search(r'^r_sp: (.*)$', dlvlog, re.M)
    if not m:
        writelog("Unable to find 'r_sp: ' header!")
        return None
    vector = ["0" for i in range(len(rules.keys()) + 10)]
    for rule in re.split(r',\s*', m.group(1)):
        m2 = re.match(r'\w+', rule)
        if m2:
            vector[int(rules.get(m2.group(0), 0))] = "1"
    m = re.search(r'^r_dl: (.*)$', dlvlog, re.M)
    if m:
        for rule in re.split(r',\s*', m.group(1)):
            m2 = re.match(r'\w+', rule)
            if m2:
                vector[int(rules.get(m2.group(0), 0))] = "1"
    for cancel in re.findall(r'^log : Cancel:\s+(.*)$', dlvlog, re.M):
        for rule in cancel.split():
            vector[int(rules.get(rule, 0))] = "1"
    m, q_num, i, v_rules = re.search(r'^r_nl: (.*)$', dlvlog, re.M), 1, 0, {}
    if m:
        for rule in re.split(r',\s*', m.group(1)):
            vector[int(rules.get(rule, 0))] = "1"
    vector[0], spamflag = "0", 1 if re.search(r'^spam: yes', dlvlog, re.M) else 0
    for j in range(len(vector)):
        if vector[j] != "0":
            v_rules[i] = j; i += 1
    result += "%d\t%d\t_test_message_\t0\t%s\n" % (q_num, spamflag, "\t".join(vector))
    for i in range(len(v_rules)):
        if i not in selur: continue
        for j in range(i, len(v_rules)):
            if j not in selur: continue
            tmp_v = [x for x in vector]
            tmp_v[v_rules[i]] = tmp_v[v_rules[j]] = "0"
            q_num += 1
            result += "%d\t%d\t_test_message_|%s|%s\t0\t%s\n" % (q_num, spamflag, selur[v_rules[i]], selur[v_rules[j]], "\t".join(tmp_v))
    return result

def getOperationsParams(workflow):
    operations = {}
    for block in workflow:
        try:
            params = {}
            for param in block['parameters']:
                params[param["parameter"]] = param["value"] if 'value' in param else ''
            operations[block["blockCode"]] = params
        except Exception, e:
            writelog("getOperationsParams error '%s' for block: %s" % (str(e), json.dumps(block)), True)
    return operations

def getSettings(settings = {}, route = 'in'):
    try:
        workflow = json.loads(requestNirvana('getBlockParameters', {'workflowId': ID['main_workflow_%s' % route], 'workflowInstanceId': ID['main_workflow_instance_%s' % route], 'returnNulls': 1}))
        if 'error' in workflow:
            writelog('getSettings error: code=%s, message="%s", data="%s"' % (workflow['error']['code'], workflow['error']['message'], workflow['error']['data'] if 'data' in workflow['error'] else ''))
            return settings
        try:
            ops = getOperationsParams(workflow['result'])
            settings['compl_type'] = ops['operation-1477573675683-12']['cmpltype'] if 'cmpltype' in ops['operation-1477573675683-12'] else ''
            settings['max_user_day_complaints'] = ops['operation-1477573675683-12']['user_compl_cnt'] if 'user_compl_cnt' in ops['operation-1477573675683-12'] else ''
            settings['geo'] = ops['operation-1477573689368-19']['geo'] if 'geo' in ops['operation-1477573689368-19'] else ''
            settings['step'] = ops['operation-1477573689368-19']['step'] if 'step' in ops['operation-1477573689368-19'] else ''
            if 'extra_params' in ops['operation-1477573689368-19']:
                extra_params = map(unicode.strip, ops['operation-1477573689368-19']['extra_params'].split(','))
                try:
                    settings['good_domains'] = True if extra_params.index('good_domains') > -1 else False
                except:
                    settings['good_domains'] = ""
                try:
                    settings['delivery'] = True if extra_params.index('delivery') > -1 else False
                except:
                    settings['delivery'] = ""
            settings['max_user_complaints'] = ops['operation-1477573689368-19']['user_msg_cnt_limit'] if 'user_msg_cnt_limit' in ops['operation-1477573689368-19'] else ''
            settings['only_rules'] = ops['operation-1477573689368-19']['onlyrules'] if 'onlyrules' in ops['operation-1477573689368-19'] else ''
            settings['excl_rules'] = ops['operation-1477573689368-19']['exclrules'] if 'exclrules' in ops['operation-1477573689368-19'] else ''
            settings['add_rules'] = ops['operation-1477573689368-19']['addrules'] if 'addrules' in ops['operation-1477573689368-19'] else ''
            settings['white_rules'] = ops['operation-1477573711470-26']['whiterules'] if 'whiterules' in ops['operation-1477573711470-26'] else ''
            settings['black_rules'] = ops['operation-1477573711470-26']['blackrules'] if 'blackrules' in ops['operation-1477573711470-26'] else ''
            settings['test_percent'] = ops['operation-1477573869405-65']['test-percentage'] if 'test-percentage' in ops['operation-1477573869405-65'] else ''
            settings['notify_about_basic_pool'] = True if 'notify-users' in ops['operation-1479313533273-60'] and ops['operation-1479313533273-60']['notify-users'] else False
            settings['notify_about_test_pool'] = True if 'notify-users' in ops['operation-1479480736610-110'] and ops['operation-1479480736610-110']['notify-users'] else False
            settings['notify_about_formula_test_pool'] = True if 'notify-users' in ops['operation-1480009292641-60'] and ops['operation-1480009292641-60']['notify-users'] else False
            if 'notify-users' in ops['operation-1480009292641-60'] and ops['operation-1480009292641-60']['notify-users']:
                settings['notify_email'] = ops['operation-1480009292641-60']['notify-users']
            elif 'notify-users' in ops['operation-1479313533273-60'] and ops['operation-1479313533273-60']['notify-users']:
                settings['notify_email'] = ops['operation-1479313533273-60']['notify-users']
            elif 'notify-users' in ops['operation-1479480736610-110'] and ops['operation-1479480736610-110']['notify-users']:
                settings['notify_email'] = ops['operation-1479480736610-110']['notify-users']
            training_op = 'operation-1554730743215-260' if 'operation-1554730743215-260' in ops else ('operation-1486044774742-53' if 'operation-1486044774742-53' in ops else 'operation-1477573785344-44')
            settings['where_to_run'] = ops[training_op]['commonMnetOptions.where-to-run'] if 'commonMnetOptions.where-to-run' in ops[training_op] else ''
            settings['iterations'] = ops[training_op]['commonMnetOptions.iterations'] if 'commonMnetOptions.iterations' in ops[training_op] else ''
            settings['slaves'] = ops[training_op]['commonMnetOptions.slaves'] if 'commonMnetOptions.slaves' in ops[training_op] else ''
            settings['regularisation'] = ops[training_op]['commonMnetOptions.regularisation'] if 'commonMnetOptions.regularisation' in ops[training_op] else ''
            settings['discretisation'] = ops[training_op]['commonMnetOptions.discretisation'] if 'commonMnetOptions.discretisation' in ops[training_op] else ''
            settings['sample_rate'] = ops[training_op]['commonMnetOptions.sample-rate'] if 'commonMnetOptions.sample-rate' in ops[training_op] else ''
            #settings['ignore_factors'] = ops[training_op]['commonMnetOptions.ignoreFactors'] if 'commonMnetOptions.ignoreFactors' in ops[training_op] else ''
            settings['ignore_factors'] = ops[training_op]['commonMnetOptions.ignored-range'] if 'commonMnetOptions.ignored-range' in ops[training_op] else ''
            settings['learning_method'] = ops[training_op]['gpuMnetOptions.learningMethod'] if 'gpuMnetOptions.learningMethod' in ops[training_op] else ''
            settings['weak_learner'] = ops[training_op]['gpuMnetOptions.weakLearner'] if 'gpuMnetOptions.weakLearner' in ops[training_op] else ''
            settings['grid'] = ops[training_op]['gpuMnetOptions.grid'] if 'gpuMnetOptions.grid' in ops[training_op] else ''
            settings['p_value'] = ops[training_op]['gpuMnetOptions.pValue'] if 'gpuMnetOptions.pValue' in ops[training_op] else ''
            settings['feature_sample_rate'] = ops[training_op]['gpuMnetOptions.feature-sample-rate'] if 'gpuMnetOptions.feature-sample-rate' in ops[training_op] else ''
            settings['forest'] = ops[training_op]['gpuMnetOptions.forest'] if 'gpuMnetOptions.forest' in ops[training_op] else ''
            settings['fml_addon_params'] = ops[training_op]['gpuMnetOptions.other-formula-options'] if 'gpuMnetOptions.other-formula-options' in ops[training_op] else ''
            settings['fml_notify_users'] = ', '.join(ops[training_op]['notificationOptions.cc-users']) if 'notificationOptions.cc-users' in ops[training_op] else ''
            settings['deepness'] = ops['operation-1479408208302-141']['deepness'] if 'deepness' in ops['operation-1479408208302-141'] else ''
        except Exception, e:
            writelog("getSettings failed to retrieve option from Nirvana's Workflow: %s" % str(e), True)
        try:
            settings['autostart_workflow'], settings['wds'] = 1, []
            rec = getSetting()
            for wd in ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']:
                settings['wds'].append(int(rec[wd]) if wd in rec else 0)
            for k in ['autostart_workflow', 'offline_test', 'online_test']:
                settings[k] = 1 if rec[k] else 0
            settings['limit_t1'] = rec['limit_t1'] if 'limit_t1' in rec else '00:00'
            settings['limit_t2'] = rec['limit_t2'] if 'limit_t2' in rec else '23:59'
        except Exception, e:
            writelog("getSettings DB error: %s" % str(e), True)
    except Exception, e:
        writelog("getSettings error: %s" % str(e), True)
    return settings

def saveSettings(settings, route = 'in'):
    blocks, params = [], []
    for local_id in ['operation-1477573675683-12', 'operation-1477573689368-19', 'operation-1479400835839-111', 'operation-1509716447941-180', 'operation-1509716682650-193',
                     'operation-1477573869405-65', 'operation-1486044774742-53', 'operation-1479408208302-141']:
        blocks.append({'code': local_id})
    try:
        params.append({'parameter': 'cmpltype', 'value': settings['compl_type']})
        params.append({'parameter': 'user_compl_cnt', 'value': settings['max_user_day_complaints'] if settings['max_user_day_complaints'] else None})
        params.append({'parameter': 'geo', 'value': settings['geo']})
        params.append({'parameter': 'step', 'value': float(settings['step']) if settings['step'] else None})
        params.append({'parameter': 'extra_params', 'value': settings['extra_params']})
        params.append({'parameter': 'user_msg_cnt_limit', 'value': int(settings['max_user_complaints']) if settings['max_user_complaints'] else None})
        params.append({'parameter': 'onlyrules', 'value': settings['only_rules']})
        params.append({'parameter': 'exclrules', 'value': settings['excl_rules']})
        params.append({'parameter': 'addrules', 'value': settings['add_rules']})
        params.append({'parameter': 'whiterules', 'value': settings['white_rules']})
        params.append({'parameter': 'blackrules', 'value': settings['black_rules']})
        params.append({'parameter': 'test-percentage', 'value': float(settings['test_percent'])})
        params.append({'parameter': 'commonMnetOptions.iterations', 'value': int(settings['iterations']) if settings['iterations'] else None})
        params.append({'parameter': 'commonMnetOptions.slaves', 'value': int(settings['slaves']) if settings['slaves'] else None})
        params.append({'parameter': 'commonMnetOptions.regularisation', 'value': float(settings['regularisation']) if settings['regularisation'] else None})
        params.append({'parameter': 'commonMnetOptions.discretisation', 'value': int(settings['discretisation']) if settings['discretisation'] else None})
        params.append({'parameter': 'commonMnetOptions.sample-rate', 'value': float(settings['sample_rate']) if settings['sample_rate'] else None})
        params.append({'parameter': 'commonMnetOptions.ignoreFactors', 'value': settings['ignore_factors']})
        params.append({'parameter': 'gpuMnetOptions.learningMethod', 'value': settings['learning_method']})
        params.append({'parameter': 'gpuMnetOptions.weakLearner', 'value': settings['weak_learner']})
        params.append({'parameter': 'gpuMnetOptions.grid', 'value': settings['grid']})
        params.append({'parameter': 'gpuMnetOptions.pValue', 'value': float(settings['p_value']) if settings['p_value'] else None})
        params.append({'parameter': 'gpuMnetOptions.forest', 'value': int(settings['forest']) if settings['forest'] else None})
        params.append({'parameter': 'gpuMnetOptions.other-formula-options', 'value': settings['fml_addon_params']})
        params.append({'parameter': 'notificationOptions.cc-users', 'value': map(str.strip, settings['fml_notify_users'].split(','))})
        params.append({'parameter': 'deepness', 'value': int(settings['deepness']) if settings['deepness'] else None})
        r = json.loads(requestNirvana('setBlockParameters', {'workflowId': ID['main_workflow_%s' % route], 'workflowInstanceId': ID['main_workflow_instance_%s' % route], 'blocks': blocks, 'params': params}))
        if 'error' in r:
            writelog('setBlockParameters for other blocks error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
        r = json.loads(requestNirvana('setBlockParameters', {
                'workflowId': ID['main_workflow_%s' % route],
                'workflowInstanceId': ID['main_workflow_instance_%s' % route],
                'blocks': [{'code': 'operation-1479313533273-60'}],
                'params': [{'parameter': 'notify-users', 'value': settings['notify_email'] if int(settings['notify_about_basic_pool']) else ''}]
            }))
        if 'error' in r:
            writelog('setBlockParameters prod pool get statistics error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
        r = json.loads(requestNirvana('setBlockParameters', {
                'workflowId': ID['main_workflow_%s' % route],
                'workflowInstanceId': ID['main_workflow_instance_%s' % route],
                'blocks': [{'code': 'operation-1479480736610-110'}],
                'params': [{'parameter': 'notify-users', 'value': settings['notify_email'] if int(settings['notify_about_test_pool']) else ''}]
            }))
        if 'error' in r:
            writelog('setBlockParameters test pool get statistics error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
        r = json.loads(requestNirvana('setBlockParameters', {
                'workflowId': ID['main_workflow_%s' % route],
                'workflowInstanceId': ID['main_workflow_instance_%s' % route],
                'blocks': [{'code': 'operation-1480009292641-60'}],
                'params': [{'parameter': 'notify-users', 'value': settings['notify_email'] if int(settings['notify_about_formula_test_pool']) else ''}]
            }))
        if 'error' in r:
            writelog('setBlockParameters prod pool with applyed test pool get statistics error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
        try:
            db = getDB(MONGO)
            s = {'limit_t1': settings['limit_t1'], 'limit_t2': settings['limit_t2']}
            for k in ['autostart_workflow', 'offline_test', 'online_test']:
                s[k] = int(settings[k])
            for i, wd in enumerate(['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'], 1):
                s[wd] = int(settings['wd_%d' % i])
            if 'slots' in settings:
                slots = []
                try:
                    slots = json.loads(settings['slots'])
                except Exception, e:
                    writelog("Parsing of JSON with slots info failed: %s" % str(e), True)
                if slots:
                    s["slots_%s" % route] = map(lambda el: el[0], slots)
                    for el in slots:
                        s["slots_names.%s" % el[0]] = el[1]
            db['settings'].update_one({'_id': 'general'}, {'$set': s})
        except Exception, e:
            writelog("saveSettings DB error: %s" % str(e), True)
    except Exception, e:
        writelog("saveSettings error: %s" % str(e), True)

def checkMLstatus(route = 'in'):
    info, r = {"color": "green"}, None
    try:
        db = getDB(MONGO)
        model = db['models'].find_one({'route': route}, sort = [('start_time', pymongo.DESCENDING)], limit = 1)
        prod = db['prod_history'].find_one({'route': route}, sort = [('datetime', pymongo.DESCENDING)], limit = 1)
        info['ml_status'] = prod['status'] if prod and 'status' in prod else ''
        model_status = model['status'] if model and 'status' in model else ''
        if model and 'workflow_id' in model and model['workflow_id']:
            info['workflow_id'] = model['workflow_id']
            try:
                r = json.loads(requestNirvana('getWorkflowMetaData', {'workflowId': model['workflow_id']}))
                if 'error' in r:
                    writelog('getWorkflowMetaData error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
                    r = None
                else:
                    r = json.loads(requestNirvana('getExecutionState', {'workflowId': model['workflow_id'], 'workflowInstanceId': r['result']['instanceId']}))
                    if 'error' in r:
                        writelog('getExecutionState error: code=%s, message="%s", data="%s"' % (r['error']['code'], r['error']['message'], r['error']['data'] if 'data' in r['error'] else ''))
                        r = None
                #writelog("getExecutionState: %s" % str(r))
            except Exception, e:
                writelog("checkMLstatus error: %s" % str(e), True); r = None
        #if not r:
        #    info['status'], info["color"] = u'неопределён', 'grey'
        if model_status == 'pool_gathering':
            info['status'], info['ml_status'] = u'Сбор пула', 'pool_gathering'
            if r and 'result' in r and 'status' in r['result'] and r['result']['status'] == 'completed':
                if r['result']['result'] == 'failure':
                    info['status'] = u'Сбор пула не удался'; info["color"] = 'red'
                elif r['result']['result'] == 'cancel':
                    info['status'] = u'Сбор пула отменён пользователем'; info["color"] = 'red'
                elif r['result']['result'] == 'undefined':
                    info['status'] = u'Сбор пула подвис'; info["color"] = 'yellow'
        elif model_status == 'models_learning':
            info['status'], info['ml_status'] = u'Обучение модели', 'models_learning'
            if r and 'result' in r and 'status' in r['result'] and r['result']['status'] == 'completed':
                if r['result']['result'] == 'failure':
                    info['status'] = u'Обучение модели не удалось'; info["color"] = 'red'
                elif r['result']['result'] == 'cancel':
                    info['status'] = u'Обучение модели отменёно пользователем'; info["color"] = 'red'
                elif r['result']['result'] == 'undefined':
                    info['status'] = u'Обучение модели подвисло'; info["color"] = 'yellow'
        elif model_status == 'models_params_calc':
            info['status'], info['ml_status'] = u'Расчёт параметров модели', 'models_params_calc'
            if r and 'result' in r and 'status' in r['result'] and r['result']['status'] == 'completed':
                if r['result']['result'] == 'failure':
                    info['status'] = u'Расчёт параметров модели не удался'; info["color"] = 'red'
                elif r['result']['result'] == 'cancel':
                    info['status'] = u'Расчёт параметров модели отменён пользователем'; info["color"] = 'red'
                elif r['result']['result'] == 'undefined':
                    info['status'] = u'Расчёт параметров модели подвис'; info["color"] = 'yellow'
        elif model_status == 'models_offline_test':
            info['status'], info['ml_status'] = u'Оффлайн тест модели', 'models_offline_test'
        elif info['ml_status'] == 'sending_models2sandbox_prestable':
            info['status'] = u'Отправка моделей в SandBox для выкатки их в тест'
        #elif model_status == 'building_package_prestable':
        #    info['status'] = u'Сборка пакетика для выкатки в тест'
        #elif info['ml_status'] == 'conductor_laying_prestable':
        #    info['status'] = u'Выкладка кондуктором на 20%'
        elif info['ml_status'] == 'model_online_test_without_weight':
            info['status'] = u'Тестирование моделей онлайн без веса'
        elif info['ml_status'] == 'sending_models2sandbox_stable':
            info['status'] = u'Отправка моделей в SandBox для выкатки их в прод'
        #elif info['ml_status'] == 'building_package_stable':
        #    info['status'] = u'Сборка пакетика для выкатки в прод'
        elif info['ml_status'] == 'model_online_test_with_weight':
            info['status'] = u'Тестирование моделей онлайн с весом'
        #elif info['ml_status'] == 'conductor_laying_stable':
        #    info['status'] = u'Выкладка кондуктором на 100%'
        elif info['ml_status'] == 'model_is_not_delivered':
            info['status'] = u'Ошибка: модель не раскатилась везде'
            info["color"] = 'red'
        elif info['ml_status'] == 'revert_model':
            info['status'] = u'Откат на предыдущую модель'
        elif info['ml_status'] == 'model_accepted':
            info['status'] = u'Модель принята'
        elif info['ml_status'] == 'waiting':
            info['status'], info["color"] = u'состояние простоя', 'yellow'
        else:
            info['status'], info["color"] = u'неопределён', 'grey'
        s = getSetting('online_test')
        info['online_test'] = int(s) if s != '' else 0
        s = getSetting('offline_test')
        info['offline_test'] = int(s) if s != '' else 0
        s = getSetting('autostart_workflow')
        info['autostart_workflow'] = int(s) if s != '' else 0
        #info['ham_weight'], info['spam_weight'] = Rules.getProdSlotModelWeight()
    except Exception, e:
        writelog("checkMLstatus error: %s" % str(e), True)
    #writelog("checkMLstatus info: %s, model: %s" % (json.dumps(info), str(model)))
    return info

def render_ml_ui(params, environ, yt):
    output = ""
    action = params["action"][0] if "action" in params else "show"
    route = params["route"][0] if "route" in params else "in"
    if action == "show":
        try:
            models, compared_models, comparing_models_info = [], [], {}
            start, size = int(params["start"][0] if "start" in params else 0), int(params["size"][0] if "size" in params else 0)
            db, year, wds = getDB(MONGO), time.strftime("%Y"), [u'Пн', u'Вт', u'Ср', u'Чт', u'Пт', u'Сб', u'Вс']
            models = sorted(getModels(False, route, db), key = lambda m: m['start_time'])
            compared_models = getComparedModels(reversed(models), route = route, db = db)
            prod_models = getProdModelsCurrent(route, db)
            prod_history = getProdModelsHistory(start, size, route, db)
            slots = getSetting('slots_%s' % route, db = db)
            slots_names = getSetting('slots_names', db = db)
            names_slots = dict([(v, k) for (k, v) in slots_names.iteritems()])
            settings = getSettings(route = route)
            for model in compared_models:
                if model['formula_id'] not in comparing_models_info:
                    comparing_models_info[str(model['formula_id'])] = {}
                for model2 in db['comparing_models_info'].find({'formula1': int(model['formula_id'])}):
                    if model2['formula2'] not in comparing_models_info[str(model['formula_id'])]:
                        comparing_models_info[str(model['formula_id'])][str(model2['formula2'])] = {}
                    del model2['_id']
                    comparing_models_info[str(model['formula_id'])][str(model2['formula2'])].update(model2)
            env = Environment(loader = FileSystemLoader("WORKING_DIR/so-ml/"))
            template = env.get_template("ml_ui.html.template")
            host = "%s://%s/internal/" % ('http' + ('s' if 'HTTPS' in environ else ''), environ['SERVER_NAME'])
            output = template.render(locals()).encode("utf-8")
        except Exception, e:
            writelog("Exception caught (tell developer, please): %s" % str(e), True)
    elif action == "get_model":
        formula_id = params["formula_id"][0] if "formula_id" in params else ""
        if formula_id:
            output = json.dumps(getModel(formula_id, route = route))
    elif action == "get_acceptance_metrics":
        formula_id = params["formula_id"][0] if "formula_id" in params else ""
        if formula_id:
            output = json.dumps(getAcceptanceMetrics(formula_id))
    elif action == "remove_model":
        formula_id = params["formula_id"][0] if "formula_id" in params else ""
        if formula_id:
            removeModel(formula_id, yt)
    elif action == "save_model_param":
        formula_id = params["formula_id"][0] if "formula_id" in params else ""
        model_param = params["param"][0] if "param" in params else ""
        if formula_id and model_param:
            saveModel(formula_id, {model_param: params["value"][0] if "value" in params else ""})
    elif action == "get_prod_model":
        formula_id = int(params["formula_id"][0] if "formula_id" in params else 0)
        slot = params["slot"][0] if "slot" in params else ""
        if formula_id and slot:
            output = json.dumps(getProdModelInfo(formula_id, slot, route))
    elif action == "get_prod_models":
        dt = params["datetime"][0] if "datetime" in params else ""
        output = json.dumps(getProdModelsInfo(dt, route))
    elif action == "send_models":
        models = {}
        try:
            models = json.loads(params["models"][0] if "models" in params else '{}')
        except Exception, e:
            writelog("Error while parsing JSON with models: %s" % str(e), True)
        writelog("Action: send_models. Models: %s. Params: %s" % (str(models), str(params)))
        #formula_ids = params["formula_ids[]"] if "formula_ids[]" in params else []
        #thresholds = params["thresholds[]"] if "thresholds[]" in params else []
        #comments = params["comments[]"] if "comments[]" in params else []
        #infos = params["infos[]"] if "infos[]" in params else []
        online_test = int(params["online_test"][0]) if "online_test" in params else 0
        #if len(formula_ids) > 0:
        #    if len(formula_ids) > 5:
        #        setModelParams({"online_test": online_test, 'mode': 'manual'}, formula_id = formula_ids[5])
        #    writelog("FormulaIDs: %s, Thresholds: %s, Comments: %s, Infos: %s" % (str(formula_ids), str(thresholds), str(comments), str(infos)))
        #    output = sendModels2Prod(formula_ids, thresholds, comments, infos, yt = yt)
        if models:
            sendModelsToProd(models, 'sending_models2sandbox_prestable' if online_test else 'sending_models2sandbox_stable', route)
    elif action == "rules_variative_analysis":
        formula_id = params["formula_id"][0] if "formula_id" in params else []
        dlvlog = params["dlvlog"][0] if "dlvlog" in params else []
        condition = params["condition"][0] if "condition" in params else []
        model = getModel(formula_id)
        pool = makePoolFromDlvLog(model, dlvlog, yt)
        if not pool:
            writelog("Variative analysis executing error: Rules dict is absent or !")
        else:
            p = subprocess.Popen('WORKING_DIR/mx_ops calc -s 4 ' + MODELS['folder'] + formula_id + '/matrixnet.info', shell = True, stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE)
            (mx_out, mx_err) = p.communicate(input = pool)
            if mx_err:
                writelog("MX_OPS errors: '%s'" % mx_err)
            if mx_out:
                result, stat, h = {'pairs_statistics': [], 'rules_statistics': [], 'total_statistics': ''}, [], defaultdict(int)
                for line in mx_out.split("\n"):
                    stat.append(line.split())
                def compare(row):
                    if len(row) < 5 or row[2].find('|') < 0:
                        return False
                    return eval("%s %s" % (row[4], condition))
                result['total_statistics'] = stat[0]
                stat = filter(compare, stat[1:])
                result['pairs_statistics'] = sorted(stat, key = lambda w: w[4], reverse = True)
                for row in stat:
                    r = row[2].split('|')
                    if len(r) < 3:
                        row[2] = 'X_X_X,X_X_X'
                    else:
                        row[2] = "%s,%s" % (r[1], r[2])
                        if r[1] == r[2]:
                            h[r[1]] += 3
                        else:
                            h[r[1]] += 1; h[r[2]] += 1
                for k in sorted(h.keys(), cmp = lambda a, b: cmp(h[b], h[a])):
                    result['rules_statistics'].append([k, h[k]])
                output = json.dumps(result)
    elif action == "apply_settings":
        settings = {}
        for k in params:
            if k == 'action': continue
            settings[k] = params[k][0]
        saveSettings(settings, route)
    elif action == "get_comparing_info":
        formula_id = params["formula_id"][0] if "formula_id" in params else []
        output = json.dumps(getComparedModelsInfo(formula_id))
    elif action == "start_comparing_models":
        formula1 = params['formula1'][0] if 'formula1' in params else ''
        formula2 = params['formula2'][0] if 'formula2' in params else ''
        output = json.dumps(startComparingModels(formula1, formula2))
    elif action == "check_status":
        output = json.dumps(checkMLstatus(route))
    elif action == "test_model_offline":
        formula_id = params["formula_id"][0] if "formula_id" in params else ''
        forced = True if "forced" in params and params["forced"][0] else False
        if formula_id:
            testModelOnline(formula_id, forceSendModelToProd = forced, yt = yt)
    return output
