#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, redis, psycopg2, ConfigParser
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
sys.path.insert(0, 'WORKING_DIR/web')
from time import sleep, strftime
from log_utils import writelog


INI_FILE = 'WORKING_DIR/so-special-labels/special-labels.ini'
DB = {
    "host": "iva-xb3w4z7jjjpuf8sd.db.yandex.net,myt-3mdnt0clvntgeqmv.db.yandex.net,sas-5nnjcnus304urap7.db.yandex.net",
    "port": 6432,
    "db":   "complaints",
    "user": "cmpl",
    "key":  "loadingGreyComplainaints",
    "t1":   "loadingGreyComplainaintsStartTime",
    "t2":   "loadingGreyComplainaintsEndTime"
}
REDIS_GREY = {
    "cluster_name":  "users_stat",
    "hosts":         ['sas-667541avf1c1ontn.db.yandex.net', 'vla-9cp0yx8ud9yrt90n.db.yandex.net'],
    "port":          6379,
    "sentinel_port": 26379,
    "db":            2,
    "timeout":       3.0,
    "auth":          True,
    "key":           "grey_complainaints",
    "batch_size":    100000
}


def getPGCredentials(cfg, log_fh=None):
    f, CURDIR, dbname = None, 'WORKING_DIR', cfg['db'][:len(cfg['db']) - 2] if cfg['db'].endswith('db') else cfg['db']
    try:
        if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
                CURDIR = '/root'
        f = open('{0}/.pgpass.{1}'.format(CURDIR, dbname))
        for line in f:
            sf = line.split(':')
            if len(sf) == 5 and sf[2] == cfg['db']:
                cfg['host'], cfg['port'], cfg['user'], cfg['password'] = sf[0], int(sf[1]), sf[3], sf[4].strip()
                break
        f.close()
    except Exception, e:
        writelog("loadGreyComplainaints: getPGCredentials exception: %s" % str(e), True, log_fh)


def getPGdb(cfg, mode='read-write', log_fh=None):
    pg = None
    CURDIR = 'WORKING_DIR'
    if not os.path.exists('{0}/.pgsql/root.crt'.format(CURDIR)):
        CURDIR = '/root'
    if hasattr(psycopg2, '__libpq_version__'):
        pg = psycopg2.connect(dbname=cfg['db'], user=cfg['user'], password=cfg['password'], host=cfg['host'], port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR, target_session_attrs=('read-write' if mode == 'read-write' else 'any'))
    else:
        if ',' in cfg['host']:
            for host in cfg['host'].split(','):
                try:
                    pg = psycopg2.connect(database=cfg['db'], user=cfg['user'], password=cfg['password'], host=host, port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR)
                    pg_cursor = pg.cursor()
                    pg_cursor.execute("SELECT pg_is_in_recovery()")
                    res = pg_cursor.fetchone()
                    pg_cursor.close()
                    if res and (mode == 'read-write' and not res[0] or mode != 'read-write' and res[0]):
                        return pg
                except Exception, e:
                    writelog("loadGreyComplainaints: getPGdb exception: %s" % str(e), True)
                    continue
        else:
            pg = psycopg2.connect(database=cfg['db'], user=cfg['user'], password=cfg['password'], host=cfg['host'], port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR)
    return pg


def getRedisCredentials(cfg, log_fh=None):
    f, CURDIR, dbname = None, 'WORKING_DIR', cfg['cluster_name'][:len(cfg['cluster_name']) - 2] if 'cluster_name' in cfg and cfg['cluster_name'].endswith('db') else cfg.get('cluster_name', '')
    try:
        if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                CURDIR = '/root'
        f = open('{0}/.redis.{1}'.format(CURDIR, dbname))
        for line in f:
            sf = line.split(':')
            if len(sf) == 1:
                cfg['password'] = sf[0].strip()
                break
            elif len(sf) == 2 and sf[0] == cfg['cluster_name']:
                cfg['cluster_name'], cfg['password'] = sf[0], sf[1].strip()
                break
        f.close()
    except Exception, e:
        writelog("loadGreyComplainaints: getRedisCredentials exception: %s" % str(e), True, log_fh)


def redisConnect(host, port, cfg):
    if 'password' in cfg and cfg['password']:
        return redis.Redis(host=host, port=port, db=cfg['db'], password=cfg['password'], socket_timeout=cfg['timeout'])
    else:
        return redis.Redis(host=host, port=port, db=cfg['db'], socket_timeout=cfg['timeout'])


def redisReconnect(cfg, log_fh=None):
    rediscli = None
    try:
        if 'auth' in cfg and cfg['auth']:
            getRedisCredentials(cfg, log_fh)
        if 'host' in cfg and cfg['host']:
            rediscli = redis.Redis(host=cfg['host'], port=cfg['port'], db=cfg['db'], socket_timeout=cfg['timeout'])
        elif 'hosts' in cfg and cfg['hosts']:
            if 'cluster_name' in cfg and cfg['cluster_name']:
                try:
                    redis_sentinel = redis.Redis(host=cfg['hosts'][0], port=cfg.get('sentinel_port', 26379), socket_timeout=cfg['timeout'])
                    host=redis_sentinel.sentinel_get_master_addr_by_name(cfg['cluster_name'])
                    rediscli = redisConnect(host[0], host[1], cfg)
                except Exception, e:
                    writelog("Exception in redisReconnect for cluster '%s': %s" % (cfg['cluster_name'], str(e)), True, log_fh)
            else:
                for host in cfg['hosts']:
                    try:
                        rediscli = redisConnect(host, cfg['port'], cfg)
                        if rediscli.info()["role"] == "master":
                            return rediscli
                    except Exception, e:
                        writelog("Exception in redisReconnect: %s" % str(e), True, log_fh)
    except Exception, e:
        writelog("loadGreyComplainaints: Exception while redisReconnect: %s" % str(e), True, log_fh)
    return rediscli


def setRunning(isRunning, db, log_fh=None):
    try:
        ts = strftime("%Y-%m-%d %H:%M:%S")
        if isRunning:
            flag, tsKey = 1, DB["t1"]
        else:
            flag, tsKey = 0, DB["t2"]
        db_cursor = db.cursor()
        db_cursor.execute("INSERT INTO settings (key, value) VALUES ('{0}', '{1}'), ('{2}', '{3}') ON CONFLICT (key) DO UPDATE SET value = EXCLUDED.value WHERE settings.key = EXCLUDED.key".format(DB["key"], flag, tsKey, ts))
        db.commit()
        db_cursor.close()
    except Exception, e:
        writelog("loadGreyComplainaints: DB operation failed: %s" % str(e), fh=log_fh)


def loadGreyComplainaints(greyComplainaintsPath, log_fh=None):
    try:
        if greyComplainaintsPath:
            getPGCredentials(DB)
            db = getPGdb(DB)
            db_cursor = db.cursor()
            db_cursor.execute("SELECT value FROM settings WHERE key = '{}'".format(DB["key"]))
            try:
                row = db_cursor.fetchone()
            except:
                row = None
            isRunning = int(row[0]) if row else 0
            db_cursor.close()
            if isRunning:
                return
            setRunning(1, db, log_fh)
            redis_grey_db = redisReconnect(REDIS_GREY, log_fh=log_fh)
            tmpKey, n, buf = "{}_temp".format(REDIS_GREY["key"]), 0, []
            if redis_grey_db.exists(tmpKey):
                n = m = redis_grey_db.scard(tmpKey)
                for i in range(10):
                    sleep(3)
                    m = redis_grey_db.scard(tmpKey)
                    if n != m:
                        break
                if n == m:
                    if redis_grey_db.scard(REDIS_GREY["key"]) < 1:
                        redis_grey_db.rename(tmpKey, REDIS_GREY["key"])
                    else:
                        redis_grey_db.delete(tmpKey)
                    writelog("loadGreyComplainaints: recent loading of grey complainaints hangs, therefore we start new one")
                else:
                    writelog("loadGreyComplainaints: loading of grey complainaints is already running")
                    return
            with open(greyComplainaintsPath) as f:
                for row in f:
                    uid = row.strip()
                    if uid[:1] == '#' or not uid.isdigit():
                        continue
                    buf.append(uid)
                    n += 1
                    if n % REDIS_GREY["batch_size"] == 0:
                        redis_grey_db.sadd(tmpKey, *buf)
                        buf = []
            if n % REDIS_GREY["batch_size"] != 0:
                redis_grey_db.sadd(tmpKey, *buf)
            redis_grey_db.rename(tmpKey, REDIS_GREY["key"])
            setRunning(0, db, log_fh)
    except Exception, e:
        writelog("loadGreyComplainaints: exception while loading of grey complainaints UIDs: %s" % str(e), True, log_fh)


def main():
    cfg, errorLog = {}, None
    try:
        cfg = ConfigParser.SafeConfigParser({})
        cfg.read(INI_FILE)
    except ConfigParser.Error, e:
        writelog("loadGreyComplainaints: Loading of grey complainaints failed while parsing config file: '%s'" % str(e), True)
        sys.exit(1)
    try:
        errorLog = open(cfg.get('params', 'errorsLogFile') if cfg.has_option('params', 'errorsLogFile') else "/logs/current-special-labels-error.log", "a+t")
        loadGreyComplainaints(cfg.get("params", "grey_complainaints") if cfg.has_option("params", "grey_complainaints") else "", errorLog)
    except Exception, e:
        writelog("loadGreyComplainaints: Loading of grey complainaints failed: %s" % str(e), True)


if __name__ == '__main__':
    main()

