#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, time, json, ConfigParser
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
sys.path.insert(0, 'WORKING_DIR/web')
from datetime import datetime, timedelta
from log_utils import writelog
from db_utils import REDIS_GREY, redisReconnect
from common import default, getRobotCredentials, requestMulcaGate, isUserFromStaff, getUserInfo, getFlagsFromParams, writeComplYTlog
from email_utils import parseHeadersAsDict, getMxQueueID, getMsgTime, getRoute, getSoResolution, parseEmailAddress, sendMsgToIMAPFolder, deleteMsgsFromIMAPFolder


ROBOT = {
    "user":    "robot-markspam",
    "folders": {
        "_so_ham_plus":  "ham_plus",
        "_so_ham_minus": "ham_minus",
        "_so_spam":      "spam"
    }
}


def addHeaderSTID(msg, stid):
    return re.sub(r'^(.+?)(\r?\n\r?\n)(.+)$', r'\1\nX-Yandex-STID: {}\2\3'.format(stid), msg, 1, re.S)


class ProcessLabelActions:
    def __init__(self):
        self.cfg = None
        self.error_log = None

    def initialize(self, ini_file):
        try:
            self.cfg = ConfigParser.SafeConfigParser({})
            self.cfg.read(ini_file)
        except ConfigParser.Error, e:
            writelog("ProcessLabelActions.init: Error while parsing config file: '%s'" % str(e), True)
            sys.exit(1)
        try:
            self.error_log = open(self.cfg.get('params', 'errorsLogFile') if self.cfg.has_option('params', 'errorsLogFile') else "/logs/current-special-labels-error.log", "a+t")
            self.compldlv_ytlog = open(self.cfg.get('params', "compldlv_ytlog") if self.cfg.has_option('params', 'compldlv_ytlog') else "/logs/compldlv_yt.log", "a+t")
        except Exception, e:
            writelog("ProcessLabelActions.init: Error during initializing of worker process: %s" % str(e), True, self.error_log)
        if "ROBOT_MARKSPAM_SECRET" in os.environ:
            ROBOT["password"] = os.environ["ROBOT_MARKSPAM_SECRET"]
        else:
            getRobotCredentials(ROBOT, self.error_log)
        self.greyComplainaintsPath = self.cfg.get("params", "grey_complainaints") if self.cfg.has_option("params", "grey_complainaints") else ""
        self.redis_grey_db = redisReconnect(REDIS_GREY, self.error_log)

    def processAction(self, params, body="", method="GET"):
        action = params.get('action', [''])[0]
        uid = params.get('uid', [''])[0]
        label = params.get('label', [''])[0]
        if not uid:
            writelog("ProcessLabelActions.processAction: Unknown user - unable to verify him", False, self.error_log)
            return False
        if not isUserFromStaff(uid):
            writelog("ProcessLabelActions.processAction: User with UID=%s is not from staff - we are ignoring such user" % uid, False, self.error_log)
            return False
        if not label.startswith("_so_"):
            writelog("ProcessLabelActions.processAction: Not allowed label's name '%s' - we are ignoring such label" % label, False, self.error_log)
            return False
        if action == "lids_add" or action == "lids_del":
            if method == "GET":
                data = []
                for stid in params.get('stid', ['']):
                    data.append({"stid": stid})
                return self.doAction(action, uid, label[4:], data)
            elif method == "POST":
                data = []
                try:
                    data = json.loads(body)
                except Exception, e:
                    writelog("ProcessLabelActions.processAction: Unable to parse JSON: {}. Body: {}\n".format(str(e), body), True, log_fh=self.error_log)
                return self.doAction(action, uid, label[4:], data)
            else:
                writelog("ProcessLabelActions.processAction: Unsupported method '%s' - we are ignoring this query" % method, False, self.error_log)
                return False
        else:
            writelog("ProcessLabelActions.processAction: Unsupported action '%s' - we are ignoring such action" % action, False, self.error_log)
        return False

    def writeLogForYT(self, action, uid, folder, msgParams, msg):
        msgheader = msgbody = ""
        try:
            msgparts = re.split(r"\r?\n\r?\n", msg, 1)
            msgheader, msgbody = msgparts[0], msgparts[1]
        except Exception, e:
            writelog("writeLogForYT: Unable to parse headers and body from the message: %s. Message: %s" % (str(e), content), True, self.error_log)
        acttime = int(msgParams.get("operation_date", time.time()))
        actdatastr = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(acttime))
        headers = parseHeadersAsDict(msgheader)
        mx, queueid, cmail, sender_domain, ip, fwd = getMxQueueID(msgheader)
        msgtime = int(float(getMsgTime(headers)))
        if not msgtime and 'date' in headers:
            i = headers['date'].rfind(' ')
            if i > 18:
                msgtime = int(time.mktime((datetime.strptime(headers['date'][:i], '%a, %d %b %Y %H:%M:%S') + timedelta(hours=int(headers['date'][i+1:i+4])-3, minutes=int(headers['date'][i+4:]))).timetuple()))
        msgdatastr = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(msgtime))
        route = getRoute(msgheader, mx, "manual_selection")
        fromaddr, toaddr = parseEmailAddress(default(headers.get("from", "-"), "-")), parseEmailAddress(default(headers.get("to", "-"), "-"))
        login, uid, suid, karma = getUserInfo(uid=uid, log_fh=self.error_log)
        soRes, skipped = getSoResolution(headers, suid), "delete_label" if action == "lids_del" else ""
        if uid and str(uid) != '-':
            isGreyComplainaint = self.redis_grey_db.sismember(REDIS_GREY["key"], str(uid))
        else:
            isGreyComplainaint = 0
        logParams = {
            "source":  "manual_selection",
            "type":    "foo",
            "stid":    msgParams.get("stid", ""),
            "mid":     msgParams.get("mid", ""),
            "login":   login,
            "uid":     uid,
            "suid":    suid,
            "queueid": queueid,
            "karma":   karma,
            "seen":    ("yes" if msgParams["seen"] else "no") if "seen" in msgParams else ""
        }
        logParams["flags"] = ';'.join(getFlagsFromParams(logParams, headers, fwd, isGreyComplainaint, log_fh=self.error_log))
        writeComplYTlog(logParams, acttime, actdatastr, folder, ip, queueid, msgdatastr, soRes, fromaddr, toaddr, route=route,
                        folder=msgParams.get("folder", ""), skipped=skipped, topic="mail-so-compldlv-log", metrics=False, fh=self.compldlv_ytlog)

    def doAction(self, action, uid, folder, data):
        if not isinstance(data, list):
            return False
        success = False
        for msgParams in data:
            if "stid" not in msgParams or not msgParams["stid"]:
                continue
            content, code = requestMulcaGate(msgParams["stid"], self.error_log)
            if code == 200:
                if re.match(r'<\?xml ', content):
                    content = re.sub(r'(?s)^<\?xml.*?</message>\s+(.*)$', r'\1', content)
                if action == "lids_add":
                    msg = addHeaderSTID(content, msgParams["stid"])
                    status = sendMsgToIMAPFolder(msg, folder_name=folder, isImap=True, user=ROBOT["user"], password=ROBOT["password"], log_fh=self.error_log)
                    if status:
                        writelog("ProcessLabelActions.doAction: Adding messages result: {}".format(status), False, log_fh=self.error_log)
                self.writeLogForYT(action, uid, folder, msgParams, content)
                success = True
            else:
                writelog("ProcessLabelActions.doAction: Unable to retrieve message for stid={} from Mulca (code={}): {}".format(msgParams["stid"], code, content), False, log_fh=self.error_log)
        if action == "lids_del":
            status = deleteMsgsFromIMAPFolder([it['stid'] for it in data], folder_name=folder, user=ROBOT["user"], password=ROBOT["password"], log_fh=self.error_log)
            if status:
                writelog("ProcessLabelActions.doAction: Deleting messages result: {}".format(status), False, log_fh=self.error_log)
                return False
        return success
