#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, redis, re, time, ConfigParser, uwsgi
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
sys.path.insert(0, 'WORKING_DIR/web')
from urlparse import parse_qs
from log_utils import writelog
from common import RE
from load_grey_complainaints import loadGreyComplainaints
from spam_reports import ProcessLabelActions

INI_FILE = '%s/special-labels.ini' % os.path.dirname(os.path.abspath(__file__))
RETRY_CNT = 1


def metric_inc(metric):
    if uwsgi.mule_id() > 0:
        uwsgi.metric_inc("mule.%s.%s" % (uwsgi.mule_id(), metric))
    else:
        uwsgi.metric_inc("worker.%s.%s" % (uwsgi.worker_id(), metric))


def application(env, start_response):
    if not hasattr(application, "inited"):
        application.LA = ProcessLabelActions()
        application.LA.initialize(INI_FILE)
        application.inited = True
    params = dict(parse_qs(env['QUERY_STRING'], keep_blank_values=True))
    if len(params) < 1 and 'HTTP_REFERER' in env:
        params = dict(parse_qs(env['HTTP_REFERER'], keep_blank_values=True))
    query = re.sub(r'^/?([\w-]+)?.*$', r'\1', env['PATH_INFO'])
    request_method = env.get("REQUEST_METHOD", "")

    if query == "coworkers-selection":
        metric_inc('coworkers_selection_total')
        try:
            if request_method == "GET":
                if application.LA.processAction(params):
                    action = params.get('action', [''])[0]
                    metric_inc('coworkers_selection_' + action)
                    start_response("200 OK", [("Content-type", "text/plain")])
                else:
                    metric_inc('coworkers_selection_400')
                    start_response("400 Bad Request", [("Content-type", "text/plain")])
            elif request_method == "POST":
                body_len = int(env.get("CONTENT_LENGTH", "0"))
                if application.LA.processAction(params, env["wsgi.input"].read(body_len), "POST"):
                    action = params.get('action', [''])[0]
                    metric_inc('coworkers_selection_' + action)
                    start_response("200 OK", [("Content-type", "text/plain")])
                else:
                    metric_inc('coworkers_selection_400')
                    start_response("400 Bad Request", [("Content-type", "text/plain")])
            else:
                metric_inc('coworkers_selection_405')
                start_response("405 Method Not Allowed", [("Content-Type","text/plain")])
        except Exception, e:
            writelog("ProcessQuery exception: %s" % str(e), True, application.LA.error_log)
            metric_inc('coworkers_selection_500')
            start_response("500 Internal Server Error", [("Content-type", "text/plain")])
        return [""]

    elif query == "reload-grey-complainaints":
        loadGreyComplainaints(application.LA.greyComplainaintsPath, application.LA.error_log)

    elif query == "special-labels-ping":
        start_response("200 OK", [("Content-Type","text/plain")])
        return [""]
    else:
        start_response("404 Not Found", [("Content-Type","text/plain")])
        metric_inc('coworkers_selection_404')
        return [""]
