#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, uwsgi, json, signal, ConfigParser
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/web')
import fcntl as fcntl
from signal import signal, SIG_IGN, SIGUSR1, SIGINT, SIGHUP, SIGCHLD, SIGPIPE, SIGQUIT, SIGABRT, SIGTERM
from hashlib import md5
from time import sleep
from log_utils import writelog

LOGS = [
    ["/logs/current-nginx-so-web-80-access.log", "so_web_accesslog_80"],
    ["/logs/current-nginx-so-web-{}-access.log".format(os.environ["BSCONFIG_IPORT"]), "so_web_accesslog_{}".format(os.environ["BSCONFIG_IPORT"])]
]
SCRIPTS = {
    "active_users.py":      "active_users",
    "hooks/antifraud_rules_hook.py": "antifraud_rules_hook",
    "hooks/rules_hook.py":  "rules_hook",
    "check_rules.py":       "check_rules",
    "showrule.py":          "showrule",
    "statlog_query.py":     "statlog_query",
    "statrules.py":         "statrules",
    "stid_show.pl":         "stid_show",
    "suid_count_json.py":   "suid_count_json",
    "suid_count.py":        "suid_count",
    "users_abuse.py":       "users_abuse",
    "web_fgbd.py":          "get_by_id"
}

global accessLogParser

def gotSignal(sig, frame):
    global accessLogParser
    writelog("signal %s received: %d" % (sig, os.getpid()), True)
    if accessLogParser is not None:
        accessLogParser.isWorking = False
        accessLogParser.finalizing(accessLogParser.offsetSize)
    sys.exit(1)

def reload_config(iniFile):
    cfg = {}
    try:
        ini = ConfigParser.SafeConfigParser({"error_log": None, "threads_count": 8})
        ini.read(iniFile)
        if ini.has_option("params", "threads"):
            cfg['threads_count'] = ini.getint("params", "threads")
        cfg["error_log"] = ini.get("params", "errorlog")
    except ConfigParser.Error, e:
        writelog("Error while parsing config file: '%s'." % str(e), True)
        sys.exit(1)
    return cfg

class AccessLogParser():
    def __init__(self, cfg):
        self.LOCK = None
        self.offsetSize = 0
        self.offsetSizeNew = 0
        self.cfg = cfg.copy()
        self.errorLog = self.accessLog = None
        self.muleId = int(uwsgi.mule_id())
        try:
            self.errorLog = open(self.cfg["error_log"], "a+t")
            self.accessLogPath = LOGS[self.muleId % len(LOGS)][0]
            self.logIdText = LOGS[self.muleId % len(LOGS)][1]
            self.logId = md5("%s %s" % (self.accessLogPath, self.logIdText)).hexdigest()
            self.lockFile = "/state/{}".format(self.logId)
            self.offsetSize, self.offsetSizeNew, self.l = 0, os.stat(self.accessLogPath).st_size, len("\n")
            self.initializing()
        except Exception, e:
            self.error("AccessLogParser failed to initialize of worker thread: %s" % str(e), True)

    def error(self, msg, isTB=False):
        writelog(msg, isTB, self.errorLog, "{0} ".format(self.logIdText.upper()))

    def initializing(self):
        if os.path.isfile(self.lockFile):
            try:
                self.LOCK = open(self.lockFile, 'rt')
            except Exception, e:
                self.error("Error while opening file '%s' for reading: %s" % (self.lockFile, str(e)), True)
                sys.exit(1)
            try:
                fcntl.flock(self.LOCK, fcntl.LOCK_EX | fcntl.LOCK_NB)
            except Exception, e:
                self.error("Unable to lock file '%s': %s" % (self.lockFile, str(e)), True)
                sys.exit(1)
            s = ''
            try:
                s = self.LOCK.read()
                self.offsetSize = int(s.strip()) if s.strip() else 0
            except Exception, e:
                self.error("Invalid content of file '%s': %s" % (self.lockFile, s), True)
                self.offsetSize = 0
            fcntl.flock(self.LOCK, fcntl.LOCK_UN | fcntl.LOCK_NB)
            self.LOCK.close()
        else:
            try:
                self.LOCK = open(self.lockFile, 'wt')
            except Exception, e:
                self.error("Error while opening file '%s' for writing: %s" % (self.lockFile, str(e)), True)
                sys.exit(1)
            self.LOCK.close()
        try:
            self.LOCK = open(self.lockFile, 'r+')
        except Exception, e:
            self.error("Error while opening file '%s' for reading and writing: %s" % (self.lockFile, str(e)), True)
            sys.exit(1)
        try:
            fcntl.flock(self.LOCK, fcntl.LOCK_EX | fcntl.LOCK_NB)
        except Exception, e:
            self.error("Unable to lock file '%s': %s. Most likely process with ID '%s' already launched." % (self.lockFile, str(e), self.log_id), True)
            sys.exit(1)
        try:
            self.accessLog = open(self.accessLogPath, 'rt')
        except Exception, e:
            self.error("Error while opening input log-file '%s' for reading: %s" % (self.accessLogPath, str(e)), True)
            sys.exit(1)
        while self.offsetSizeNew > 0:
            self.offsetSizeNew -= 1
            self.accessLog.seek(self.offsetSizeNew, 0)
            s = self.accessLog.read(self.l)
            if s == "\n":
                self.offsetSizeNew += self.l
                break
        if self.offsetSizeNew < self.offsetSize:
            self.offsetSize = 0
        self.accessLog.seek(self.offsetSize, 0)

    def nextRow(self):
        if self.accessLog is not None and not self.accessLog.closed:
            while self.offsetSize < self.offsetSizeNew:
                row = self.accessLog.readline()
                if not row:
                    self.offsetSizeNew = self.offsetSize
                    break
                if self.offsetSize + len(row) >= self.offsetSizeNew:
                    self.savePosition(self.offsetSize + len(row))
                self.offsetSize += len(row)
                yield row
            self.accessLog.seek(0, 2)
            if self.offsetSizeNew != self.accessLog.tell():
                self.offsetSizeNew = self.accessLog.tell()
                if self.offsetSizeNew < self.offsetSize:
                    self.offsetSize = 0
                self.accessLog.seek(self.offsetSize, 0)
        #yield ""

    def parseRow(self, row):
        fields = row.split()
        path = fields[6][1:] if fields[6].startswith("/") else fields[6]
        code = fields[8]
        i = path.find("?")
        if i > -1:
            path = path[:i]
        if path in SCRIPTS:
            if code.isdigit():
                c = int(code)
                if 200 <= c and c < 300:
                    self.metric_inc("%s_code_2xx" % SCRIPTS[path])
                elif 300 <= c and c < 400:
                    self.metric_inc("%s_code_3xx" % SCRIPTS[path])
                elif 400 <= c and c < 500:
                    self.metric_inc("%s_code_4xx" % SCRIPTS[path])
                    if c == 403:
                        self.metric_inc("%s_code_403" % SCRIPTS[path])
                    elif c == 499:
                        self.metric_inc("%s_code_499" % SCRIPTS[path])
                elif 500 <= c:
                    self.metric_inc("%s_code_5xx" % SCRIPTS[path])
                    if c == 503:
                        self.metric_inc("%s_code_503" % SCRIPTS[path])
            self.metric_inc("%s_total" % SCRIPTS[path])

    def run(self):
        self.isWorking = True
        try:
            while self.isWorking and self.accessLog is not None:
                try:
                    for row in self.nextRow():
                        if not row:
                            if self.accessLog.closed:
                                break
                            else:
                                sleep(0.01)
                                continue
                        self.parseRow(row)
                except Exception, e:
                    self.error("AccessLogParser exception in %s: %s" % (self.muleId, str(e)), True)
            self.finalizing(self.offsetSize)
        except Exception, e:
            self.error("AccessLogParser error in %s: %s" % (self.muleId, str(e)), True)

    def metric_inc(self, metric):
        uwsgi.metric_inc("mule.%s.%s" % (self.muleId, metric))

    def savePosition(self, offset):
        try:
            if self.LOCK is not None and not self.LOCK.closed and (self.LOCK.mode.startswith('r+') or self.LOCK.mode.startswith('w')):
                self.LOCK.seek(0, 0)
                self.LOCK.write("%s" % offset)
                self.LOCK.truncate(len(str(offset)))
        except Exception, e:
            self.error("Failed to save position: %s" % str(e), True)

    def finalizing(self, offset):
        try:
            self.savePosition(offset)
            if self.LOCK is not None and not self.LOCK.closed and (self.LOCK.mode.startswith('r+') or self.LOCK.mode.startswith('w')):
                fcntl.flock(self.LOCK, fcntl.LOCK_UN | fcntl.LOCK_NB)
                self.LOCK.close()
            if hasattr(self, 'accessLog') and not self.accessLog.closed:
                self.accessLog.close()
        except Exception, e:
            self.error("Finalizing error: %s" % str(e), True)


if __name__ == "__main__":
    global accessLogParser
    signal(SIGCHLD, SIG_IGN)
    signal(SIGTERM, gotSignal)
    signal(SIGPIPE, gotSignal)
    signal(SIGQUIT, gotSignal)
    signal(SIGABRT, gotSignal)
    signal(SIGINT,  gotSignal)
    signal(SIGHUP,  gotSignal)
    cfg = reload_config(sys.argv[1])
    accessLogParser = AccessLogParser(cfg)
    accessLogParser.run()
