#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, json, uwsgi
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/web')
from cgi import parse_qs
from log_utils import writelog

ERRORLOG = "/logs/so-web-stat.log"

global errorLog, data

def application(env, start_response):
    global errorLog, data
    if not hasattr(application, "inited"):
        errorLog = open(ERRORLOG, "a+t")
        data = {}
        application.inited = True
    params = dict(parse_qs(env['QUERY_STRING'], keep_blank_values=True))
    query = re.sub(r'^/?([\w-]+)?.*$', r'\1', env['PATH_INFO'])
    request_method = env.get("REQUEST_METHOD", "")

    if query == "accumulate":
        if request_method == "POST":
            try:
                start_response("200 OK", [("Content-type", "text/plain")])
                #body_len = int(env.get("CONTENT_LENGTH", "0"))
                query = env["wsgi.input"].read()
                try:
                    metrics = json.loads(query)
                except Exception, e:
                    writelog("Failed to decode JSON with metrics: %s" % str(e), True, errorLog)
                else:
                    for metric in filter(lambda m: m.startswith('so_'), metrics['metrics']):
                        uwsgi.lock(1)
                        if metric in data:
                            data[metric] += metrics['metrics'][metric]['value']
                        else:
                            data[metric] = metrics['metrics'][metric]['value']
                        uwsgi.unlock(1)
            except Exception, e:
                writelog("Exception: %s" % str(e), True, errorLog)
                start_response("500 Internal Server Error", [("Content-type", "text/plain")])
            return [""]
        else:
            start_response("405 Method Not Allowed", [("Content-Type","text/plain")])
            return [""]

    elif query == "unistat":
        try:
            if request_method == "GET":
                start_response("200 OK", [("Content-type", "application/json")])
                signals = []
                for metric in data:
                    uwsgi.lock(1)
                    signals.append(["{0}_summ".format(metric), data[metric]])
                    data[metric] = 0
                    uwsgi.unlock(1)
                return [json.dumps(signals)]
            else:
                start_response("405 Method Not Allowed", [("Content-Type","text/plain")])
                return [""]
        except Exception, e:
            writelog("Exception: %s" % str(e), True, errorLog)
        start_response("200 OK", [("Content-Type","text/plain")])
        return [""]

    elif query == "ping":
        start_response("200 OK", [("Content-Type","text/plain")])
        return [""]

    else:
        start_response("404 Not Found", [("Content-Type","text/plain")])
        return [""]
