#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, re, json
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
from multiprocessing.pool import Pool
from datetime import datetime
from log_utils import writelog
from users_utils import STATLOG
from common import requestService, getHosts4Group

#SERVERS = ["statlog{}.so.yandex.net".format(k) for k in ['1h', '1f', '1g', '1m', '1o', '1p', '01e', '02e', '03e', '01h', '02h', '01f', '02f']]
SERVERS = STATLOG["hosts"]
SEARCH_URL_TMPL = "http://%s:5005/searchrangenew?%s"

def query((server, args)):
    search_url = SEARCH_URL_TMPL % (server, args)
    errStr = ""
    #try:
    resp, code = requestService(search_url)
    if code == 200:
        return server, resp
    else:
        errStr = "Query to '%s' failed (code=%s). Answer: '%s'." % (search_url, code, resp)
        writelog(errStr, False)
    #except Exception, e:
    #    writelog("Query to '%s' failed: %s" % (search_url, str(e)), True)
    if errStr:
        print >>sys.stderr, errStr
        sys.exit(1)
    return server, ""

form = cgi.FieldStorage()
args = form.getfirst("args", "")
route_order = {'in': 2, 'out': 1, 'corp': 0}

print "Content-Type: text/plain"
print

pool = Pool(len(SERVERS))

result = []
for server, answer in pool.map(query, zip(SERVERS, [args] * len(SERVERS))):
    if not answer:
        continue
    data, stats = json.loads(answer), {}
    for key, logs in data.iteritems():
        date, route = key[-8:], key[3:-8]
        order = route_order[route]
        if route not in stats:
            stats[route] = {}
        stats[route][date] = len(logs)
        for log in logs:
            match = re.search("mess:[^-]+-\s*(\d+):", log[:log.find("\n")])
            timestamp = int(match.group(1) if match else 0)
            result.append([date, order, timestamp, log])
    writelog("Server: %s. Args: %s. DataStats: %s." % (server, str(args), str(stats)), False)

print json.dumps(map(lambda block: block[3].encode("utf-8", "ignore"), sorted(result, reverse=True)))
