#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, subprocess, json
from urlparse import parse_qsl
from datetime import date, timedelta
from jinja2 import Environment, FileSystemLoader
from tempfile import mkstemp
from log_utils import writelog
from rules_common import RULES_TYPES, getRulesForPeriod, getRulesData, buildRulesTable

form = cgi.FieldStorage()
route, rules_par, uri = form.getfirst("route", "In"), form.getfirst("rules", ""), os.environ['SCRIPT_NAME'] if os.environ['SCRIPT_NAME'] else '/'
param = {
    'num':             0 if not form.getfirst("num") or form.getfirst("num") == 'undefined' else int(form.getfirst("num", 0)),
    'period':          3 if not form.getfirst("period") or form.getfirst("period") == 'undefined' else int(form.getfirst("period", 3)),
    'days_period':     '' if not form.getfirst("days_period") or form.getfirst("days_period") == 'undefined' else form.getfirst("days_period", ""),
    'update_rules':    'on' if not form.getfirst("update_rules") else form.getfirst("update_rules", "on"),
    'sortorder1':      'weight' if not form.getfirst("sortorder1") or form.getfirst("sortorder1") == 'undefined' else form.getfirst("sortorder1", "weight"),
    'sortorder2':      'weight' if not form.getfirst("sortorder2") or form.getfirst("sortorder2") == 'undefined' else form.getfirst("sortorder2", "weight"),
    'sortorder3':      'weight' if not form.getfirst("sortorder3") or form.getfirst("sortorder3") == 'undefined' else form.getfirst("sortorder3", "weight"),
    'choice':          1 if not form.getfirst("fields_source") else int(form.getfirst("fields_source", "1")),
    'max_rules_count': '' if not form.getfirst("max_rules_count") else int(form.getfirst("max_rules_count", 0)),
    'age_min':         '' if not form.getfirst('age_min') or form.getfirst('age_min') == 'undefined' else int(form.getfirst('age_min', 0)),
    'age_max':         '' if not form.getfirst('age_max') or form.getfirst('age_max') == 'undefined' else int(form.getfirst('age_max', 0)),
    'heavy_min':       '' if not form.getfirst('heavy_min') or form.getfirst('heavy_min') == 'undefined' else float(form.getfirst('heavy_min', 0)),
    'heavy_max':       '' if not form.getfirst('heavy_max') or form.getfirst('heavy_max') == 'undefined' else float(form.getfirst('heavy_max', 0)),
    'sp_min':          '' if not form.getfirst('percent_spam_min') or form.getfirst('percent_spam_min') == 'undefined' else int(form.getfirst('percent_spam_min', 0)),
    'sp_max':          '' if not form.getfirst('percent_spam_max') or form.getfirst('percent_spam_max') == 'undefined' else int(form.getfirst('percent_spam_max', 0)),
    'nopf_min':        '' if not form.getfirst('nopf_min') or form.getfirst('nopf_min') == 'undefined' else int(form.getfirst('nopf_min', 0)),
    'nopf_max':        '' if not form.getfirst('nopf_max') or form.getfirst('nopf_max') == 'undefined' else int(form.getfirst('nopf_max', 0)),
    'total_min':       '' if not form.getfirst('total_min') or form.getfirst('total_min') == 'undefined' else int(form.getfirst('total_min', 0)),
    'total_max':       '' if not form.getfirst('total_max') or form.getfirst('total_max') == 'undefined' else int(form.getfirst('total_max', 0)),
    'is_atomic':       '' if not form.getfirst('is_atomic') or form.getfirst('is_atomic') == 'undefined' else form.getfirst('is_atomic', ''),
    'cs_nopf_min':     '' if not form.getfirst('cmpl_spam_nopf_min') or form.getfirst('cmpl_spam_nopf_min') == 'undefined' else int(form.getfirst('cmpl_spam_nopf_min', 0)),
    'cs_nopf_max':     '' if not form.getfirst('cmpl_spam_nopf_max') or form.getfirst('cmpl_spam_nopf_max') == 'undefined' else int(form.getfirst('cmpl_spam_nopf_max', 0)),
    'ch_nopf_min':     '' if not form.getfirst('cmpl_ham_nopf_min') or form.getfirst('cmpl_ham_nopf_min') == 'undefined' else int(form.getfirst('cmpl_ham_nopf_min', 0)),
    'ch_nopf_max':     '' if not form.getfirst('cmpl_ham_nopf_max') or form.getfirst('cmpl_ham_nopf_max') == 'undefined' else int(form.getfirst('cmpl_ham_nopf_max', 0)),
    'cs_min':          '' if not form.getfirst('cmpl_spam_min') or form.getfirst('cmpl_spam_min') == 'undefined' else int(form.getfirst('cmpl_spam_min', 0)),
    'cs_max':          '' if not form.getfirst('cmpl_spam_max') or form.getfirst('cmpl_spam_max') == 'undefined' else int(form.getfirst('cmpl_spam_max', 0)),
    'ch_min':          '' if not form.getfirst('cmpl_ham_min') or form.getfirst('cmpl_ham_min') == 'undefined' else int(form.getfirst('cmpl_ham_min', 0)),
    'ch_max':          '' if not form.getfirst('cmpl_ham_max') or form.getfirst('cmpl_ham_max') == 'undefined' else int(form.getfirst('cmpl_ham_max', 0))
}
print "Content-type: text/html\r\n\r\n"

host = "%s://%s/internal/" % ('http' + ('s' if os.environ.has_key('HTTPS') else ''), os.environ['SERVER_NAME'])

rules = {}
if param['choice'] == 1 and rules_par:
    rules = getRulesForPeriod(route, {'rules': filter(lambda r: not (r is None) and re.search(r'(?!^\d+$)^[A-Z0-9_]+$', r), re.split(r'\s*[:,\s\n]+\s*', rules_par))})
elif param['choice'] == 2:
    rules = getRulesForPeriod(route, {'age_min': param['age_min'], 'age_max': param['age_max']})

ruledata = getRulesData(route, rules, param) if len(rules) > 0 else {}
all_count = len(ruledata.keys())
rul_count = len(filter(lambda r: ruledata[r]['type'] and ruledata[r]['type'] == 'rul', ruledata.keys()))
dlv_count = len(filter(lambda r: ruledata[r]['type'] and ruledata[r]['type'] == 'dlv', ruledata.keys()))
undef_count = all_count - rul_count - dlv_count
table1 = buildRulesTable(param, u"Обычные правила ({0} шт.):".format(rul_count), 'rul', param['sortorder1'], ruledata, route) if rul_count > 0 else ''
table2 = buildRulesTable(param, u"Рассылочные правила ({0} шт.):".format(dlv_count), 'dlv', param['sortorder2'], ruledata, route) if dlv_count > 0 else ''
table3 = buildRulesTable(param, u"Правила, тип которых (обычные или рассылочные) не определён ({0} шт.):".format(undef_count), 'unknown', param['sortorder3'], ruledata, route) if undef_count > 0 else ''
try:
    env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
    template = env.get_template("statrules.html.template")
    print template.render(locals()).encode("utf-8")
except Exception, e:
    writelog("Exception caught (tell developer, please): %s" % str(e), True)
