#!/usr/bin/perl -w
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
use strict;
use warnings;
use CGI;
use CGI::Carp 'fatalsToBrowser';

BEGIN { push @INC, 'WORKING_DIR', 'WORKING_DIR/SO'; }
use SO::Mail::Message;

my ($client_tvm_id, $mulcagate_tvm_id, $tvm_secret) = (2001437, 2000273, `cat WORKING_DIR/.tvm2.token`);
my ($q, $url, $script_name) = (CGI->new, 'http'.($ENV{'HTTPS'} ? 's' : '').'://'.$ENV{'SERVER_NAME'}, `basename $0`); chomp $script_name;
my %p = ('action' => $q->param('action') || 'show', 'stid' => $q->param('stid') || '', 'raw' => $q->param('raw') || '', 'uid' => $q->param('uid') || '', 'msgid' => $q->param('msgid') || '');

if ($p{'action'} eq 'show') {
    print $q->header(-type => 'text/html', -charset => 'UTF8');
    print $q->start_html(-title => 'Show message', -script => [{-type => 'text/javascript', -src => '/js/jquery/jquery.js'}, {-code => <<EOS}],
    var params = {
      stid:  '$p{stid}',
      raw:   '$p{raw}',
      uid:   '$p{uid}',
      msgid: '$p{msgid}'
    };
    function getUrlParameters() {
      window.location.search.replace(/[?&]+([^=&]+)=([^&#]*)/gi,
        function(str, key, value) {
          //params[key] = decode_utf8(value);
          params[key] = value;
        });
    }
    function setUrlParameters() {
      var s = '';
      for (var key in params) {
        if ((key == 'uid' || key == 'msgid') && params[key] == '' || key == 'action')
          continue;
        s += (s == '' ? '?' : '&') + key + "=" + params[key];
      }
      window.location.hash = '';
      if (s == window.location.search)
        location.reload(true);
      else
        window.location.search = s;
    }
    function encode_utf8(s) {
      return unescape(encodeURIComponent(s));
    }
    function decode_utf8(s) {
      return decodeURIComponent(escape(s));
    }
    getUrlParameters();
    \$(function() {
      if (params['uid'] != "" && params['msgid'] != "") {
        var msgid = encode_utf8(params['msgid']);
        \$.getJSON("$script_name?action=get_stid&uid=" + params['uid'] + '&msgid=' + msgid).done(function(data) {
          if (Array.isArray(data['hitsArray']) && data['hitsArray'].length > 0 && 'stid' in data['hitsArray'][0]) {
            params['stid'] = data['hitsArray'][0]['stid'];
            var cur_stid = \$("#stid").val();
            if (cur_stid != params["stid"]) {
                \$("#stid").val(params["stid"]);
                setUrlParameters();
            }
          } else
            alert("Unable find stid for uid=" + params['uid'] + " and msgid=" + params['msgid']);
        }).fail(function(jqxhr, textStatus, error) {
            var err = textStatus + ", " + error;
            console.log("Get stid request failed: " + err);
        });
      }
      \$("#stid").val(params["stid"]);
      \$("#raw").prop('checked', params["raw"] ? true : false);
    });
    function onShow() {
      params['stid'] = \$("#stid").val();
      params['raw'] = \$("#raw").prop('checked') ? "1" : "";
      params['uid'] = params['msgid'] = '';
      setUrlParameters();
    }
EOS
        -head => '<link rel="shortcut icon" href="/images/favicon.ico" />');
    print qq{<table width=60%><tr><td style="width: 20em;vertical-align: top;"><a href="$url}.'/internal/"><img width=90 height=90 src="/images/sign_so.gif"><img src="/images/logo.gif"></a></td>';
    print '<td align="center">&nbsp;<h2 style="white-space: nowrap;">Show message for stid</h2></td></tr></table>', $q->br;
    print $q->start_form(-method => 'post');
    print '<hr><br>Stid:&nbsp;&nbsp;';
    print $q->textfield(-id => 'stid', -name => 'stid', -value => '', -size => 100, -maxlength => 150), '&nbsp;&nbsp;';
    print $q->button(-name => 'stid_btn', -value => 'Show', -onClick => 'onShow()'), '&nbsp;&nbsp;';
    print $q->checkbox(-id => 'raw', -name => 'raw', -checked => 0, -value => 'OFF', -label => 'Raw');
    #======================
    print '<br><hr><p>';

    if ($q->param('stid')) {
        my ($stid, $raw) = ($q->param('stid'), $q->param('raw'));
        chomp $tvm_secret;
        my $ticket = `tvmknife get_service_ticket client_credentials -s $client_tvm_id -d $mulcagate_tvm_id -S $tvm_secret 2>/dev/null`;
        $ticket = $ticket ? ' -H "X-Ya-Service-Ticket: '.$ticket.'" ' : ' ';
        my $str = 'curl -k'.$ticket.'"https://figorage.mail.yandex.net:4443/gate/get/'.$stid.'?raw&service=so"';
        my $mail = qx($str);

        if ($mail) {
            $mail =~ s|^<\?xml.*?</message>\s+||s if $mail =~ /^<\?xml/;
            my $msg;
            my $mid = $1 if ($mail =~ /Message-Id:\s+<(.+?)>/im);
            print '<a href="'.$url.'/web_fgbd.py?id='.$mid.'" target="_blank">Show log by Message-ID</a><br>' if ($mid);

            my $qid = $1 if ($mail =~ /by mxfront...?\.mail\.yandex\.net \(nwsmtp\/Yandex\) with E?SMTP id\s+([-0-9a-zA-Z]{19});/);
            print '<a href="'.$url.'/web_fgbd.py?id='.$qid.'" target="_blank">Show log by QueueID</a><br>' if ($qid);
            if ($raw) {
                ($msg = $mail) =~ s/&/&amp;/g;
                $msg =~ s|^(\ +)|'&nbsp;' x length($1)|mxeg;
                $msg =~ s|^(\t+)|'&nbsp;' x length($1) x 8|mxeg;
                $msg =~ s/"/&quot;/g;
                $msg =~ s/</&lt;/g;
                $msg =~ s/>/&gt;/g;
                $msg =~ s/\r//g;
                $msg =~ s/\n/<br \/>/g;
                print '<br><div style="overflow:auto;width:95%;border:1px solid black;padding:5px;font-family:monospace;">';
            } else {
                $msg = SO::Mail::Message::convertMessage2HTML($mail, ' ', 1) or die "$!";
                print '<br><div style="overflow:auto;width:95%;border:1px solid black;padding:5px;">';
            }
            print $msg, '</div>';
        } else {
            print '<h3 style="color:#D31717">Message does not exist :(</h3>';
        }
    }
} elsif ($p{'action'} eq 'get_stid') {
    print $q->header(-type => 'application/json', -charset => 'UTF8');
    my ($uid, $msgid) = ($q->param('uid'), $q->param('msgid'));
    $msgid =~ s/([^0-9A-Za-z])/sprintf("%%%02lX",unpack('C',$1))/eg;
    my $json = `WORKING_DIR/web/get_stid.sh $uid $msgid`;
    print $json;
}
