#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, json
from time import localtime, strftime
from datetime import datetime, timedelta
from jinja2 import Environment, FileSystemLoader
from multiprocessing import Pool
from log_utils import writelog
from db_utils import getMongoDB
from users_utils import STATLOG, getUserStatsFromStatlog, getUserStatsFromSologgersIndex
from common import CFG, getHosts4Group, getUserInfo


CONCURRENCY = 20
ROUTE = "out"


if __name__ == '__main__':
    form, key_type, key = cgi.FieldStorage(), '', ''
    action, isStatlog = form.getfirst("action", "show"), form.getfirst("statlog", "")
    uid, suid, login = form.getfirst("uid", ""), form.getfirst("suid", ""), form.getfirst("login", "")
    if uid:
        key_type, key = 'uid', uid
    elif suid:
        key_type, key = 'suid', suid
    elif login:
        key_type, key = 'login', login
    else:
        key_type, key = form.getfirst("key_type", ""), form.getfirst("key", "")
    if key_type == "uid":
        uid, suid, login = getUserInfo(uid=key)
    elif key_type == "suid":
        uid, suid, login = getUserInfo(suid=key)
    elif key_type == "login":
        uid, suid, login = getUserInfo(login=key)
    if action == 'show':
        stat = {}
        writelog("SUID count: uid = %s, suid = %s, login = %s" % (uid, suid, login), False)
        if key:
            today = datetime.today()
            for i in xrange(-CFG["sologger"]["saving_days"][ROUTE], 1):
                date = today + timedelta(days=i)
                stat[date.strftime("%Y-%m-%d")] = {"1": 0, "2": 0, "4": 0, "256": 0}
            if isStatlog and isStatlog.isdigit() and int(isStatlog) > 0 and (uid or suid):
                pool = Pool(CONCURRENCY)
                #hosts = getHosts4Group(STATLOG['cluster'], STATLOG['hosts'])
                hosts = STATLOG['hosts']
                cond = {"uid": uid} if uid else {"suid": suid}
                for machine in hosts:
                    queries = []
                    for i in xrange(-CFG["sologger"]["saving_days"][ROUTE], 1):
                        date = today + timedelta(days=i)
                        queries.append([cond, machine, date, ROUTE])
                    for partial_stat in pool.map(getUserStatsFromStatlog, queries, 1):
                        for date, date_stat in partial_stat.iteritems():
                            for code, count in date_stat.iteritems():
                                stat[date][code] += count
            elif uid:
                getUserStatsFromSologgersIndex(uid, stat, route=ROUTE)
            else:
                writelog("Unable find nor UID, nor SUID!", False)

        print "Content-type:text/html\r\n\r\n"
        try:
            env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
            template = env.get_template("suid_count.html.template")
            rows = []
            for date, counts in sorted(stat.iteritems()):
                rows.append({"date": date, "r1": counts["1"], "r2": counts["2"], "r4": counts["4"], "r255": counts["256"],
                        "total": counts["1"] + counts["2"] + counts["4"] + counts["256"]})

            print template.render(uid=uid, suid=suid, login=login, rows=rows).encode("utf-8")
        except Exception, e:
            writelog("Exception caught (tell developer, please): %s" % str(e), True)

    elif action == 'getinfo':
        print "Content-type: application/json\r\n\r\n"
        info = getUserInfo(uid=uid, suid=suid, login=login)
        print json.dumps({'uid': info[0], 'suid': info[1], 'login': info[2]})

    else:
        print "Content-type:text/html\r\n\r\n"
        try:
            env = Environment(loader = FileSystemLoader("WORKING_DIR/web/internal"))
            print env.get_template("suid_count.html.template").render(uid='', suid='', login='', rows=[]).encode("utf-8")
        except Exception, e:
            writelog("Exception caught (tell developer, please): %s" % str(e), True)
