#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
from datetime import datetime, timedelta
from jinja2 import Environment, FileSystemLoader
from multiprocessing import Pool
from log_utils import writelog
from users_utils import STATLOG, getUserStatsFromStatlog, getUserStatsFromSologgersIndex
from common import CFG, getHosts4Group, getUserInfo


CONCURRENCY = 20
ROUTE = "out"


if __name__ == '__main__':
    form, key, stat = cgi.FieldStorage(), '', {}
    uid, suid, login, isStatlog = form.getfirst("uid", ""), form.getfirst("suid", ""), form.getfirst("login", ""), form.getfirst("statlog", "")
    if uid:
        key_type, key = 'uid', uid
    elif suid:
        key_type, key = 'suid', suid
    elif login:
        key_type, key = 'login', login
    print "Content-type: application/json\r\n\r\n"
    if key:
        if key_type == "uid":
            uid, suid, login = getUserInfo(uid=key)
        elif key_type == "suid":
            uid, suid, login = getUserInfo(suid=key)
        elif key_type == "login":
            uid, suid, login = getUserInfo(login=key)
        writelog("SUID count json: uid = %s, suid = %s, login = %s" % (uid, suid, login), False)
        today = datetime.today()
        for i in xrange(-CFG["sologger"]["saving_days"][ROUTE], 1):
            date = today + timedelta(days=i)
            stat[date.strftime("%Y-%m-%d")] = {"1": 0, "2": 0, "4": 0, "256": 0}
        if isStatlog and isStatlog.isdigit() and int(isStatlog) > 0 and (uid or suid):
            pool = Pool(CONCURRENCY)
            cond = {"uid": uid} if uid else {"suid": suid}
            #hosts = getHosts4Group(STATLOG['cluster'], STATLOG['hosts'])
            hosts = STATLOG['hosts']
            for machine in hosts:
                queries = []
                for i in xrange(-CFG["sologger"]["saving_days"][ROUTE], 1):
                    date = today + timedelta(days=i)
                    queries.append([cond, machine, date, ROUTE])
                for partial_stat in pool.map(getUserStatsFromStatlog, queries, 1):
                    for date, date_stat in partial_stat.iteritems():
                        for code, count in date_stat.iteritems():
                            stat[date][code] += count
        elif uid:
            getUserStatsFromSologgersIndex(uid, stat, route=ROUTE)
        else:
            writelog("Unable find nor UID nor SUID!", False)
    print "{"
    for i, (date, counts) in enumerate(sorted(stat.iteritems(), cmp=lambda x, y: cmp(x[0], y[0])), start=1):
        print "\"{}\":{}{}".format(date, str({"R1": counts["1"], "R2": counts["2"], "R4": counts["4"], "R255": counts["256"], "Total": counts["1"] + counts["2"] + counts["4"] + counts["256"]}).replace("\'", "\""), "," if i < len(stat) else "")
    print "}"
