# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from django.conf import settings
from django.contrib import admin
from django.conf.urls.static import static
from django.urls import path, include

from . import views

urlpatterns = [
    path('ping',                  views.ping),
    path('unistat',               views.unistat),
    path('admin/',                admin.site.urls),
    path(settings.IDM_URL_PREFIX, include('django_idm_api.urls')),
    path('',                      include('mail.so.spamstop.web.ui.web_tools.urls')),
]

urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
