# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from django.http import HttpResponse
from django.views.decorators.http import require_GET
from infra.yasm.unistat import global_unistat


PONG = HttpResponse("pong")


@require_GET
def ping(request, *args, **argv):
    return PONG


@require_GET
def unistat(request):
    return HttpResponse(global_unistat.to_json(), content_type='text/json')
