# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import sys
# import importlib
import logging
import re
from socket import getfqdn
from tvmauth import BlackboxTvmId
from library.python.django.utils import patch_settings_for_arcadia


ENV_TYPE = os.getenv('ENV_TYPE', os.getenv('YENV_TYPE', 'production'))
LOGGER = logging.getLogger(__name__)
PROJECT_PATH = '{arcadia_path}'.format(arcadia_path=os.getenv('ARCADIA_PATH'))
LOG_DIR = os.getenv("LOG_DIR", "/logs")
ROOT_DIR = os.path.abspath(os.getenv("ROOT_DIR", os.getenv("WORKING_DIR", ".")))
WORK_DIR = os.getcwd()
CFG = {
    # General settings
    'root_url':         '',
    'logfile':          f'{LOG_DIR}/so-web.log',
    'nginx_folder':     ROOT_DIR,
    'tmp_dir':          f'{ROOT_DIR}/temp',
    'retry_cnt':        3,
    # Sologger settings
    'sologger': {
        "host":         "logger.so.yandex-team.ru" if ENV_TYPE == "production" else "logger-testing.so.yandex-team.ru",
        "uri":          "/search?",
        "index_uri":    "/unprefixed-parallel/search?",
        "saving_days": {
            "in":       14,
            "out":      21,
            "corp":     30
        },
        "timeout":      58.0,
    },
    # Rules & rules' readers settings
    'rules_check_tmp_dir':  f'{ROOT_DIR}/temp/check_rules',
    "so_rules": {
        'folder_name':      'so_rules_checked',
        "folder":           f'{ROOT_DIR}/so_rules_checked/',
        'reader_path':      f'{ROOT_DIR}/Reader',
        'ini_folder':       f'{ROOT_DIR}'
    },
    "af_rules": {
        "folder_name":      'af_rules_checked',
        "folder":           f'{ROOT_DIR}/af_rules_checked/',
        "reader_path":      f'{ROOT_DIR}/web/hooks/antifraud_rules_reader.sh',
        "submodules":  {
            "auth":          u"Авторизации",
            "autoru":        u"Авто.ру",
            "bank":          u"Банк",
            "beru":          u"Беру",
            "bnpl":          u"BNPL",
            "browser":       u"Браузер",
            "cloud":         u"Облако",
            "connect":       u"Коннект",
            "direct":        u"Директ",
            "disk":          u"Диск",
            "dostavka":      u"Логистика",
            "drive":         u"Драйв",
            "edadeal":       u"Едадил",
            "eda_lavka":     u"Еда&Лавка",
            "games":         u"Игры",
            "help_nko":      u"Помощь",
            "invest":        u"Инвестиции",
            "market":        u"Маркет",
            "market_bnpl":   u"Маркет.Рассрочки",
            "media":         u"Медиа",
            "maps_payments": u"Карты/657.Купоны",
            "obyavleniya":   u"Объявления",
            "oplata":        u"Оплата",
            "passport":      u"Паспорт",
            "praktikum":     u"Практикум",
            "realty":        u"Недвижимость",
            "samokat":       u"Самокат",
            "sprav":         u"Справка",
            "station":       u"Станция",
            "surveys":       u"Взгляд",
            "taxi":          u"Такси",
            "telephony":     u"Телефония",
            "telemedicine":  u"Телемедицина",
            "test":          u"Тест",
            "toloka":        u"Толока",
            "translate":     u"Переводчик",
            "travel":        u"Путешествия",
            "uslugi":        u"Услуги",
            "yandex_pay":    u"Pay",
            "yandex_plus":   u"Плюс",
            "zapravki":      u"Заправки",
            "zen":           u"Дзен"
        }
    },
    # Some predefined emails
    'robot': {
        "name":            'Robot Mailspam <robot-mailspam@yandex-team.ru>',
        "login":           'robot-mailspam',
        "user":            'robot-mailspam@yandex-team.ru',
        "password":        ''
    },
    'report':              'so-report@yandex-team.ru',
    # SMTP settings
    'smtp': {
        'host':            'outbound-relay.yandex.net',
        'port':            25,
        'timeout':         5.0
    },
    # IMAP settings
    'imap_corp': {
        'in_host':         'imap.yandex-team.ru',
        'in_port':         993,
        'out_host':        'smtp.yandex-team.ru',
        'out_port':        465,
        'folder':          'so-spam-report'
    },
    # MulcaGate settings
    'mulca_gate': {
        "url":    "https://storage.mail.yandex.net:4443/gate/get/",
        "tvm_id": 2000273,
    },
    # Some subsystems' info
    'showrule': {
        'path': 'showrule',
    },
    'statrules': {
        'path': 'statrules',
    },
    'plotnik': {
        'path': 'plotnik',
    },
    'users_abuse': {
        'path': 'users_abuse',
    },
}
CFG["so_rules"]["check_lock_path"] = f"{CFG['rules_check_tmp_dir']}/check_rules.lock"
CFG["af_rules"]["check_lock_path"] = f"{CFG['rules_check_tmp_dir']}/check_af_rules.lock"
RE = {
    "domain":           re.compile(r"(?:(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?|xn\-\-[a-z0-9-]+)\.)+(?:xn\-\-[a-z0-9-]+|[a-z]+)", re.I),
    "ip":               re.compile(r"[\d:\.a-f]+", re.I),
    "yandex_domain":    re.compile(r"(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\.)*\b(?:yandex|ya|narod|yandex-team)\.(?:[a-z]{2,4}|yandex)", re.I),
    "yandex_net":       re.compile(r".*\.yandex\.net\b", re.I),
    "url":              re.compile(r"https?:\/\/[^\s\"\'\*]+[^\s\"\'\*\.\:\+]"),
    "rules_folder":     re.compile(r" (\/\S+?\/){}\/".format(CFG['so_rules']['folder_name'])),
    "rules_timestamp":  re.compile(r"\s*[A-Za-z]{3}\s+\d+\s+\d\d:\d\d:\d\d(?:\.\d+)\s+\-\s+\[\d+\]\s+"),
    "rules_timestamp2": re.compile(r"\s*\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.\d+)\+\d+\[\d+\]\s+"),
    "rules_results":    re.compile(r"(.*?(?:All|Err|Rules cs:).*?)"),
    "rule_weight":      re.compile(r"^([A-Z0-9_]+)(?:\s+.*)?\s+([\-0-9\.]+)\s*$"),
    "bash_trace":       re.compile(r'^\++?\s+.*$', re.M),
    "exception":        re.compile(r'\n((?:Exception |Caused by:)[^\n]+\n(\s+[^\n]+\n)+)', re.S)
}
RE['email'] = re.compile(r"[\w\+\-\.]+\@{}".format(RE['domain'].pattern), re.I)
RE['safe_email'] = re.compile(r"[^\"@<>,\s]+@{}".format(RE['domain'].pattern), re.I)
RE['yandex_email'] = re.compile(r"[\w\+\-\.]+\@{}".format(RE['yandex_domain'].pattern), re.I)
DB = {
    "complaints": {
        "host": "iva-xb3w4z7jjjpuf8sd.db.yandex.net,myt-3mdnt0clvntgeqmv.db.yandex.net,sas-5nnjcnus304urap7.db.yandex.net",
        "port": 6432,
        "db":   "complaints",
        "user": "cmpl",
        "db_type": 'pgdb'
    },
    "rules": {
        'db':    'rules',
        'hosts': 'vla-hwmeehtmq450wvke.db.yandex.net,sas-agixxin7fbr78u0o.db.yandex.net,vlx-g9q00jkxh959zk6m.db.yandex.net',
        'port':  27018,
        'user':  'solog',
        'errorsLogFile': '/logs/so-web.log',
        'timeout': 120000,
        'db_type': 'mongodb'
    },
    "users_stat": {
        "cluster_name":  "users_stat",
        "hosts":         ['sas-667541avf1c1ontn.db.yandex.net', 'vla-9cp0yx8ud9yrt90n.db.yandex.net'],
        "port":          6379,
        "sentinel_port": 26379,
        "db":            0,
        "timeout":       3.0,
        "auth":          True,
        'db_type':       'redisdb'
    }
}

# try:
#    from library.python.django.utils import patch_settings_for_arcadia
#    ARCADIA_RUN = True
# except ImportError:
#    ARCADIA_RUN = False

# if ARCADIA_RUN:
#    BASE_DIR = Path(sys.executable).parent
# else:
#    BASE_DIR = Path(__file__).absolute().parent.parent

# Если используется встроенная в Django система локализации,
# может понадобиться указать LOCALE_PATHS в settings.py проекта следующим образом:
from library.python.django.locales import extract_locales


LOCALE_PATHS = extract_locales({'ru'})

WEB_TOOLS_HOST = 'web.so.yandex-team.ru'
ALLOWED_HOSTS = [WEB_TOOLS_HOST, 'so-web.n.yandex-team.ru', getfqdn()]
DEBUG = os.getenv("DEBUG", "0") == "1"
if DEBUG:
    ALLOWED_HOSTS += ['.localhost', '127.0.0.1', '[::]']
DEBUG_AUTH = os.getenv("DEBUG_AUTH", "0") == "1"
FORCE_USER = os.getenv("FORCE_USER")

TVM_ALLOWED_CLIENTS_FROM = os.getenv("TVM_ALLOWED_CLIENTS_FROM", "tvm_config.json")
TVM_API_CHECK = os.getenv("TVM_API_CHECK", "1") == "1"
TVM_CLIENT_ID = int(os.getenv("TVM_ID", os.getenv("TVM_CLIENT_ID", "2001437")))
TVM_SECRET = os.getenv("TVM_SECRET")
SENDERS_TVM_ID = int(os.getenv("SENDERS_TVM_ID", "2000031"))

USE_TZ = True
TIME_ZONE = "Europe/Moscow"
DATETIME_FORMAT = "Y-m-d H:i:s"

__all__ = [
    'ENV_TYPE', 'DEBUG', 'PROJECT_PATH', 'CFG', 'RE', 'LOCALE_PATHS', 'ALLOWED_HOSTS', 'DEBUG_AUTH', 'WEB_TOOLS_HOST',
    'FORCE_USER', 'DB', 'TVM_CLIENT_ID', 'TVM_ALLOWED_CLIENTS_FROM', 'TVM_API_CHECK', 'TVM_SECRET', 'SENDERS_TVM_ID',
    'USE_TZ', 'TIME_ZONE', 'DATETIME_FORMAT',
]

# ========== TVM django-idm-api
# https://wiki.yandex-team.ru/intranet/idm/api/django/

from django_idm_api.settings import (
    IDM_INSTANCE,
    IDM_TVM_CLIENT_ID,
    IDM_URL_PREFIX,
    IDM_ENVIRONMENT_TYPE,
    IDM_API_TVM_DEFAULTS
)

IDM_API_TVM_SETTINGS = {
    "client_id": TVM_CLIENT_ID,
    "allowed_clients": (TVM_CLIENT_ID, IDM_TVM_CLIENT_ID),
    "secret": TVM_SECRET,
}
ROLES_HOOKS = "mail.so.spamstop.web.ui.web_tools.libs.IdmHooks"

# ========== django_yauth
from django_yauth.settings import *  # noqa
from django_yauth.settings import blackbox, YAUTH_AVAILABLE_TLDS

blackbox.BLACKBOX_URL = "https://blackbox.yandex-team.ru/blackbox/"
YAUTH_USE_SITES = True

YAUTH_TVM2_BLACKBOX_CLIENT = BlackboxTvmId.ProdYateam
YAUTH_BLACKBOX_CONSUMER = 'soweb'
YAUTH_TVM2_CLIENT_ID = TVM_CLIENT_ID
YAUTH_TVM2_SECRET = TVM_SECRET
YAUTH_USE_TVM2_FOR_BLACKBOX = True
YAUTH_TVM2_ALLOWED_CLIENT_IDS = [
    IDM_TVM_CLIENT_ID
]
YAUTH_TEST_USER = FORCE_USER
YAUTH_TVM2_DISK_CACHE_DIR = f"{ROOT_DIR}/temp"
YAUTH_AVAILABLE_TLDS += [".net"]

if DEBUG_AUTH:
    AUTHENTICATION_BACKENDS = [
        "django_yauth.authentication_mechanisms.dev.UserFromHttpHeaderAuthBackend",
        "django_yauth.authentication_mechanisms.dev.UserFromCookieAuthBackend",
        "django_yauth.authentication_mechanisms.dev.UserFromOsEnvAuthBackend",
    ]
else:
    AUTHENTICATION_BACKENDS = [
        "django_yauth.authentication_mechanisms.cookie.Mechanism",
        "django_yauth.authentication_mechanisms.oauth.Mechanism",
        "django_yauth.authentication_mechanisms.tvm.Mechanism",
    ]
# =============================================================================

__all__ += [
    'IDM_INSTANCE', 'IDM_TVM_CLIENT_ID', 'IDM_URL_PREFIX', 'IDM_ENVIRONMENT_TYPE', 'IDM_API_TVM_DEFAULTS',
    'IDM_API_TVM_SETTINGS', 'ROLES_HOOKS', 'YAUTH_TYPE', 'YAUTH_USE_SITES', 'YAUTH_TVM2_BLACKBOX_CLIENT',
    'YAUTH_AVAILABLE_TLDS', 'YAUTH_TVM2_CLIENT_ID', 'YAUTH_TVM2_SECRET', 'YAUTH_USE_TVM2_FOR_BLACKBOX',
    'YAUTH_TVM2_ALLOWED_CLIENT_IDS', 'YAUTH_TEST_USER', 'YAUTH_TVM2_DISK_CACHE_DIR', 'YAUTH_BLACKBOX_CONSUMER',
]

# =============================================================================
# Import all other settings which are specific to the environment

# env_all = importlib.import_module(f'mail.so.spamstop.web.ui.settings.{ENV_TYPE}')
# __all__ += env_all.__all__
# globals().update(env_all.__dict__)

if ENV_TYPE == 'production':
    from .production import *   # noqa
    from .production import (WEB_TOOLS_VERSION, ALLCAS_CERT_PATH, SSL_CONTEXT, SOSEARCH_HOST, SOSEARCH_TIMEOUT,
                             SOLOGGER_HOST, SOLOGGER_TIMEOUT, IDM_TVM_CLIENT_ID, INSTALLED_APPS, MIDDLEWARE,
                             DB_HOSTS, DB_NAME, DB_USER, DB_PASSWORD, DB_PORT, DB_CERT_PATH, DATABASES, YAUTH_TYPE)
else:
    from .testing import *      # noqa
    from .testing import (WEB_TOOLS_VERSION, ALLCAS_CERT_PATH, SSL_CONTEXT, SOSEARCH_HOST, SOSEARCH_TIMEOUT,
                          SOLOGGER_HOST, SOLOGGER_TIMEOUT, IDM_TVM_CLIENT_ID, INSTALLED_APPS, MIDDLEWARE,
                          DB_HOSTS, DB_NAME, DB_USER, DB_PASSWORD, DB_PORT, DB_CERT_PATH, DATABASES, YAUTH_TYPE)

__all__ += [
    'WEB_TOOLS_VERSION', 'ALLCAS_CERT_PATH', 'SSL_CONTEXT', 'SOSEARCH_HOST', 'SOSEARCH_TIMEOUT', 'SOLOGGER_HOST',
    'SOLOGGER_TIMEOUT', 'IDM_TVM_CLIENT_ID', 'DB_HOSTS', 'DB_NAME', 'DB_USER', 'DB_PASSWORD', 'DB_PORT',
    'DB_CERT_PATH', 'DATABASES', 'INSTALLED_APPS', 'MIDDLEWARE', 'YAUTH_TYPE',
]

# LOGGER.warning(f"All env.vars: {__all__}")

# ========== Django global settings

SITE_ID = 1
# ALLOWED_HOSTS = [
#    "*"
# ]
FORM_RENDERER = "library.python.django.template.backends.forms_renderer.ArcadiaRenderer"

ROOT_URLCONF = 'mail.so.spamstop.web.ui.cmd.urls'

REST_FRAMEWORK = {
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
    'PAGE_SIZE': 10
}

__all__ += ['LOG_DIR', 'ROOT_DIR', 'WORK_DIR', 'ROOT_URLCONF', 'REST_FRAMEWORK', 'SITE_ID', 'FORM_RENDERER', ]

# ==== Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.2/howto/static-files/

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

SECRET_KEY = "MyLongAndSecretCorrectHorseBatteryStaple37WebToolsDjango777"
STATIC_URL = "/static/"
STATIC_ROOT = os.path.join(ROOT_DIR, "web_tools_static")

LOGGER.warning(f"Arcadia's path: {PROJECT_PATH}. Static root: {STATIC_ROOT}.")

STATICFILES_DIRS = [
]

__all__ += ['STATICFILES_FINDERS', 'SECRET_KEY', 'STATIC_URL', 'STATIC_ROOT', 'STATICFILES_DIRS', ]

# ==== Other settings
from django.utils.html import format_html
from django.utils.safestring import mark_safe


class InvalidStringShowWarning(str):
    styles = mark_safe('style="color: red; font-weight: bold;"')

    def __mod__(self, other):
        if DEBUG is True:
            msg = f"In template, undefined variable or unknown value for: '{other}'"
            LOGGER.warning(msg)
        return format_html('<i {}>{}</i>', self.styles, msg)

    def __bool__(self):
        # make the template tag `default` use its fallback value
        return False


FIXTURE_DIRS = ['common_fixtures']

TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': DEBUG,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django_yauth.context.yauth',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
#            'string_if_invalid': InvalidStringShowWarning('%s'),
        },
    }
]

MIGRATION_MODULES = {'web_tools': 'mail.so.spamstop.web.ui.web_tools.migrations'}

__all__ += ['FIXTURE_DIRS', 'TEMPLATES', 'MIGRATION_MODULES', ]

# ========== Logging

LOG_FORMAT = os.environ.get('QLOUD_LOGGER_STDOUT_PARSER', 'default')
LOG_PATH = os.getenv("LOG_PATH")
if LOG_PATH:
    logHandler = {
        "class": "logging.handlers.RotatingFileHandler",
        "filename": LOG_PATH,
        "formatter": "main"
    }
else:
    logHandler = {
        "class": "logging.StreamHandler",
        "formatter": "main"
    }

LOGGING = {
    "version": 1,
    "disable_existing_loggers": False,
    "formatters": {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
        'main': {
            'format': '{name} {levelname} {asctime} {module} {pathname}:{lineno} {message}',
            'style': '{',
        },
    },
    "handlers": {
        'stdout': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
        },
        'stderr': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stderr,
        },
        'django.server': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
        },
        'file': logHandler,
        "main": logHandler
    },
    'loggers': {
        '': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': True,
        },
        'requests': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.request': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.server': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.template': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.DisallowedHost': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.DisallowedModelAdminLookup': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.DisallowedModelAdminToField': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.DisallowedRedirect': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.InvalidSessionKey': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.RequestDataTooBig': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.SuspiciousFileOperation': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.SuspiciousMultipartForm': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.SuspiciousSession': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.TooManyFieldsSent': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'django.security.csrf': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
        'tvm2.aio.base': {
            'handlers': ['main', 'stdout', 'stderr'],
            'propagate': False,
        },
    },
#    "root": {
#        "handlers": ["stdout", "stderr", "main"],
#        "level": os.getenv("DJANGO_LOG_LEVEL", "DEBUG" if DEBUG else "INFO"),
#    },
}

__all__ += ['LOG_FORMAT', 'LOG_PATH', 'LOGGING', ]

# =============================================================================

patch_settings_for_arcadia()
