# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import logging
import os
import ssl
from django_pgaas import HostManager


LOGGER = logging.getLogger(__name__)
WEB_TOOLS_VERSION = int(os.getenv("WEB_TOOLS_VERSION", "v2")[1:])
ALLCAS_CERT_PATH = os.getenv("ALLCAS_CERT_PATH")
SSL_CONTEXT = ssl.create_default_context(cafile=ALLCAS_CERT_PATH) if ALLCAS_CERT_PATH else None

SOSEARCH_HOST = os.getenv('SOSEARCH_HOST', "http://sosearch-proxy.mail.yandex.net:80")
SOSEARCH_TIMEOUT = int(os.getenv('SOSEARCH_TIMEOUT', 1))

SOLOGGER_HOST = os.getenv('SOLOGGER_HOST', "http://logger.so.yandex-team.ru:80")
SOLOGGER_TIMEOUT = int(os.getenv('SOLOGGER_TIMEOUT', 1))

__all__ = [
    'WEB_TOOLS_VERSION', 'ALLCAS_CERT_PATH', 'SSL_CONTEXT', 'SOSEARCH_HOST', 'SOSEARCH_TIMEOUT',
    'SOLOGGER_HOST', 'SOLOGGER_TIMEOUT',
]

# ========== django_yauth

YAUTH_TYPE = 'intranet'

__all__ += ['YAUTH_TYPE', ]

# ========== TVM django-idm-api
# https://wiki.yandex-team.ru/intranet/idm/api/django/

IDM_TVM_CLIENT_ID = 2001600
IDM_INSTANCE = "production"

__all__ += ['IDM_TVM_CLIENT_ID', 'IDM_INSTANCE', ]


# ========== DB settings

def parse_geo_host(geo_host):
    host, geo = geo_host.rsplit(':', 1)
    return {
        "name": host,
        "options": {"geo": geo, "type": "postgresql"},
    }


DB_HOSTS = [
    parse_geo_host(get_host) for get_host in os.getenv(
        "DB_HOSTS",
        "sas-cg74eq1libzyqcxu.db.yandex.net:27018;vla-mo8his6q9hiw24mn.db.yandex.net:27018"
    ).split(";")
]

manager = HostManager.create_from_yc(DB_HOSTS)

LOGGER.info("host_string:" + manager.host_string)

DB_NAME = os.getenv("DB_NAME", 'web-tools-ui')
DB_USER = os.getenv("DB_USER", 'web-tools-user')
DB_PASSWORD = os.getenv("DB_PASSWORD")
DB_PORT = int(os.getenv("DB_PORT", 6432))
DB_CERT_PATH = os.getenv("DB_CERT_PATH", ALLCAS_CERT_PATH)

if not DB_PASSWORD:
    raise RuntimeError('No DB_PASSWORD supplied')

DATABASES = {
    'default': {
        'ENGINE': 'django_pgaas.backend',
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASSWORD,
        'HOST': manager.host_string,
        'PORT': DB_PORT,
        'OPTIONS': {
            'sslmode': 'verify-full',
            'target_session_attrs': 'read-write',
            'sslrootcert': DB_CERT_PATH
        },
    }
}

__all__ += ['DB_HOSTS', 'DB_NAME', 'DB_USER', 'DB_PASSWORD', 'DB_PORT', 'DB_CERT_PATH', 'DATABASES', ]

# ==== Other settings

INSTALLED_APPS = [
    'rest_framework',
    'django_yauth',
    'django_idm_api',
    'django.contrib.sites',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_pgaas',
    'mail.so.spamstop.web.ui.web_tools',
    'django_template_common',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
#    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django_idm_api.middleware.TVMMiddleware',
]

__all__ += ['INSTALLED_APPS', 'MIDDLEWARE', ]
