# -*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import re
import logging
import requests
import sys
from .IPy import IP
from random import randrange
from base64 import urlsafe_b64encode
from traceback import format_exception
from django.conf import settings

LOGGER = logging.getLogger(__name__)


def getUUID(sep='-'):
    if not sep:
        sep = '-'
    chars, s = ['a', 'b', 'c', 'd', 'e', 'f', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], []
    for i in range(32):
        s.append(chars[int(randrange(16))])
    s.insert(8,  sep)
    s.insert(13, sep)
    s.insert(18, sep)
    s.insert(23, sep)
    return ''.join(s)


def get_traceback(exc_type, exc_value, exc_traceback) -> str:
    tb = ''
    if exc_type or exc_value or exc_traceback:
        for step in format_exception(exc_type, exc_value, exc_traceback):
            try:
                tb += "\t" + step.strip() + "\n"
            except:
                pass
    return tb


def getTraceback() -> str:
    exc_type, exc_value, exc_traceback = sys.exc_info()
    return get_traceback(exc_type, exc_value, exc_traceback)


def encodeBase64Url(s: str) -> str:
    es = ''
    try:
        es = urlsafe_b64encode(bytes(s, encoding="utf-8"))
    except Exception as e:
        LOGGER.error(f"Error while encoding string '{s}': {e}.\t{getTraceback()}")
    return re.sub(r'=[-]*\Z', r'', es.decode('utf-8'))


def isCorp(uid: str | int) -> bool:
    return str(uid).startswith("112000") and len(str(uid)) == 16


def ipReverse(ipstr: str) -> str:
    ip = IP(ipstr)
    if not ip:
        return None
    return re.sub(r'\.(?:in\-addr|ip6)\.arpa\.', r'', ip.reverseName())


def getNannyInstances(service: str, default_hosts: list = []) -> list:
    try:
        url = f"https://nanny.yandex-team.ru/v2/services/{service}/current_state/instances/"
        with requests.Session() as session:
            for i in range(settings.CFG['retry_cnt']):
                with session.get(url) as response:
                    if response.status_code == 200:
                        info = response.json()
                        return map(lambda item: item['container_hostname'], info['result'])
                    else:
                        LOGGER.error("Query to Sologger's index ({}) failed with code={}: {}".format(
                            url, response.status_code, response.reason))
                        continue
    except Exception as e:
        LOGGER.error(f"getNannyInstances exception: {e}.\t{getTraceback()}")
    return default_hosts
