# -*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#

class BaseWebToolsException(Exception):
    status_code = 500
    code = 'unknown_exception'

    def __init__(self, **kwargs):
        self.context = kwargs

    def to_json(self):
        return {
            'error': self.code,
            'context': self.context
        }


class FailedDependencyException(BaseWebToolsException):
    status_code = 424

    def __init__(self, service_slug: str):
        super().__init__()
        self.code = f'{service_slug}_failed'
