# -*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import os
import os.path
import logging
import pymongo
from django.conf import settings

LOGGER = logging.getLogger(__name__)


def mongoConnStr(cfg, log_fh=None):
    s = ''
    if 'user' in cfg and cfg['user']:
        s = f"{cfg['user']}:{cfg['passwd']}@"
    return "mongodb://{}{}/{}".format(s, ','.join(cfg['hosts'] if isinstance(cfg['hosts'], list) else cfg['hosts'].split(',')), cfg['db'])


def loadMongoDbCredentials(cfg):
    f, CURDIR = None, f'{settings.ROOT_DIR}'
    try:
        if not os.path.exists(f"{CURDIR}/.mongodb.{cfg['db']}"):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists(f"{CURDIR}/.mongodb.{cfg['db']}") and 'HOME' in os.environ:
                CURDIR = '/root'
        if os.path.exists(f"{CURDIR}/.mongodb.{cfg['db']}"):
            f = open(f"{CURDIR}/.mongodb.{cfg['db']}")
            for line in f:
                sf = line.split(':')
                if len(sf) == 2:
                    cfg['user'], cfg['passwd'] = sf[0], sf[1].strip()
                    break
            f.close()
            if cfg.get('ssl', False):
                CURDIR = f'{settings.ROOT_DIR}'
                if not os.path.exists(f'{CURDIR}/allCAs.pem'):
                    CURDIR += '/.mongodb'
                    if not os.path.exists(f'{CURDIR}/allCAs.pem'):
                        CURDIR = os.path.dirname(os.path.abspath(__file__))
                if os.path.exists(f'{CURDIR}/allCAs.pem'):
                    cfg['ssl_ca_certs'] = f'{CURDIR}/allCAs.pem'
            else:
                cfg['ssl'] = False
        elif 'user' in cfg:
            LOGGER.error("ERROR: Unable to locate file with DB credentials!")
    except Exception as e:
        LOGGER.error(f"loadMongoDbCredentials exception: {e}")


def getMongoDB(cfg, mode='read-write'):
    if not hasattr(getMongoDB, f"{cfg['db']}_connection"):
        timeout = int(cfg['timeout'] if 'timeout' in cfg and cfg['timeout'] else 10000)
        mongo_cfg = {
            'host':             mongoConnStr(cfg),
            'port':             int(cfg['port']),
            'connectTimeoutMS': timeout,
            'socketTimeoutMS':  timeout,
            'read_preference':  pymongo.read_preferences.ReadPreference.NEAREST
        }
        if cfg.get('ssl', False) and 'ssl_ca_certs' in cfg:
            mongo_cfg.update({'ssl': True, 'ssl_ca_certs': cfg['ssl_ca_certs']})
        setattr(getMongoDB, f"{cfg['db']}_connection", pymongo.MongoClient(**mongo_cfg)[cfg['db']])
    return getattr(getMongoDB, f"{cfg['db']}_connection")
