# -*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import logging
from tvmauth import BlackboxTvmId
from django.conf import settings

from .tvm2 import TVM2Mixin

LOGGER = logging.getLogger(__name__)


class MulcaGateClient(TVM2Mixin):
    def __init__(self):
        TVM2Mixin.__init__(self, BlackboxTvmId.Prod, str(settings.CFG["mulca_gate"]["tvm_id"]))

    def get(self, stid: str) -> str:
        response = self.request(settings.CFG["mulca_gate"]["url"] + stid + '?raw&service=so', timeout=3)
        if response.status_code == 200:
            return response.text
        else:
            LOGGER.error(f"Unable to receive data from MulcaGate (code: {response.status_code}): {response.reason}")
            return ""
