# -*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import os
import os.path
import logging
import psycopg2
from django.conf import settings

LOGGER = logging.getLogger(__name__)


def getPGCredentials(cfg, log_fh=None):
    f, CURDIR = None, f'{settings.ROOT_DIR}'
    dbname = cfg['db'][:len(cfg['db']) - 2] if cfg['db'].endswith('db') else cfg['db']
    try:
        if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
                CURDIR = os.environ['HOME'] if 'HOME' in os.environ else '/root'
        f = open('{0}/.pgpass.{1}'.format(CURDIR, dbname))
        for line in f:
            sf = line.split(':')
            if len(sf) == 5 and sf[2] == cfg['db']:
                cfg['host'], cfg['port'], cfg['user'], cfg['password'] = sf[0], int(sf[1]), sf[3], sf[4].strip()
                break
            elif len(sf) == 2 and sf[0] == cfg['user']:
                cfg['password'] = sf[1].strip()
                break
        f.close()
    except Exception as e:
        LOGGER.error(f"getPGCredentials exception: {e}")


def getPGdb(cfg, mode='read-write'):
    pg = None
    CURDIR = f'{settings.ROOT_DIR}'
    if not os.path.exists('{0}/.pgsql/root.crt'.format(CURDIR)):
        CURDIR = '/root'
    if hasattr(psycopg2, '__libpq_version__'):
        pg = psycopg2.connect(
            dbname=cfg['db'],
            user=cfg['user'],
            password=cfg['password'],
            host=cfg['host'],
            port=cfg['port'],
            sslmode='verify-full',
            sslrootcert=f'{CURDIR}/.pgsql/root.crt',
            target_session_attrs=('read-write' if mode == 'read-write' else 'any'))
    else:
        if ',' in cfg['host']:
            for host in cfg['host'].split(','):
                try:
                    pg = psycopg2.connect(
                        database=cfg['db'],
                        user=cfg['user'],
                        password=cfg['password'],
                        host=host,
                        port=cfg['port'],
                        sslmode='verify-full',
                        sslrootcert=f'{CURDIR}/.pgsql/root.crt')
                    pg_cursor = pg.cursor()
                    pg_cursor.execute("SELECT pg_is_in_recovery()")
                    res = pg_cursor.fetchone()
                    pg_cursor.close()
                    if res and (mode == 'read-write' and not res[0] or mode != 'read-write' and res[0]):
                        return pg
                except Exception as e:
                    LOGGER.error(f"getPGdb exception: {e}")
                    continue
        else:
            pg = psycopg2.connect(
                database=cfg['db'],
                user=cfg['user'],
                password=cfg['password'],
                host=cfg['host'],
                port=cfg['port'],
                sslmode='verify-full',
                sslrootcert=f'{CURDIR}/.pgsql/root.crt')
    return pg
