# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from django.db import migrations
from django.conf import settings


def update_site_name(apps, schema_editor):
    SiteModel = apps.get_model('sites', 'Site')

    SiteModel.objects.update_or_create(
        pk=settings.SITE_ID,
        defaults={'domain': settings.WEB_TOOLS_HOST, 'name': "SO web tools"}
    )


class Migration(migrations.Migration):

    dependencies = [
        ('web_tools', '0002_update_site_name'),
        ('sites',     '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.RunPython(update_site_name),
    ]
