# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from django.db import migrations, models
from django.db.models import deletion


class Migration(migrations.Migration):

    dependencies = [
        ('web_tools', '0003_update_site_name_2'),
        ('auth',      '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='RoleInfo',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, serialize=False, primary_key=True, verbose_name="ID"),
                ),
                (
                    'group',
                    models.ForeignKey("auth.Group", on_delete=deletion.CASCADE, verbose_name="group"),
                ),
                ("title", models.CharField(max_length=255, verbose_name="title")),
                ("lang", models.CharField(max_length=2, verbose_name="language")),
            ],
            options={
                "constraints": [
                    models.UniqueConstraint(
                        name='unique_role_title',
                        fields=['title', 'lang'],
                        opclasses=['varchar_pattern_ops', 'varchar_pattern_ops'])
                ],
                "verbose_name": "role info",
                "verbose_name_plural": "roles info",
            },
        ),
    ]
