# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from django.db import migrations
from django.contrib.auth.models import Group
from mail.so.spamstop.web.ui.web_tools.libs.modules import SO_WEB_MODULES
from mail.so.spamstop.web.ui.web_tools.libs.idm_hooks import IdmHooks


def generateRolesRecords(roles_model, db_alias, lang, records):
    roles = IdmHooks._get_roles(SO_WEB_MODULES, default_lang=lang)
    for role_name, role_title in roles.items():
        group = None
        try:
            group = Group.objects.using(db_alias).get(name=role_name)
        except:
            pass
        if group is not None:
            records.append(roles_model(group=group, title=role_title, lang=lang))


def add_roles(apps, schema_editor):
    # We get the model from the versioned app registry; if we directly import it, it'll be the wrong version
    RolesInfo = apps.get_model("web_tools", "RoleInfo")
    db_alias = schema_editor.connection.alias
    records = []
    generateRolesRecords(RolesInfo, db_alias, 'ru', records)
    generateRolesRecords(RolesInfo, db_alias, 'en', records)
    RolesInfo.objects.using(db_alias).bulk_create(records)


def remove_roles(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    roles = IdmHooks._get_roles(SO_WEB_MODULES)
    for role_name in roles.keys():
        Group.objects.using(db_alias).filter(name=role_name).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('web_tools', '0004_create_roleinfo_model'),
    ]

    operations = [
        migrations.RunPython(add_roles, remove_roles),
    ]
