# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import logging
from django.db import migrations
from django.contrib.auth.models import Group
from mail.so.spamstop.web.ui.web_tools.libs import SO_WEB_MODULES, IdmHooks, getTraceback

LOGGER = logging.getLogger(__name__)


def generateRolesRecords(roles_model, db_alias, lang, records, is_new_format):
    roles = IdmHooks._get_roles(SO_WEB_MODULES, default_lang=lang)
    for role_name, role_title in roles.items():
        group = created = None
        if role_name.startswith('group-'):
            if is_new_format:
                new_role_name = role_name[6:]
                old_role_name = role_name
            else:
                new_role_name = role_name
                old_role_name = role_name[6:]
            try:
                group, created = Group.objects.using(db_alias).get_or_create(name=new_role_name)
            except Exception as e:
                LOGGER.warning(
                    f"Migration #0007: group '{new_role_name}' does not exist. Error: {e}.\t{getTraceback()}")
            if group is None:
                LOGGER.warning(f"Migration #0007: group '{new_role_name}' is None.")
            else:
                LOGGER.warning(
                    f"Migration #0007: group '{new_role_name}': {type(group)}. Group: {group}. Created: {created}.")
                records.append(roles_model(group_id=group.id, title=role_title, lang=lang))
            try:
                Group.objects.using(db_alias).filter(name=old_role_name).delete()
            except Exception as e:
                LOGGER.warning(
                    f"Migration #0007: unable to delete group '{old_role_name}'. Error: {e}.\t{getTraceback()}")


class ChangeRoles:
    def __init__(self, is_new_format):
        self.isNewFormat = is_new_format

    def __call__(self, apps, schema_editor):
        # We get the model from the versioned app registry; if we directly import it, it'll be the wrong version
        RolesInfo = apps.get_model("web_tools", "RoleInfo")
        db_alias = schema_editor.connection.alias
        records = []
        generateRolesRecords(RolesInfo, db_alias, 'ru', records, self.isNewFormat)
        generateRolesRecords(RolesInfo, db_alias, 'en', records, self.isNewFormat)
        RolesInfo.objects.using(db_alias).bulk_create(records)


class Migration(migrations.Migration):

    dependencies = [
        ('web_tools', '0006_banmodel_alter_roleinfo_group_alter_roleinfo_id_and_more'),
    ]

    operations = [
        migrations.RunPython(ChangeRoles(True), ChangeRoles(False)),
    ]
