# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
from django.db import models
from django.contrib.auth.models import Group
from django.utils.translation import gettext_lazy as _


class RoleInfo(models.Model):
    group = models.ForeignKey(Group, on_delete=models.CASCADE, related_name="role_info")
    title = models.CharField(_("title"), max_length=255, null=True)
    lang = models.CharField(_("lang"), max_length=2, null=True)

    class Meta:
        verbose_name = _("role info")
        verbose_name_plural = _("roles info")
        constraints = [
            models.UniqueConstraint(
                name='unique_role_title',
                fields=['title', 'lang'],
                opclasses=['varchar_pattern_ops', 'varchar_pattern_ops'])
        ]

    def __str__(self):
        return self.title if self.title is not None else self.group.name
