function GetShinglesByTexts(texts) {
    const requestData = {
        texts: texts,
    };

    return fetch(window.location.pathname + '/shingles', {
        body: JSON.stringify(requestData),
        method: 'POST',
        headers: {"X-CSRFToken": getCookie("csrftoken")}
    })
        .then((response) => {
            return response.json();
        })
        .then((data) => {
            return data["shingles"];
        });
}

function getCookie(name) {
    if (document.cookie && document.cookie !== '') {
        const cookies = document.cookie.split(';');
        for (let i = 0; i < cookies.length; i++) {
            const cookie = cookies[i].trim();
            // Does this cookie string begin with the name we want?
            if (cookie.substring(0, name.length + 1) === (name + '=')) {
                return decodeURIComponent(cookie.substring(name.length + 1));
            }
        }
    }
    return null;
}

function SoType(repr) {
    this.repr = repr;
}

SoType.IN = new SoType("in");
SoType.OUT = new SoType("out");

function SendWeights(shingles, type, weight, soType, isMalic, duration, tags, who) {
    const params = {
        "shingles": shingles,
        "user": who,
        "weight": weight,
        "so_type": soType.repr,
        "should_be_malic": isMalic ? 1 : 0,
        "type": type,
        "duration": duration,
        "tags": tags
    };
    console.log("sent data", params);

    return fetch(window.location.pathname + '/weights', {
        body: JSON.stringify(params),
        method: 'POST',
        headers: {"X-CSRFToken": getCookie("csrftoken")}
    });
}

function FetchUserWeights() {
    return fetch(window.location.pathname + '/fetch_user_weights', {
        method: 'GET',
        headers: {"X-CSRFToken": getCookie("csrftoken")}
    })
        .then((response) => {
            return response.json();
        })
        .then(jsonResponse => {
            return jsonResponse["weights"];
        });
}
