# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import absolute_import
import logging
from django import template
from django.contrib.auth import get_user_model
from django.contrib.auth.models import Group
from django.db.models import Q
# from django.shortcuts import get_object_or_404
from django.core.exceptions import PermissionDenied
from django_yauth.user import YandexUser
from django_idm_api.exceptions import RoleNotFound  # , UserNotFound

LOGGER = logging.getLogger(__name__)
register = template.Library()


@register.filter(name='has_group')
def has_group(yauser: YandexUser, group_name: str) -> bool:
    LOGGER.warning(f"User: {yauser}. Group: {group_name}.")
    user = None
    try:
        user = get_user_model().objects.get(username=yauser.login)
    except get_user_model().DoesNotExist:
        # raise UserNotFound(f'User does not exist: {yauser.login}')
        # user = get_object_or_404(get_user_model(), username=yauser.login)
        raise PermissionDenied
    if user.is_superuser:
        return True
    elif group_name == 'superuser':
        return False
    try:
        Group.objects.get(name=group_name)
    except Group.DoesNotExist:
        raise RoleNotFound(f'Group does not exist: {group_name}')
    return Group.objects.all().filter(Q(user=user) & Q(name=group_name)).exists()
    # return user.groups.filter(name=group_name).exists()
