# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
from django.conf import settings
from django.urls import path

import mail.so.spamstop.web.ui.web_tools.views as views

app_label = 'mail.so.spamstop.web.ui.web_tools'

urlpatterns = [
    path(
        'complshingler/ban_shingles',
        views.ComplView.as_view(extra_context={'title': "Ban shingles"}),
        name='complshingler'),
    path('complshingler/unban', views.UnbanView.as_view(extra_context={'title': "Unban shingles"}), name='unban'),
    path('complshingler/ban_shingles/shingles', views.request_shingles, name='ban_shingles.shingles'),
    path(
        'complshingler/ban_shingles/fetch_user_weights',
        views.fetch_user_weights,
        name='ban_shingles.fetch_user_weights'),
    path('complshingler/ban_shingles/weights', views.set_weights,      name='ban_shingles.weights'),
    path('complshingler/unban/shingles',       views.request_shingles, name='unban.shingles'),
    path('complshingler/unban/weights',        views.set_weights,      name='unban.weights'),
    path(
        settings.CFG['root_url'] + 'getbyid',
        views.GetByIdView.as_view(extra_context={'title': "Get deliverylog by ID"}),
        name='getbyid'),
    path(
        settings.CFG['root_url'] + settings.CFG['showrule']['path'],
        views.ShowRuleView.as_view(extra_context={'title': "SOLOG ShowRule"}),
        name='showrule'),
    path(
        settings.CFG['root_url'] + settings.CFG['statrules']['path'],
        views.StatRulesView.as_view(extra_context={'title': "SOLOG Statrules"}),
        name='statrules'),
    path(
        settings.CFG['root_url'] + 'rules_diff',
        views.RulesDiffView.as_view(extra_context={'title': "Differences between sets of rules"}),
        name='rules_diff'),
    path(
        settings.CFG['root_url'] + 'rules_diff2',
        views.RulesDiff2View.as_view(
            extra_context={'title': "Сравнение наборов правил на предмет их общего подмножества"}
        ),
        name='rules_diff2'),
    path(
        settings.CFG['root_url'] + 'deliverylogs_diff',
        views.DeliveryLogsDiffView.as_view(extra_context={'title': "Сравнение правил из деливерилогов"}),
        name='deliverylogs_diff'),
    path(
        settings.CFG['root_url'] + 'check_rules',
        views.CheckRulesView.as_view(extra_context={'title': "Проверка правил СО"}),
        name='check_rules'),
    path(
        settings.CFG['root_url'] + 'check_af_rules',
        views.CheckAfRulesView.as_view(extra_context={'title': "Проверка правил Антифрода"}),
        name='check_af_rules'),
    path(
        settings.CFG['root_url'] + 'user_abuses',
        views.UserAbusesView.as_view(extra_context={'title': "Жалобы и другие действия пользователя"}),
        name='user_abuses'),
    path(
        settings.CFG['root_url'] + 'stid_show',
        views.StidShowView.as_view(extra_context={'title': "Show message for stid"}),
        name='stid_show'),
    path(
        settings.CFG['root_url'],
        views.IndexView.as_view(extra_context={'title': "Yandex Spamooborona's Tools"}),
        name='index'),
]
