# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import re
import logging
from django.conf import settings
from django.views.generic import TemplateView
from django.http import HttpResponse
from mail.so.spamstop.web.ui.web_tools.libs import (
    class_based_login_required, getUUID, CheckingRepoContext, verifyAFRules,
)

LOGGER = logging.getLogger(__name__)
RULES = settings.CFG["af_rules"]


def changeRow(row):
    r = settings.RE["bash_trace"].sub(r'', row)
    if r and settings.RE["rules_results"].match(r):
        r = f"<b>{r}</b>"
    return r


@class_based_login_required
class CheckAfRulesView(TemplateView):
    template_name = "check_af_rules.html"

    def dispatch(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"Request: {request}")
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        self.text = ''
        self.faultRulesCnt = 0
        with CheckingRepoContext(RULES['check_lock_path']):
            # verification of rules in 'antifraud' folder
            self.text, self.faultRulesCnt = verifyAFRules(getUUID(), "", RULES["folder_name"])
            self.text = settings.RE["exception"].sub(r'\n<p style="color: #FF0000;"><b>\1</b></p>', self.text)
            self.text = '<br />'.join(filter(lambda x: x, map(lambda r: changeRow(r), self.text.split('\n'))))
        return super(CheckAfRulesView, self).dispatch(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(CheckAfRulesView, self).get_context_data(**kwargs)
        context["text"] = self.text
        context["fault_rules_cnt"] = self.faultRulesCnt
        return context
