# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import re
import logging
from django.conf import settings
from django.views.generic import TemplateView
from django.http import HttpResponse
from mail.so.spamstop.web.ui.web_tools.libs import (
    class_based_login_required, getUUID, RULES_TYPES, CheckingRepoContext, verifyRules,
)

LOGGER = logging.getLogger(__name__)


def changeRow(row):
    r = settings.RE["rules_folder"].sub(' ', row)
    # r = settings.RE["rules_timestamp"].sub(r'', r)
    r = settings.RE["rules_timestamp2"].sub(r'', r)
    if settings.RE["rules_results"].match(r):
        r = f"<b>{r}</b>"
    return r


@class_based_login_required
class CheckRulesView(TemplateView):
    template_name = "check_rules.html"

    def dispatch(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"Request: {request}")
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        self.route = request.GET.get("route", "In")
        self.text = ''
        self.fault_rules_cnt = 0
        with CheckingRepoContext(settings.CFG["so_rules"]['check_lock_path']):
            self.text, self.fault_rules_cnt = verifyRules(getUUID(), self.route)
            self.text = '<br />'.join(map(lambda r: changeRow(r), self.text.split('\n')))
        return super(CheckRulesView, self).dispatch(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(CheckRulesView, self).get_context_data(**kwargs)
        context["route"] = self.route
        context["text"] = self.text
        context["fault_rules_cnt"] = self.fault_rules_cnt
        context["routes"] = list(map(lambda rt: (rt[0], rt[1]), RULES_TYPES))
        LOGGER.warning(f'Route: {context["route"]}. Routes: {context["routes"]}')
        return context
