# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import os
import os.path
import re
import logging
from tempfile import mkstemp, mkdtemp
from collections import defaultdict
from django.conf import settings
from django.views.generic import TemplateView
from django.http import HttpResponse
from mail.so.spamstop.web.ui.web_tools.libs import class_based_login_required

LOGGER = logging.getLogger(__name__)


def loadDlvLog(f, rules_diff: dict, rules_stat: dict, i: int = 0) -> None:
    if not f:
        return
    row = f.readline()
    while row:
        if re.match(r'mess: \w+\s+\d+', row):
            queueid = msgid = ''
        elif row.startswith('X-Yandex-QueueID: '):
            m = re.match(r'X-Yandex-QueueID: (\S+)', row)
            if m and m.group(1):
                queueid = m.group(1)
        elif row.startswith('messageid: '):
            m = re.match(r'messageid: (\S+)', row)
            if m and m.group(1):
                msgid = m.group(1)
        elif row.startswith('r_sp: ') and queueid and msgid:
            m = re.match(r'^r_sp: (.*)$', row)
            if m and m.group(1):
                for rule in m.group(1).split(', '):
                    if rule:
                        rules_diff["%s_%s" % (queueid, msgid)].add(rule.split()[0])
                        rules_stat[rule.split()[0]][i] += 1
        elif row.startswith('r_dl: ') and queueid and msgid:
            m = re.match(r'^r_dl: (.*)$', row)
            if m and m.group(1):
                for rule in m.group(1).split(', '):
                    if rule:
                        rules_diff["%s_%s" % (queueid, msgid)].add(rule.split()[0])
                        rules_stat[rule.split()[0]][i] += 1
        elif row.startswith('r_nl: ') and queueid and msgid:
            m = re.match(r'^r_nl: (.*)$', row)
            if m and m.group(1):
                for rule in m.group(1).split(', '):
                    if rule:
                        rules_diff["%s_%s" % (queueid, msgid)].add(rule.split(',')[0])
                        rules_stat[rule.split(',')[0]][i] += 1
        row = f.readline()


def saveUploadedFile(form_file, fout):
    if not form_file.file:
        return
    while 1:
        chunk = form_file.file.read(100000)
        if not chunk:
            break
        fout.write(chunk)
    fout.close()


@class_based_login_required
class DeliveryLogsDiffView(TemplateView):
    template_name = "deliverylogs_diff.html"

    def dispatch(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"Request: {request}")
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        self.action = request.GET.get("action", "show")
        if self.action == 'show':
            self.file_type1 = request.GET.get('file_type1', 'file')
            self.file_type2 = request.GET.get('file_type2', 'file')
            self.filename1 = request.GET.get('dlvlog1', '')
            self.filename2 = request.GET.get('dlvlog2', '')
            d = request.GET.get('hash', '')
            self.rules = defaultdict(lambda: [0, 0, 0, 0])
            self.rules1 = defaultdict(lambda: set())
            self.rules2 = defaultdict(lambda: set())
            self.n, self.data = 0, []
            d = settings.CFG["tmp_dir"] + '/' + d + ('' if d == '' else '/')
            if 'dlvlog1' in request.GET:
                if self.file_type1 == 'file':
                    loadDlvLog(open(d + self.filename1), self.rules1, self.rules, 0)
                    os.unlink(d + self.filename1)
                elif self.file_type1 == 'SCP':
                    tmpfile1, tmp_filename1 = mkstemp(text=True)
                    os.system(f"scp -i {settings.ROOT_DIR}/rules-key/id_rsa robot-mailspam@{request.GET.get('dlvlog1', '')} " +
                              f"{tmp_filename1}")
                    loadDlvLog(os.fdopen(tmpfile1), self.rules1, self.rules, 0)
                    os.unlink(tmp_filename1)
            if 'dlvlog2' in request.GET:
                if self.file_type2 == 'file':
                    loadDlvLog(open(d + self.filename2), self.rules2, self.rules, 1)
                    os.unlink(d + self.filename2)
                elif self.file_type2 == 'SCP':
                    tmpfile2, tmp_filename2 = mkstemp(text=True)
                    os.system(f"scp -i {settings.ROOT_DIR}/rules-key/id_rsa robot-mailspam@{request.GET.get('dlvlog2', '')} " +
                              f"{tmp_filename2}")
                    loadDlvLog(os.fdopen(tmpfile2), self.rules2, self.rules, 1)
                    os.unlink(tmp_filename2)
            if self.file_type1 == 'file' or self.file_type2 == 'file':
                try:
                    os.rmdir(d)
                except:
                    pass
            for (k, v) in self.rules1.items():
                if k not in self.rules2:
                    continue
                self.n += 1
                self.data.append({
                    'queueid': k[:k.find('_')],
                    'msgid': k[(k.find('_') + 1):],
                    'deliverylog_rules1': ', '.join(v - self.rules2[k]),
                    'deliverylog_rules2': ', '.join(self.rules2[k] - v)
                })
                for rule in (v - self.rules2[k]):
                    self.rules[rule][2] += 1
                for rule in (self.rules2[k] - v):
                    self.rules[rule][3] += 1
        elif self.action == 'upload_file':
            h = request.GET.get('hash', '')
            if h:
                d = settings.CFG["tmp_dir"] + '/' + h
            else:
                d = mkdtemp(dir=settings.CFG["tmp_dir"] + '/')
                h = d[(d.rfind('/') + 1):]
            saveUploadedFile(request.FILES['file'], open(os.path.join(d, request.FILES['file'].name), 'wb'))
            LOGGER.warning(f'{"hash": "{h}"}')
        return super(DeliveryLogsDiffView, self).dispatch(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(DeliveryLogsDiffView, self).get_context_data(**kwargs)
        context["uri"] = self.uri
        if self.action == 'show':
            context["showrule_path"] = '/' + settings.CFG['showrule']['path']
            context["data"] = self.data
            context["rules"] = sorted(
                filter(
                    lambda r: r[1] + r[2] + r[3] + r[4] > 0,
                    map(lambda it: [it[0], it[1][0], it[1][1], it[1][2], it[1][3]], self.rules.items())),
                key=lambda r: r[1],
                reverse=True)
            context["info"] = {
                'dlvlog_recs1': len(self.rules1.keys()),
                'dlvlog_recs2': len(self.rules2.keys()),
                'intersec_recs': self.n
            }
        return context
