# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import re
import logging
from django.conf import settings
from django.http import HttpRequest, HttpResponse
from django.views.generic import TemplateView

from mail.so.spamstop.web.ui.web_tools.libs import class_based_login_required

LOGGER = logging.getLogger(__name__)


@class_based_login_required
class IndexView(TemplateView):
    template_name = "index.html"

    def setup(self, request: HttpRequest, *args, **kwargs) -> None:
        super(IndexView, self).setup(request, *args, **kwargs)
        self.root_url = settings.CFG['root_url']

    def dispatch(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"Request: {request}")
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        return super(IndexView, self).dispatch(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(IndexView, self).get_context_data(**kwargs)
        context['uri'] = self.uri
        context['root_url'] = self.root_url
        return context
