# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import re
import logging
from django.conf import settings
from django.views.generic import TemplateView
from django.http import HttpResponse
from mail.so.spamstop.web.ui.web_tools.libs import class_based_login_required

LOGGER = logging.getLogger(__name__)
RULES_RE = re.compile(r'[\s\(]*([A-Z_][\dA-Z_]+)[^\dA-Z_]*')


@class_based_login_required
class RulesDiffView(TemplateView):
    template_name = "rules_diff.html"

    def _prepare_result(self, request):
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        self.rules01 = {}
        self.rules02 = {}
        self.rules1 = {}
        self.rules2 = {}
        self.rules3 = {}
        for _rule in RULES_RE.findall(self.rules_set1):
            self.rules01[_rule] = 1
        for _rule in RULES_RE.findall(self.rules_set2):
            self.rules02[_rule] = 1
        for _rule in self.rules01:
            if _rule in self.rules02:
                self.rules2[_rule] = 1
            else:
                self.rules1[_rule] = 1
        for _rule in self.rules02:
            if _rule not in self.rules01:
                self.rules3[_rule] = 1

    def get(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"GET request: {request}")
        self.rules_set1 = request.GET.get('rules_set1', '')
        self.rules_set2 = request.GET.get('rules_set2', '')
        self._prepare_result(request)
        return super(RulesDiffView, self).get(request, *args, **kwargs)

    def post(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"POST request: {request}")
        self.rules_set1 = request.POST.get('rules_set1', '')
        self.rules_set2 = request.POST.get('rules_set2', '')
        self._prepare_result(request)
        return super(RulesDiffView, self).get(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(RulesDiffView, self).get_context_data(**kwargs)
        context["uri"] = self.uri
        context["rules1"] = sorted(self.rules1.keys())
        context["rules2"] = sorted(self.rules2.keys())
        context["rules3"] = sorted(self.rules3.keys())
        context["showrule_path"] = '/' + settings.CFG['showrule']['path']
        return context
