# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import re
import logging
from functools import cmp_to_key
from django.conf import settings
from django.views.generic import TemplateView
from django.http import HttpResponse
from mail.so.spamstop.web.ui.web_tools.libs import class_based_login_required

LOGGER = logging.getLogger(__name__)
RULES_RE = re.compile(r'[\s\(]*([A-Z_][\dA-Z_]+)[^\dA-Z_]*')


@class_based_login_required
class RulesDiff2View(TemplateView):
    template_name = "rules_diff2.html"

    def _prepare_result(self, request, data):
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        self.field_count = int(data.get('field_count', '10'))
        self.min_limit = data.get('min_limit', '2')
        self.gether = data.get('gether', '')
        self.f, n, r, self.rules1, self.rules2 = [], 0, {}, {}, {}
        for i in range(self.field_count):
            self.f.append(data.get(f'f{i}', ''))
            if not self.f[i]:
                n += 1
                for _rule in RULES_RE.findall(self.f[i]):
                    if _rule in self.r:
                        r[_rule][f'f{i}'] += 1
                    else:
                        r[_rule] = {f'f{i}': 1}
        for _rule in r.keys():
            k = len(r[_rule])
            if k == n:
                self.rules1[_rule] = k
            elif k >= self.min_limit:
                self.rules2[_rule] = k

    def get(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"GET request: {request}")
        self._prepare_result(request, request.GET)
        return super(RulesDiff2View, self).get(request, *args, **kwargs)

    def post(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"POST request: {request}")
        self._prepare_result(request, request.POST)
        return super(RulesDiff2View, self).get(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(RulesDiff2View, self).get_context_data(**kwargs)
        context["uri"] = self.uri
        context["field_count"] = self.field_count
        context["min_limit"] = self.min_limit
        context["gether"] = self.gether
        context["f"] = self.f
        context["showrule_path"] = '/' + settings.CFG['showrule']['path']
        context["rules1"] = sorted(self.rules1.items(), key=cmp_to_key(lambda a, b: a[1] - b[1]))
        context["rules2"] = sorted(self.rules2.items(), key=cmp_to_key(lambda a, b: a[1] - b[1]))
        context["rules_set1"] = map(lambda r: r[0], self.rules1)
        context["rules_set2"] = map(lambda r: r[0], self.rules2)
        return context
